/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    private final Attributes EMPTY_ATTS;
    private Hashtable prefixTable;
    private Hashtable forcedDeclTable;
    private Hashtable doneDeclTable;
    private int elementLevel;
    private Writer output;
    private NamespaceSupport nsSupport;
    private int prefixCounter;
    private boolean htmlMode;
    private boolean cdataElement;

    private /* synthetic */ void finit$() {
        this.EMPTY_ATTS = new AttributesImpl();
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.htmlMode = false;
        this.cdataElement = false;
    }

    public XMLWriter() {
        this.finit$();
        this.init(null);
    }

    public XMLWriter(Writer writer) {
        this.finit$();
        this.init(writer);
    }

    public XMLWriter(XMLReader xMLReader) {
        super(xMLReader);
        this.finit$();
        this.init(null);
    }

    public XMLWriter(XMLReader xMLReader, Writer writer) {
        super(xMLReader);
        this.finit$();
        this.init(writer);
    }

    private void init(Writer writer) {
        this.setOutput(writer);
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new Hashtable();
        this.forcedDeclTable = new Hashtable();
        this.doneDeclTable = new Hashtable();
    }

    public void reset() {
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.nsSupport.reset();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String string, String string2) {
        this.prefixTable.put(string, string2);
    }

    public String getPrefix(String string) {
        return (String)this.prefixTable.get(string);
    }

    public void forceNSDecl(String string) {
        this.forcedDeclTable.put(string, Boolean.TRUE);
    }

    public void forceNSDecl(String string, String string2) {
        this.setPrefix(string, string2);
        this.forceNSDecl(string);
    }

    public void startDocument() throws SAXException {
        this.reset();
        if (!this.htmlMode) {
            this.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n\n");
        }
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.write('\n');
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.elementLevel;
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        if (this.htmlMode && (string2.equals("script") || string2.equals("style"))) {
            this.cdataElement = true;
        }
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!(this.htmlMode && string.equals("http://www.w3.org/1999/xhtml") && (string2.equals("area") || string2.equals("base") || string2.equals("basefont") || string2.equals("br") || string2.equals("col") || string2.equals("frame") || string2.equals("hr") || string2.equals("img") || string2.equals("input") || string2.equals("isindex") || string2.equals("link") || string2.equals("meta") || string2.equals("param")))) {
            this.write("</");
            this.writeName(string, string2, string3, true);
            this.write('>');
        }
        if (this.elementLevel == 1) {
            this.write('\n');
        }
        this.cdataElement = false;
        super.endElement(string, string2, string3);
        this.nsSupport.popContext();
        --this.elementLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.cdataElement) {
            this.writeEsc(cArray, n, n2, false);
        } else {
            for (int i = n; i < n + n2; ++i) {
                this.write(cArray[i]);
            }
        }
        super.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.writeEsc(cArray, n, n2, false);
        super.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?");
        this.write(string);
        this.write(' ');
        this.write(string2);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write('\n');
        }
        super.processingInstruction(string, string2);
    }

    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write("/>");
        super.startElement(string, string2, string3, attributes);
        super.endElement(string, string2, string3);
    }

    public void startElement(String string, String string2) throws SAXException {
        this.startElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void startElement(String string) throws SAXException {
        this.startElement("", string, "", this.EMPTY_ATTS);
    }

    public void endElement(String string, String string2) throws SAXException {
        this.endElement(string, string2, "");
    }

    public void endElement(String string) throws SAXException {
        this.endElement("", string, "");
    }

    public void emptyElement(String string, String string2) throws SAXException {
        this.emptyElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void emptyElement(String string) throws SAXException {
        this.emptyElement("", string, "", this.EMPTY_ATTS);
    }

    public void dataElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.characters(string4);
        this.endElement(string, string2, string3);
    }

    public void dataElement(String string, String string2, String string3) throws SAXException {
        this.dataElement(string, string2, "", this.EMPTY_ATTS, string3);
    }

    public void dataElement(String string, String string2) throws SAXException {
        this.dataElement("", string, "", this.EMPTY_ATTS, string2);
    }

    public void characters(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    private void forceNSDecls() {
        Enumeration enumeration = this.forcedDeclTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.doPrefix(string, null, true);
        }
    }

    private String doPrefix(String string, String string2, boolean bl) {
        String string3 = this.nsSupport.getURI("");
        if ("".equals(string)) {
            if (bl && string3 != null) {
                this.nsSupport.declarePrefix("", "");
            }
            return null;
        }
        String string4 = bl && string3 != null && string.equals(string3) ? "" : this.nsSupport.getPrefix(string);
        if (string4 != null) {
            return string4;
        }
        string4 = (String)this.doneDeclTable.get(string);
        if (string4 != null && ((!bl || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && (string4 = (String)this.prefixTable.get(string)) != null && ((!bl || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && string2 != null && !"".equals(string2)) {
            int n = string2.indexOf(58);
            if (n == -1) {
                if (bl && string3 == null) {
                    string4 = "";
                }
            } else {
                string4 = string2.substring(0, n);
            }
        }
        while (string4 == null || this.nsSupport.getURI(string4) != null) {
            string4 = "__NS" + ++this.prefixCounter;
        }
        this.nsSupport.declarePrefix(string4, string);
        this.doneDeclTable.put(string, string4);
        return string4;
    }

    private void write(char c) throws SAXException {
        try {
            this.output.write(c);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void write(String string) throws SAXException {
        try {
            this.output.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void writeAttributes(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            char[] cArray = attributes.getValue(i).toCharArray();
            this.write(' ');
            this.writeName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), false);
            this.write("=\"");
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] cArray, int n, int n2, boolean bl) throws SAXException {
        block6: for (int i = n; i < n + n2; ++i) {
            switch (cArray[i]) {
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        continue block6;
                    }
                    this.write('\"');
                    continue block6;
                }
                default: {
                    if (cArray[i] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(cArray[i]));
                        this.write(';');
                        continue block6;
                    }
                    this.write(cArray[i]);
                }
            }
        }
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> enumeration = this.nsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = this.nsSupport.getURI(string);
            if (string2 == null) {
                string2 = "";
            }
            char[] cArray = string2.toCharArray();
            this.write(' ');
            if ("".equals(string)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(string);
                this.write("=\"");
            }
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeName(String string, String string2, String string3, boolean bl) throws SAXException {
        String string4 = this.doPrefix(string, string3, bl);
        if (string4 != null && !"".equals(string4)) {
            this.write(string4);
            this.write(':');
        }
        this.write(string2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.write("<!--");
        for (int i = n; i < n + n2; ++i) {
            this.write(cArray[i]);
            if (cArray[i] != '-' || i + 1 > n + n2 || cArray[i + 1] != '-') continue;
            this.write(' ');
        }
        this.write("-->");
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public boolean getHTMLMode() {
        return this.htmlMode;
    }

    public void setHTMLMode(boolean bl) {
        this.htmlMode = bl;
    }
}

