/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Tag;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.HasParentFilter;
import org.htmlparser.filters.OrFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.util.NodeList;

public class CssSelectorNodeFilter
implements NodeFilter {
    private static Pattern tokens = Pattern.compile("(/\\*.*?\\*/) | (   \".*?[^\"]\" | '.*?[^']' | \"\" | '' ) | ( [\\~\\*\\$\\^]? = ) | ( [a-zA-Z_\\*](?:[a-zA-Z0-9_-]|\\\\.)* ) | \\s*( [+>~\\s] )\\s* | ( [\\.\\[\\]\\#\\:)(] ) | ( [\\,] ) | ( . )", 38);
    private static final int COMMENT = 1;
    private static final int QUOTEDSTRING = 2;
    private static final int RELATION = 3;
    private static final int NAME = 4;
    private static final int COMBINATOR = 5;
    private static final int DELIM = 6;
    private static final int COMMA = 7;
    private NodeFilter therule;
    private Matcher m = null;
    private int tokentype = 0;
    private String token = null;

    public CssSelectorNodeFilter(String selector) {
        this.m = tokens.matcher(selector);
        if (this.nextToken()) {
            this.therule = this.parse();
        }
    }

    public boolean accept(Node n) {
        return this.therule.accept(n);
    }

    private boolean nextToken() {
        if (this.m != null && this.m.find()) {
            for (int i = 1; i < this.m.groupCount(); ++i) {
                if (this.m.group(i) == null) continue;
                this.tokentype = i;
                this.token = this.m.group(i);
                return true;
            }
        }
        this.tokentype = 0;
        this.token = null;
        return false;
    }

    private NodeFilter parse() {
        NodeFilter n = null;
        do {
            switch (this.tokentype) {
                case 1: 
                case 4: 
                case 6: {
                    if (n == null) {
                        n = this.parseSimple();
                        break;
                    }
                    n = new AndFilter(n, this.parseSimple());
                    break;
                }
                case 5: {
                    switch (this.token.charAt(0)) {
                        case '+': {
                            n = new AdjacentFilter(n);
                            break;
                        }
                        case '>': {
                            n = new HasParentFilter(n);
                            break;
                        }
                        default: {
                            n = new HasAncestorFilter(n);
                        }
                    }
                    this.nextToken();
                    break;
                }
                case 7: {
                    n = new OrFilter(n, this.parse());
                    this.nextToken();
                }
            }
        } while (this.token != null);
        return n;
    }

    private NodeFilter parseSimple() {
        boolean done = false;
        NodeFilter n = null;
        if (this.token != null) {
            do {
                switch (this.tokentype) {
                    case 1: {
                        this.nextToken();
                        break;
                    }
                    case 4: {
                        n = "*".equals(this.token) ? new YesFilter() : (n == null ? new TagNameFilter(CssSelectorNodeFilter.unescape(this.token)) : new AndFilter(n, new TagNameFilter(CssSelectorNodeFilter.unescape(this.token))));
                        this.nextToken();
                        break;
                    }
                    case 6: {
                        switch (this.token.charAt(0)) {
                            case '.': {
                                this.nextToken();
                                if (this.tokentype != 4) {
                                    throw new IllegalArgumentException("Syntax error at " + this.token);
                                }
                                if (n == null) {
                                    n = new HasAttributeFilter("class", CssSelectorNodeFilter.unescape(this.token));
                                    break;
                                }
                                n = new AndFilter(n, new HasAttributeFilter("class", CssSelectorNodeFilter.unescape(this.token)));
                                break;
                            }
                            case '#': {
                                this.nextToken();
                                if (this.tokentype != 4) {
                                    throw new IllegalArgumentException("Syntax error at " + this.token);
                                }
                                if (n == null) {
                                    n = new HasAttributeFilter("id", CssSelectorNodeFilter.unescape(this.token));
                                    break;
                                }
                                n = new AndFilter(n, new HasAttributeFilter("id", CssSelectorNodeFilter.unescape(this.token)));
                                break;
                            }
                            case ':': {
                                this.nextToken();
                                if (n == null) {
                                    n = this.parsePseudoClass();
                                    break;
                                }
                                n = new AndFilter(n, this.parsePseudoClass());
                                break;
                            }
                            case '[': {
                                this.nextToken();
                                n = n == null ? this.parseAttributeExp() : new AndFilter(n, this.parseAttributeExp());
                            }
                        }
                        this.nextToken();
                        break;
                    }
                    default: {
                        done = true;
                    }
                }
            } while (!done && this.token != null);
        }
        return n;
    }

    private NodeFilter parsePseudoClass() {
        throw new IllegalArgumentException("pseudoclasses not implemented yet");
    }

    private NodeFilter parseAttributeExp() {
        NodeFilter n = null;
        if (this.tokentype == 4) {
            String attrib = this.token;
            this.nextToken();
            if ("]".equals(this.token)) {
                n = new HasAttributeFilter(CssSelectorNodeFilter.unescape(attrib));
            } else if (this.tokentype == 3) {
                String val = null;
                String rel = this.token;
                this.nextToken();
                if (this.tokentype == 2) {
                    val = CssSelectorNodeFilter.unescape(this.token.substring(1, this.token.length() - 1));
                } else if (this.tokentype == 4) {
                    val = CssSelectorNodeFilter.unescape(this.token);
                }
                if ("~=".equals(rel) && val != null) {
                    n = new AttribMatchFilter(CssSelectorNodeFilter.unescape(attrib), "\\b" + val.replaceAll("([^a-zA-Z0-9])", "\\\\$1") + "\\b");
                } else if ("=".equals(rel) && val != null) {
                    n = new HasAttributeFilter(attrib, val);
                }
            }
        }
        if (n == null) {
            throw new IllegalArgumentException("Syntax error at " + this.token + this.tokentype);
        }
        this.nextToken();
        return n;
    }

    public static String unescape(String escaped) {
        StringBuffer result = new StringBuffer(escaped.length());
        Matcher m = Pattern.compile("\\\\(?:([a-fA-F0-9]{2,6})|(.))").matcher(escaped);
        while (m.find()) {
            if (m.group(1) != null) {
                m.appendReplacement(result, String.valueOf((char)Integer.parseInt(m.group(1), 16)));
                continue;
            }
            if (m.group(2) == null) continue;
            m.appendReplacement(result, m.group(2));
        }
        m.appendTail(result);
        return result.toString();
    }

    private static class AttribMatchFilter
    implements NodeFilter {
        private Pattern rel;
        private String attrib;

        public AttribMatchFilter(String attrib, String regex) {
            this.rel = Pattern.compile(regex);
            this.attrib = attrib;
        }

        public boolean accept(Node node) {
            if (node instanceof Tag && ((Tag)node).getAttribute(this.attrib) != null) {
                return this.rel == null || this.rel.matcher(((Tag)node).getAttribute(this.attrib)).find();
            }
            return false;
        }
    }

    private static class YesFilter
    implements NodeFilter {
        private YesFilter() {
        }

        public boolean accept(Node n) {
            return true;
        }
    }

    private static class AdjacentFilter
    implements NodeFilter {
        private NodeFilter sibtest;

        public AdjacentFilter(NodeFilter n) {
            this.sibtest = n;
        }

        public boolean accept(Node n) {
            if (n.getParent() != null) {
                NodeList l = n.getParent().getChildren();
                for (int i = 0; i < l.size(); ++i) {
                    if (l.elementAt(i) != n || i <= 0) continue;
                    return this.sibtest.accept(l.elementAt(i - 1));
                }
            }
            return false;
        }
    }

    private static class HasAncestorFilter
    implements NodeFilter {
        private NodeFilter atest;

        public HasAncestorFilter(NodeFilter n) {
            this.atest = n;
        }

        public boolean accept(Node n) {
            while (n != null) {
                if (!this.atest.accept(n = n.getParent())) continue;
                return true;
            }
            return false;
        }
    }
}

