/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.io.Serializable;
import java.util.Date;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.consumer.AbstractNonceVerifier;

public class EhcacheNonceVerifier
extends AbstractNonceVerifier {
    private static Log _log = LogFactory.getLog(EhcacheNonceVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Cache _cache;

    public EhcacheNonceVerifier(int maxAge) {
        super(maxAge);
    }

    public void setCache(Cache cache) {
        if (cache.getTimeToLiveSeconds() != (long)this._maxAgeSeconds) {
            throw new IllegalArgumentException("Max Age: " + this._maxAgeSeconds + ", same expected for cache, but found: " + cache.getTimeToLiveSeconds());
        }
        if (cache.getTimeToLiveSeconds() != cache.getTimeToIdleSeconds()) {
            throw new IllegalArgumentException("Cache must have same timeToLive (" + cache.getTimeToLiveSeconds() + ") as timeToIdle (" + cache.getTimeToIdleSeconds() + ")");
        }
        this._cache = cache;
    }

    protected int seen(Date now, String opUrl, String nonce) {
        String pair = opUrl + '#' + nonce;
        Element element = new Element((Serializable)((Object)pair), (Serializable)((Object)pair));
        if (this._cache.get((Serializable)((Object)pair)) != null) {
            _log.error((Object)("Possible replay attack! Already seen nonce: " + nonce));
            return 1;
        }
        this._cache.put(element);
        if (DEBUG) {
            _log.debug((Object)("Nonce verified: " + nonce));
        }
        return 0;
    }
}

