/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcConsumerAssociationStore
extends JdbcDaoSupport
implements ConsumerAssociationStore {
    private static Log _log = LogFactory.getLog(JdbcConsumerAssociationStore.class);
    private String _tableName;
    private String _sqlInsert;
    private String _sqlDelete;
    private String _sqlCleanup;
    private String _sqlSelect;
    private String _sqlSelectAlt;

    public JdbcConsumerAssociationStore() {
    }

    public JdbcConsumerAssociationStore(String tableName) {
        this.setTableName(tableName);
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
        this._sqlInsert = "INSERT INTO " + this._tableName + " VALUES (?,?,?,?,?)";
        this._sqlDelete = "DELETE FROM " + this._tableName + " WHERE opurl=? AND handle=?";
        this._sqlCleanup = "DELETE FROM " + this._tableName + " WHERE expdate < ?";
        this._sqlSelect = "SELECT * FROM " + this._tableName + " WHERE opurl=? AND handle=?";
        this._sqlSelectAlt = "SELECT * FROM " + this._tableName + " T1 JOIN (SELECT opurl, max(expdate) AS expdate FROM " + this._tableName + " WHERE opurl=? GROUP BY opurl) T2 ON (T1.expdate = T2.expdate AND T1.opurl = T2.opurl)";
    }

    public Association load(String opUrl, String handle) {
        try {
            Association assoc;
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            Map res = jdbcTemplate.queryForMap(this._sqlSelect, new Object[]{opUrl, handle});
            String type = (String)res.get("type");
            String macKey = (String)res.get("mackey");
            Date expDate = (Date)res.get("expdate");
            if (type == null || macKey == null || expDate == null) {
                throw new AssociationException("Invalid association data retrived from database; cannot create Association object for handle: " + handle);
            }
            if ("HMAC-SHA1".equals(type)) {
                assoc = Association.createHmacSha1(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else if ("HMAC-SHA256".equals(type)) {
                assoc = Association.createHmacSha256(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else {
                throw new AssociationException("Invalid association type retrieved from database: " + type);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Retrieved association for handle: " + handle + " from table: " + this._tableName));
            }
            return assoc;
        }
        catch (AssociationException ase) {
            _log.error((Object)("Error retrieving association from table: " + this._tableName), (Throwable)ase);
            return null;
        }
        catch (IncorrectResultSizeDataAccessException rse) {
            _log.warn((Object)("Association not found for handle: " + handle + " in the table: " + this._tableName));
            return null;
        }
        catch (DataAccessException dae) {
            _log.error((Object)("Error retrieving association for handle: " + handle + "from table: " + this._tableName), (Throwable)dae);
            return null;
        }
    }

    public Association load(String opUrl) {
        try {
            Association assoc;
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            Map res = jdbcTemplate.queryForMap(this._sqlSelectAlt, new Object[]{opUrl});
            String handle = (String)res.get("handle");
            String type = (String)res.get("type");
            String macKey = (String)res.get("mackey");
            Date expDate = (Date)res.get("expdate");
            if (expDate == null || (type == null || macKey == null) && !" ".equals(handle)) {
                throw new AssociationException("Invalid expiry date retrived from database; cannot create Association object for handle: " + handle);
            }
            if (" ".equals(handle)) {
                assoc = Association.getFailedAssociation(expDate);
            } else if ("HMAC-SHA1".equals(type)) {
                assoc = Association.createHmacSha1(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else if ("HMAC-SHA256".equals(type)) {
                assoc = Association.createHmacSha256(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else {
                throw new AssociationException("Invalid association type retrieved from database: " + type);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Retrieved association for handle: " + handle + " from table: " + this._tableName));
            }
            return assoc;
        }
        catch (AssociationException ase) {
            _log.error((Object)("Error retrieving association from table: " + this._tableName), (Throwable)ase);
            return null;
        }
        catch (IncorrectResultSizeDataAccessException rse) {
            _log.warn((Object)("Association not found for opUrl: " + opUrl + " in the table: " + this._tableName));
            return null;
        }
        catch (DataAccessException dae) {
            _log.error((Object)("Error retrieving association for opUrl: " + opUrl + "from table: " + this._tableName), (Throwable)dae);
            return null;
        }
    }

    public void remove(String opUrl, String handle) {
        try {
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            int cnt = jdbcTemplate.update(this._sqlDelete, new Object[]{opUrl, handle});
        }
        catch (Exception e) {
            _log.error((Object)("Error removing association from table: " + this._tableName), (Throwable)e);
        }
    }

    public void save(String opUrl, Association association) {
        this.cleanupExpired();
        try {
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            int cnt = jdbcTemplate.update(this._sqlInsert, new Object[]{opUrl, association.getHandle(), association.getType(), association.getMacKey() == null ? null : new String(Base64.encodeBase64((byte[])association.getMacKey().getEncoded())), association.getExpiry()});
        }
        catch (Exception e) {
            _log.error((Object)("Error saving association to table: " + this._tableName), (Throwable)e);
        }
    }

    private void cleanupExpired() {
        try {
            Date boundary = new Date();
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            int cnt = jdbcTemplate.update(this._sqlCleanup, new Object[]{boundary});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Client associations cleanup removed " + cnt + " entries"));
            }
        }
        catch (Exception e) {
            _log.error((Object)("Error cleaning up client associations from table: " + this._tableName), (Throwable)e);
        }
    }
}

