/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.html;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.html.HtmlParser;
import org.openid4java.discovery.html.HtmlResult;
import org.openid4java.util.HttpFetcher;
import org.openid4java.util.HttpFetcherFactory;
import org.openid4java.util.HttpRequestOptions;
import org.openid4java.util.HttpResponse;
import org.openid4java.util.OpenID4JavaUtils;

public class HtmlResolver {
    private static Log _log = LogFactory.getLog(HtmlResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static final String HTML_PARSER_CLASS_NAME_KEY = "discovery.html.parser";
    private static final HtmlParser HTML_PARSER;
    private final HttpFetcher _httpFetcher;
    private int _maxRedirects = 10;

    @Inject
    public HtmlResolver(HttpFetcherFactory httpFetcherFactory) {
        this._httpFetcher = httpFetcherFactory.createFetcher(HttpRequestOptions.getDefaultOptionsForDiscovery());
    }

    public int getMaxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this._maxRedirects = maxRedirects;
    }

    public List discoverHtml(UrlIdentifier identifier) throws DiscoveryException {
        return this.discoverHtml(identifier, this._httpFetcher);
    }

    public List discoverHtml(UrlIdentifier identifier, HttpFetcher httpFetcher) throws DiscoveryException {
        HtmlResult result = new HtmlResult();
        HttpRequestOptions requestOptions = httpFetcher.getRequestOptions();
        requestOptions.setContentType("text/html");
        try {
            HttpResponse resp = httpFetcher.get(identifier.toString(), requestOptions);
            if (200 != resp.getStatusCode()) {
                throw new DiscoveryException("GET failed on " + identifier.toString() + " Received status code: " + resp.getStatusCode(), 1537);
            }
            result.setClaimed(new UrlIdentifier(resp.getFinalUri()));
            if (resp.getBody() == null) {
                throw new DiscoveryException("No HTML data read from " + identifier.toString(), 1538);
            }
            HTML_PARSER.parseHtml(resp.getBody(), result);
        }
        catch (IOException e) {
            throw new DiscoveryException("Fatal transport error: ", 1537, e);
        }
        _log.info((Object)("HTML discovery completed on: " + identifier));
        return this.extractDiscoveryInformation(result);
    }

    private List extractDiscoveryInformation(HtmlResult htmlResult) throws DiscoveryException {
        DiscoveryInformation extracted;
        ArrayList<DiscoveryInformation> htmlList = new ArrayList<DiscoveryInformation>();
        if (htmlResult.getOP2Endpoint() != null) {
            extracted = new DiscoveryInformation(htmlResult.getOP2Endpoint(), htmlResult.getClaimedId(), htmlResult.getDelegate2(), "http://specs.openid.net/auth/2.0/signon");
            if (DEBUG) {
                _log.debug((Object)("OpenID2-signon HTML discovery endpoint: " + extracted));
            }
            htmlList.add(extracted);
        }
        if (htmlResult.getOP1Endpoint() != null) {
            extracted = new DiscoveryInformation(htmlResult.getOP1Endpoint(), htmlResult.getClaimedId(), htmlResult.getDelegate1(), "http://openid.net/signon/1.1");
            if (DEBUG) {
                _log.debug((Object)("OpenID1-signon HTML discovery endpoint: " + extracted));
            }
            htmlList.add(extracted);
        }
        return htmlList;
    }

    static {
        String className = OpenID4JavaUtils.getProperty(HTML_PARSER_CLASS_NAME_KEY);
        if (DEBUG) {
            _log.debug((Object)("discovery.html.parser:" + className));
        }
        try {
            HTML_PARSER = (HtmlParser)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

