/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.OpenIDException;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class IndirectError
extends Message {
    private static Log _log = LogFactory.getLog(IndirectError.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private OpenIDException _exception;

    protected IndirectError(String msg, String returnTo) {
        this(msg, returnTo, false);
    }

    protected IndirectError(String msg, String returnTo, boolean compatibility) {
        this(null, msg, returnTo, compatibility);
    }

    protected IndirectError(OpenIDException e, String msg, String returnTo, boolean compatibility) {
        this.set("openid.mode", "error");
        this.set("openid.error", msg);
        this._destinationUrl = returnTo;
        this._exception = e;
        if (!compatibility) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
        }
    }

    protected IndirectError(ParameterList params) {
        super(params);
    }

    public static IndirectError createIndirectError(OpenIDException e, String returnTo) {
        return IndirectError.createIndirectError(e, returnTo, false);
    }

    public static IndirectError createIndirectError(String msg, String returnTo) {
        return IndirectError.createIndirectError(msg, returnTo, false);
    }

    public static IndirectError createIndirectError(OpenIDException e, String returnTo, boolean compatibility) {
        return IndirectError.createIndirectError(e, e.getMessage(), returnTo, compatibility);
    }

    public static IndirectError createIndirectError(String msg, String returnTo, boolean compatibility) {
        return IndirectError.createIndirectError(null, msg, returnTo, compatibility);
    }

    public static IndirectError createIndirectError(OpenIDException e, String msg, String returnTo, boolean compatibility) {
        IndirectError err = new IndirectError(e, msg, returnTo, compatibility);
        try {
            err.validate();
        }
        catch (MessageException ex) {
            _log.error((Object)("Invalid " + (compatibility ? "OpenID1" : "OpenID2") + " indirect error message created for message: " + msg));
        }
        _log.debug((Object)("Created indirect error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public static IndirectError createIndirectError(ParameterList params) {
        IndirectError err = new IndirectError(params);
        try {
            err.validate();
        }
        catch (MessageException e) {
            _log.error((Object)("Invalid direct error message created: " + err.keyValueFormEncoding()));
        }
        _log.debug((Object)("Created indirect error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public OpenIDException getException() {
        return this._exception;
    }

    public void setException(OpenIDException e) {
        this._exception = e;
    }

    public void setErrorMsg(String msg) {
        this.set("openid.error", msg);
    }

    public String getErrorMsg() {
        return this.getParameterValue("openid.error");
    }

    public void setContact(String contact) {
        this.set("openid.contact", contact);
    }

    public String getContact() {
        return this.getParameterValue("openid.contact");
    }

    public void setReference(String reference) {
        this.set("openid.reference", reference);
    }

    public String getReference() {
        return this.getParameterValue("openid.reference");
    }
}

