/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.sreg;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.MessageExtensionFactory;
import org.openid4java.message.ParameterList;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

public class SRegMessage
implements MessageExtension,
MessageExtensionFactory {
    private static Log _log = LogFactory.getLog(SRegMessage.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String OPENID_NS_SREG = "http://openid.net/sreg/1.0";
    public static final String OPENID_NS_SREG11 = "http://openid.net/extensions/sreg/1.1";
    protected ParameterList _parameters;
    private String _typeUri = "http://openid.net/sreg/1.0";

    public SRegMessage() {
        this._parameters = new ParameterList();
        if (DEBUG) {
            _log.debug((Object)"Created empty SRegMessage.");
        }
    }

    public SRegMessage(ParameterList params) {
        this._parameters = params;
        if (DEBUG) {
            _log.debug((Object)("Created SRegMessage from parameter list:\n" + params));
        }
    }

    public String getTypeUri() {
        return this._typeUri;
    }

    public void setTypeUri(String typeUri) {
        this._typeUri = typeUri;
    }

    public ParameterList getParameters() {
        return this._parameters;
    }

    public String getParameterValue(String name) {
        return this._parameters.getParameterValue(name);
    }

    public void setParameters(ParameterList params) {
        this._parameters = params;
    }

    public String multivalEncode(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,");
    }

    public String multivalDecode(String value) {
        return value.replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
    }

    public boolean providesIdentifier() {
        return false;
    }

    public boolean signRequired() {
        return true;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        if (parameterList.hasParameter("required") || parameterList.hasParameter("optional")) {
            return SRegRequest.createSRegRequest(parameterList);
        }
        return SRegResponse.createSRegResponse(parameterList);
    }
}

