/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.message.BasicNameValuePair;
import org.openid4java.util.AbstractHttpFetcher;
import org.openid4java.util.HttpClientFactory;
import org.openid4java.util.HttpRequestOptions;
import org.openid4java.util.HttpResponse;
import org.openid4java.util.HttpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCache
extends AbstractHttpFetcher {
    private static Log _log = LogFactory.getLog(HttpCache.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private HttpClient _client;
    private Map _getCache = new HashMap();
    private Map _headCache = new HashMap();

    public HttpCache() {
        this(null);
    }

    public HttpCache(SSLContext sslContext) {
        this(sslContext, null);
    }

    public HttpCache(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        this._client = HttpClientFactory.getInstance(this.getDefaultRequestOptions().getMaxRedirects(), this.getDefaultRequestOptions().getAllowCircularRedirects(), this.getDefaultRequestOptions().getSocketTimeout(), this.getDefaultRequestOptions().getConnTimeout(), null, sslContext, hostnameVerifier);
    }

    private void removeGet(String url) {
        if (this._getCache.keySet().contains(url)) {
            _log.info((Object)("Removing cached GET response for " + url));
            this._getCache.remove(url);
        } else {
            _log.info((Object)("NOT removing cached GET for " + url + " NOT FOUND."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse get(String url, HttpRequestOptions requestOptions) throws IOException {
        DefaultHttpResponse resp = (DefaultHttpResponse)this._getCache.get(url);
        if (resp != null) {
            if (this.match(resp, requestOptions)) {
                _log.info((Object)("Returning cached GET response for " + url));
                return resp;
            }
            _log.info((Object)("Removing cached GET for " + url));
            this.removeGet(url);
        }
        HttpGet get = new HttpGet(url);
        org.apache.http.HttpResponse httpResponse = null;
        HttpEntity responseEntity = null;
        try {
            get.getParams().setParameter("http.protocol.handle-redirects", (Object)Boolean.TRUE);
            HttpUtils.setRequestOptions((HttpRequestBase)get, requestOptions);
            httpResponse = this._client.execute((HttpUriRequest)get);
            responseEntity = httpResponse.getEntity();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String statusLine = httpResponse.getStatusLine().getReasonPhrase();
            ResponseBody body = this.getResponseBody(responseEntity, requestOptions.getMaxBodySize());
            resp = new DefaultHttpResponse(statusCode, statusLine, requestOptions.getMaxRedirects(), get.getURI().toString(), httpResponse.getAllHeaders(), body.getBody());
            resp.setBodySizeExceeded(body.isBodyTruncated());
            this._getCache.put(url, resp);
        }
        catch (Throwable throwable) {
            HttpUtils.dispose(responseEntity);
            throw throwable;
        }
        HttpUtils.dispose(responseEntity);
        return resp;
    }

    private List<NameValuePair> toList(Map<String, String> parameters) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(parameters.size());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            list.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse post(String url, Map<String, String> parameters, HttpRequestOptions requestOptions) throws IOException {
        DefaultHttpResponse resp;
        HttpPost post = new HttpPost(url);
        org.apache.http.HttpResponse httpResponse = null;
        try {
            post.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
            HttpUtils.setRequestOptions((HttpRequestBase)post, requestOptions);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(this.toList(parameters), "UTF-8"));
            if (DEBUG) {
                _log.debug((Object)("Performing HTTP POST on " + url));
            }
            httpResponse = this._client.execute((HttpUriRequest)post);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String statusLine = httpResponse.getStatusLine().getReasonPhrase();
            ResponseBody body = this.getResponseBody(httpResponse.getEntity(), requestOptions.getMaxBodySize());
            resp = new DefaultHttpResponse(statusCode, statusLine, requestOptions.getMaxRedirects(), post.getURI().toString(), httpResponse.getAllHeaders(), body.getBody());
            resp.setBodySizeExceeded(body.isBodyTruncated());
        }
        catch (Throwable throwable) {
            HttpUtils.dispose(httpResponse);
            throw throwable;
        }
        HttpUtils.dispose(httpResponse);
        return resp;
    }

    private ResponseBody getResponseBody(HttpEntity response, int maxBodySize) throws IOException {
        int totalRead;
        int currentRead;
        InputStream httpBodyInput = response.getContent();
        if (httpBodyInput == null) {
            return new ResponseBody(null, false);
        }
        if (response.getContentLength() > 0L && response.getContentLength() < (long)maxBodySize) {
            maxBodySize = (int)response.getContentLength();
        }
        byte[] data = new byte[maxBodySize];
        for (totalRead = 0; totalRead < maxBodySize && (currentRead = httpBodyInput.read(data, totalRead, maxBodySize - totalRead)) != -1; totalRead += currentRead) {
        }
        boolean bodySizeExceeded = httpBodyInput.read() > 0;
        httpBodyInput.close();
        if (DEBUG) {
            _log.debug((Object)("Read " + totalRead + " bytes."));
        }
        return new ResponseBody(new String(data, 0, totalRead), bodySizeExceeded);
    }

    private boolean match(DefaultHttpResponse resp, HttpRequestOptions requestOptions) {
        Header responseContentType;
        if (resp != null && !requestOptions.isUseCache()) {
            _log.info((Object)"Explicit fresh GET requested; removing cached copy");
            return false;
        }
        if (resp != null && requestOptions.getCacheTTLSeconds() >= 0L) {
            long cacheTTL = requestOptions.getCacheTTLSeconds() * 1000L;
            Date now = new Date();
            long currentTime = now.getTime();
            long cacheExpTime = resp.getTimestamp() + cacheTTL;
            if (cacheExpTime < currentTime) {
                String cacheExpTimeStr = new Date(cacheExpTime).toString();
                _log.info((Object)("Cache Expired at " + cacheExpTimeStr + "; removing cached copy"));
                return false;
            }
        }
        String requiredContentType = requestOptions.getContentType();
        if (resp != null && requiredContentType != null && (responseContentType = resp.getResponseHeader("content-type")) != null && responseContentType.getValue() != null && !responseContentType.getValue().split(";")[0].equalsIgnoreCase(requiredContentType)) {
            _log.info((Object)"Cached GET response does not match the required content type, removing.");
            return false;
        }
        if (resp != null && resp.getMaxRedirectsFollowed() > requestOptions.getMaxRedirects()) {
            _log.info((Object)("Cached GET response used " + resp.getMaxRedirectsFollowed() + " max redirects; current requirement is: " + requestOptions.getMaxRedirects()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse head(String url, HttpRequestOptions requestOptions) throws IOException {
        DefaultHttpResponse resp = (DefaultHttpResponse)this._headCache.get(url);
        if (resp != null) {
            if (this.match(resp, requestOptions)) {
                _log.info((Object)("Returning cached HEAD response for " + url));
                return resp;
            }
            _log.info((Object)("Removing cached HEAD for " + url));
            this.removeGet(url);
        }
        HttpHead head = new HttpHead(url);
        org.apache.http.HttpResponse httpResponse = null;
        HttpEntity responseEntity = null;
        try {
            head.getParams().setParameter("http.protocol.handle-redirects", (Object)Boolean.TRUE);
            HttpUtils.setRequestOptions((HttpRequestBase)head, requestOptions);
            httpResponse = this._client.execute((HttpUriRequest)head);
            responseEntity = httpResponse.getEntity();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String statusLine = httpResponse.getStatusLine().getReasonPhrase();
            resp = new DefaultHttpResponse(statusCode, statusLine, requestOptions.getMaxRedirects(), head.getURI().toString(), httpResponse.getAllHeaders(), null);
            this._headCache.put(url, resp);
        }
        catch (Throwable throwable) {
            HttpUtils.dispose(responseEntity);
            throw throwable;
        }
        HttpUtils.dispose(responseEntity);
        return resp;
    }

    private static class ResponseBody {
        private final String body;
        private final boolean bodyIsTruncated;

        public ResponseBody(String body, boolean truncated) {
            this.body = body;
            this.bodyIsTruncated = truncated;
        }

        public String getBody() {
            return this.body;
        }

        public boolean isBodyTruncated() {
            return this.bodyIsTruncated;
        }
    }

    private static class DefaultHttpResponse
    implements HttpResponse {
        private int _statusCode;
        private String _statusLine;
        private int _maxRedirectsFollowed;
        private String _finalUri;
        private Map _responseHeaders;
        private String _body;
        private boolean _bodySizeExceeded = false;
        private long _timestamp;

        public DefaultHttpResponse(int statusCode, String statusLine, int redirectsFollowed, String finalUri, Header[] responseHeaders, String body) {
            this._statusCode = statusCode;
            this._statusLine = statusLine;
            this._maxRedirectsFollowed = redirectsFollowed;
            this._finalUri = finalUri;
            this._responseHeaders = new HashMap();
            if (responseHeaders != null) {
                for (int i = 0; i < responseHeaders.length; ++i) {
                    String headerName = responseHeaders[i].getName().toLowerCase();
                    Header header = responseHeaders[i];
                    List headerList = (List)this._responseHeaders.get(headerName);
                    if (headerList != null) {
                        headerList.add(responseHeaders[i]);
                        continue;
                    }
                    this._responseHeaders.put(headerName, new ArrayList<Header>(Arrays.asList(header)));
                }
            }
            this._body = body;
            Date now = new Date();
            this._timestamp = now.getTime();
        }

        public int getStatusCode() {
            return this._statusCode;
        }

        public String getStatusLine() {
            return this._statusLine;
        }

        public int getMaxRedirectsFollowed() {
            return this._maxRedirectsFollowed;
        }

        public String getFinalUri() {
            return this._finalUri;
        }

        public Header getResponseHeader(String headerName) {
            List headerList = (List)this._responseHeaders.get(headerName.toLowerCase());
            if (headerList != null && headerList.size() > 0) {
                return (Header)headerList.get(0);
            }
            return null;
        }

        public Header[] getResponseHeaders(String headerName) {
            List headerList = (List)this._responseHeaders.get(headerName.toLowerCase());
            if (headerList != null) {
                return headerList.toArray(new Header[headerList.size()]);
            }
            return new Header[0];
        }

        public String getBody() {
            return this._body;
        }

        public boolean isBodySizeExceeded() {
            return this._bodySizeExceeded;
        }

        public void setBodySizeExceeded(boolean bodySizeExceeded) {
            this._bodySizeExceeded = bodySizeExceeded;
        }

        public long getTimestamp() {
            return this._timestamp;
        }
    }
}

