/*
 * CredentialManagerFrame.java
 *
 * Created on 04 January 2006, 12:31
 */

package org.owasp.webscarab.ui.swing;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.table.AbstractTableModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.BasicCredential;
import org.owasp.webscarab.plugin.CredentialManager;
import org.owasp.webscarab.plugin.DomainCredential;

/**
 *
 * @author  rdawes
 */
public class CredentialManagerFrame extends javax.swing.JFrame {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 1688116674185863060L;
	private CredentialManager _manager;
    private BasicTableModel _btm;
    private DomainTableModel _dtm;
    
    /** Creates new form CredentialManagerFrame */
    public CredentialManagerFrame(CredentialManager manager) {
        initComponents();
        boolean prompt = Boolean.valueOf(Preferences.getPreference("WebScarab.promptForCredentials", "false")).booleanValue();
        promptCheckBox.setSelected(prompt);
        addComponentListener(new Updater());
        _manager = manager;
        _btm = new BasicTableModel();
        _dtm = new DomainTableModel();
        basicTable.setModel(_btm);
        domainTable.setModel(_dtm);
    }
    
    private void updateCredentials() {
        _btm.fireTableDataChanged();
        _dtm.fireTableDataChanged();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        basicTable = new javax.swing.JTable();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        domainTable = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        addButton = new javax.swing.JButton();
        deleteButton = new javax.swing.JButton();
        clearButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();
        promptCheckBox = new javax.swing.JCheckBox();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("WebScarab Credentials");
        jLabel1.setText("Basic Credentials");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel1, gridBagConstraints);

        basicTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(basicTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jLabel2.setText("Domain Credentials");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel2, gridBagConstraints);

        domainTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane2.setViewportView(domainTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane2, gridBagConstraints);

        addButton.setText("Add");
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        jPanel1.add(addButton);

        deleteButton.setText("Delete");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        jPanel1.add(deleteButton);

        clearButton.setText("Clear all");
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });

        jPanel1.add(clearButton);

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        jPanel1.add(closeButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        getContentPane().add(jPanel1, gridBagConstraints);

        promptCheckBox.setText("Ask when required");
        promptCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        promptCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        promptCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                promptCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(promptCheckBox, gridBagConstraints);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-400)/2, (screenSize.height-300)/2, 400, 300);
    }// </editor-fold>//GEN-END:initComponents

    private void promptCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_promptCheckBoxActionPerformed
        Preferences.setPreference("WebScarab.promptForCredentials", Boolean.toString(promptCheckBox.isSelected()));
    }//GEN-LAST:event_promptCheckBoxActionPerformed

    private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
        for (int i=_manager.getBasicCredentialCount()-1; i>=0; i--) {
            _manager.deleteBasicCredentialAt(i);
        }
        for (int i=_manager.getDomainCredentialCount()-1; i>=0; i--) {
            _manager.deleteDomainCredentialAt(i);
        }
        updateCredentials();
    }//GEN-LAST:event_clearButtonActionPerformed

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        setVisible(false);
    }//GEN-LAST:event_closeButtonActionPerformed

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteButtonActionPerformed
        int basicSelection = basicTable.getSelectedRow();
        int domainSelection = domainTable.getSelectedRow();
        if (basicSelection > -1 && domainSelection > -1)
            return;
        if (basicSelection > -1)
            _manager.deleteBasicCredentialAt(basicSelection);
        if (domainSelection> -1)
            _manager.deleteDomainCredentialAt(domainSelection);
        updateCredentials();
    }//GEN-LAST:event_deleteButtonActionPerformed

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
        new CredentialRequestDialog(this, true, _manager).requestCredentials(null, null);
        updateCredentials();
    }//GEN-LAST:event_addButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JTable basicTable;
    private javax.swing.JButton clearButton;
    private javax.swing.JButton closeButton;
    private javax.swing.JButton deleteButton;
    private javax.swing.JTable domainTable;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JCheckBox promptCheckBox;
    // End of variables declaration//GEN-END:variables
    
    private class BasicTableModel extends AbstractTableModel {
        
        /**
		 * 
		 */
		private static final long serialVersionUID = 4101228666708000944L;
		private String[] _columnNames = { "Host", "Realm", "Username"};
        
        public String getColumnName(int column) {
            return _columnNames[column];
        }
        
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return _manager.getBasicCredentialCount();
        }

        public Object getValueAt(int row, int column) {
            BasicCredential bc = _manager.getBasicCredentialAt(row);
            switch (column) {
                case 0: return bc.getHost();
                case 1: return bc.getRealm();
                case 2: return bc.getUsername();
            }
            return null;
        }
        
    }
    
    private class DomainTableModel extends AbstractTableModel {
        
        /**
		 * 
		 */
		private static final long serialVersionUID = -4483058953578321230L;
		private String[] _columnNames = { "Host", "Domain", "Username"};
        
        public String getColumnName(int column) {
            return _columnNames[column];
        }
        
        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return _manager.getDomainCredentialCount();
        }

        public Object getValueAt(int row, int column) {
            DomainCredential dc = _manager.getDomainCredentialAt(row);
            switch (column) {
                case 0: return dc.getHost();
                case 1: return dc.getDomain();
                case 2: return dc.getUsername();
            }
            return null;
        }
        
    }
    
    private class Updater extends ComponentAdapter {
        public void componentShown(ComponentEvent e) {
            updateCredentials();
        }
    }
    
}
