/*
 * Copyright 2015-2018 Yubico AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* rand.h
**
** Implements platform specific random generation operations
*/

#ifndef _YUBICOM_RAND_H_
#define _YUBICOM_RAND_H_

#include <stdbool.h>
#include <stdint.h>
#include <stddef.h>
#include "../common/platform-config.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __WIN32
#define YH_INTERNAL __attribute__((visibility("hidden")))
#else
#define YH_INTERNAL
#endif

bool YH_INTERNAL rand_generate(uint8_t *buf, size_t cb_buf);

#ifdef __cplusplus
}
#endif

#endif /* _YUBICOM_RAND_H_ */
