/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.util.Version;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class GraphUserData
extends HashMap<String, Object> {
    private static final Map<GraphID, GraphUserData> GRAPH_USER_DATAS = new HashMap<GraphID, GraphUserData>();
    private static final List<Long> CLOSED_GRAPHS = new ArrayList<Long>();

    private GraphUserData() {
    }

    public static synchronized GraphUserData forGraph(GraphID graphID) {
        return GraphUserData.forGraph(graphID, true);
    }

    public static synchronized GraphUserData forGraph(GraphID graphID, boolean create) {
        GraphUserData data = GRAPH_USER_DATAS.get(graphID);
        if (data == null && create) {
            GraphUserData.checkGraphClosed(graphID);
            data = new GraphUserData();
            GRAPH_USER_DATAS.put(graphID, data);
        }
        return data;
    }

    public static synchronized Map<GraphID, GraphUserData> getAll() {
        return new HashMap<GraphID, GraphUserData>(GRAPH_USER_DATAS);
    }

    private static synchronized void remove(GraphID graphID) {
        GraphUserData data = GRAPH_USER_DATAS.remove(graphID);
        if (data != null) {
            data.clear();
        }
        CLOSED_GRAPHS.add(graphID.getValue());
    }

    private static void checkGraphClosed(GraphID graphID) throws IllegalStateException {
        if (Version.getCurrent().isDevBuild()) {
            try {
                for (Long closedGraph : CLOSED_GRAPHS) {
                    if (graphID.getValue() != closedGraph.longValue()) continue;
                }
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosed".equals(evt.getPropertyName())) {
                    final GraphID graphID = (GraphID)evt.getNewValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GraphUserData.remove(graphID);
                        }
                    });
                }
            }
        });
    }
}

