/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.undo.BatchCommand;
import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.UndoRedoManager;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.layout.view.InteractiveLayoutViewHandler;
import com.paterva.maltego.layout.view.LayoutHandler;
import com.paterva.maltego.layout.view.LayoutViewToolbar;
import com.paterva.maltego.layout.view.OnceOffLayoutViewHandler;
import com.paterva.maltego.layout.view.undo.LayoutCommand;
import com.paterva.maltego.ui.graph.view2d.BendClearingMoveMode;
import com.paterva.maltego.ui.graph.view2d.DefaultGraph2DViewAdapter;
import com.paterva.maltego.ui.graph.view2d.GraphViewOptions;
import com.paterva.maltego.ui.graph.view2d.LegendBackgroundRenderer;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterRegistry;
import com.paterva.maltego.util.ui.components.ToolBarLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.openide.util.WeakListeners;
import yguard.A.A.Y;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.mB;
import yguard.A.J.wA;

public class LayoutViewAdapter
extends DefaultGraph2DViewAdapter {
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    protected LayoutViewToolbar _toolbar;
    private OnceOffLayoutViewHandler _onceOffHandler;
    private InteractiveLayoutViewHandler _interactiveHandler;
    private wA _editMode;
    private LayoutSettings _layoutSettings = new LayoutSettings(true, null);
    private boolean _freezeLayout = false;
    private PropertyChangeListener _interactiveLayoutListener;
    private PropertyChangeListener _onceOffLayoutListener;
    private StructureListener _structureListener;

    public LayoutViewAdapter(GraphID graphID) {
        super(graphID);
    }

    public void prepareToShow() {
        super.prepareToShow();
        this.getLayoutHandler().prepareToShow();
    }

    protected void onGraphChanged(SA oldGraph, SA newGraph) {
        super.onGraphChanged(oldGraph, newGraph);
        this.getOnceOffLayouter().onGraphChanged(oldGraph, newGraph);
        this.getInteractiveLayouter().onGraphChanged(oldGraph, newGraph);
        this.updateEditMode();
        ((LayoutViewToolbar)this.getToolbar()).setGraph(newGraph);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)this.getGraphID());
        if (oldGraph != null && this._structureListener != null) {
            wrapper.getGraphStructureStore().removePropertyChangeListener((PropertyChangeListener)this._structureListener);
            this._structureListener = null;
        }
        if (newGraph != null) {
            this._structureListener = new StructureListener(wrapper);
            wrapper.getGraphStructureStore().addPropertyChangeListener((PropertyChangeListener)this._structureListener);
        }
    }

    private void onGraphUpdated(Set<Y> newNodes, boolean relayoutNew) {
        if (relayoutNew) {
            this.getLayoutHandler().onGraphUpdated(newNodes);
        }
    }

    public void componentShowing() {
        super.componentShowing();
        this.getOnceOffLayouter().onComponentShowing();
        this.getInteractiveLayouter().onComponentShowing();
        this.updateEditMode();
    }

    public void componentHidden() {
        super.componentHidden();
        this.getOnceOffLayouter().onComponentHidden();
        this.getInteractiveLayouter().onComponentHidden();
    }

    public void componentClosed() {
        super.componentClosed();
        this.getOnceOffLayouter().onComponentClosed();
        this.getInteractiveLayouter().onComponentClosed();
    }

    protected wA createEditMode() {
        this._editMode = super.createEditMode();
        return this._editMode;
    }

    private void updateToolbar(LayoutMode mode, boolean layoutAll) {
        boolean isInteractive = mode.isInteractive();
        this.getLayoutToolbar().setInteractiveSelected(isInteractive, false);
        if (!isInteractive) {
            this.getLayoutToolbar().setLayoutMode(mode);
        }
        this.getLayoutToolbar().setLayoutAll(layoutAll);
    }

    protected boolean isLayoutAll() {
        return this.getLayoutSettings().isLayoutAll();
    }

    protected LayoutMode getLayoutMode() {
        return this.getLayoutSettings().getMode();
    }

    protected LayoutSettings getLayoutSettings() {
        return this._layoutSettings;
    }

    protected void setLayout(LayoutSettings layoutSettings, boolean forceLayout) {
        LayoutMode mode = layoutSettings.getMode();
        boolean layoutAll = layoutSettings.isLayoutAll();
        this.setLayoutMode(mode, layoutAll, forceLayout, true);
        this.updateToolbar(mode, layoutAll);
    }

    protected void setLayoutMode(LayoutMode layoutMode, boolean layoutAll, boolean forceLayout, boolean undoable) {
        boolean isInteractive = layoutMode.isInteractive();
        boolean updateEditMode = false;
        if (forceLayout || layoutMode != this.getLayoutMode() || !isInteractive && layoutAll != this.isLayoutAll()) {
            OnceOffLayoutViewHandler onceOffLayouter = this.getOnceOffLayouter();
            InteractiveLayoutViewHandler interactiveLayouter = this.getInteractiveLayouter();
            if (isInteractive) {
                onceOffLayouter.setLayoutMode(null, true, false);
                interactiveLayouter.setLayoutMode(layoutMode);
            } else {
                onceOffLayouter.setLayoutMode(layoutMode, layoutAll, layoutAll && !this._freezeLayout);
                interactiveLayouter.setLayoutMode(null);
            }
            updateEditMode = true;
            if (undoable) {
                this.createUndo(this.getLayoutMode(), this.isLayoutAll(), layoutMode, layoutAll);
            }
        }
        if (layoutMode != this.getLayoutMode() || layoutAll != this.isLayoutAll()) {
            LayoutSettings old = this._layoutSettings;
            this._layoutSettings = new LayoutSettings(layoutAll, layoutMode);
            if (updateEditMode) {
                this.updateEditMode();
            }
            this._changeSupport.firePropertyChange("layoutSettingsChanged", old, this._layoutSettings);
        }
    }

    private void createUndo(LayoutMode oldLayoutMode, boolean oldLayoutAll, LayoutMode newLayoutMode, boolean newLayoutAll) {
        GraphID graphID = this.getGraphID();
        UndoRedoModel undoRedo = UndoRedoManager.getDefault().get(graphID);
        if (undoRedo != null && (oldLayoutMode != newLayoutMode || oldLayoutAll != newLayoutAll)) {
            SetLayoutCommand setLayoutCommand = new SetLayoutCommand(oldLayoutMode, oldLayoutAll, newLayoutMode, newLayoutAll);
            BatchCommand batchCmd = new BatchCommand(setLayoutCommand.getDescription());
            batchCmd.add((Command)setLayoutCommand);
            if (newLayoutMode.isInteractive() && !oldLayoutMode.isInteractive()) {
                batchCmd.add((Command)new LayoutCommand(graphID, false));
            }
            undoRedo.store((Command)batchCmd);
        }
    }

    private void updateEditMode() {
        LayoutMode mode = this.getLayoutMode();
        if (mode != null && mode.isInteractive()) {
            this._editMode.setMoveSelectionMode(this.getInteractiveLayouter().getMoveSelectionMode());
        } else {
            this._editMode.setMoveSelectionMode((mB)new BendClearingMoveMode());
        }
    }

    public JComponent getToolbar() {
        return this.getLayoutToolbar();
    }

    protected LayoutMode getDefaultLayoutMode() {
        return LayoutMode.BLOCK;
    }

    protected synchronized LayoutViewToolbar getLayoutToolbar() {
        if (this._toolbar == null) {
            boolean hideLayoutNewButtons = "true".equals(System.getProperty("maltego.hide-mining-layout-buttons", "false"));
            boolean layoutAll = !hideLayoutNewButtons;
            LayoutMode layoutMode = this.getDefaultLayoutMode();
            this._toolbar = new LayoutViewToolbar(hideLayoutNewButtons);
            this._toolbar.setOpaque(false);
            this._toolbar.setLayoutMode(layoutMode);
            this._toolbar.setLayoutAll(layoutAll);
            this._toolbar.setFloatable(false);
            this._toolbar.addPropertyChangeListener(new ToolbarListener());
            this.setFreezeLayout(true);
            this.setLayoutMode(layoutMode, layoutAll, false, false);
            this.setFreezeLayout(false);
            this._toolbar.add((Component)new ToolBarLabel("Layout"), 0);
            this._toolbar.add((Component)new ToolBarLabel("View"));
            for (EntityPainter entityPainter : EntityPainterRegistry.getDefault().getEntityPainters()) {
                JComponent toolbarComponent = entityPainter.createToolbarComponent(this.getGraphID());
                this._toolbar.add(toolbarComponent);
            }
        }
        return this._toolbar;
    }

    private LayoutHandler getLayoutHandler() {
        LayoutMode mode = this.getLayoutMode();
        if (mode != null && mode.isInteractive()) {
            return this.getInteractiveLayouter();
        }
        return this.getOnceOffLayouter();
    }

    private OnceOffLayoutViewHandler getOnceOffLayouter() {
        if (this._onceOffHandler == null) {
            this._onceOffHandler = new OnceOffLayoutViewHandler(this.getView());
            this._onceOffLayoutListener = new OnceOffLayoutListener();
            this._onceOffHandler.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._onceOffLayoutListener, (Object)this._onceOffHandler));
        }
        return this._onceOffHandler;
    }

    private synchronized InteractiveLayoutViewHandler getInteractiveLayouter() {
        if (this._interactiveHandler == null) {
            this._interactiveHandler = new InteractiveLayoutViewHandler(this.getView());
            this._interactiveLayoutListener = new InteractiveLayoutListener();
            this._interactiveHandler.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._interactiveLayoutListener, (Object)this._interactiveHandler));
        }
        return this._interactiveHandler;
    }

    protected void setFreezeLayout(boolean freeze) {
        this._freezeLayout = freeze;
    }

    protected boolean isLayoutFrozen() {
        return this._freezeLayout;
    }

    protected void setInteractiveLayout(boolean interactive) {
        this.getLayoutToolbar().setInteractiveSelected(interactive, true);
    }

    protected boolean isInteractiveLayout() {
        return this.getLayoutToolbar().isInteractiveSelected();
    }

    protected PropertyChangeSupport getLayoutChangeSupport() {
        return this._changeSupport;
    }

    protected LegendBackgroundRenderer createBackground(U view) {
        LegendLayoutBackgroundRenderer bgr = new LegendLayoutBackgroundRenderer(this.getGraphID(), view);
        bgr.setMode((byte)0);
        bgr.setLegendPosition(1);
        bgr.setImage(GraphViewOptions.getDefault().getBackground());
        return bgr;
    }

    private class StructureListener
    implements PropertyChangeListener {
        private final GraphWrapper _wrapper;

        public StructureListener(GraphWrapper wrapper) {
            this._wrapper = wrapper;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
            Set entitiesAdded = mods.getEntitiesAdded();
            if (!(!mods.isLayoutNew() || entitiesAdded.isEmpty() && mods.getCollectionMods().isEmpty())) {
                HashSet<Y> newNodes = new HashSet<Y>(entitiesAdded.size());
                for (EntityID entityID : entitiesAdded) {
                    Y node = this._wrapper.node(entityID);
                    newNodes.add(node);
                }
                LayoutViewAdapter.this.onGraphUpdated(newNodes, true);
            }
        }
    }

    private class SetLayoutCommand
    extends Command {
        private final LayoutMode _oldMode;
        private final boolean _oldLayoutAll;
        private final LayoutMode _newMode;
        private final boolean _newLayoutAll;

        public SetLayoutCommand(LayoutMode oldMode, boolean oldLayoutAll, LayoutMode newMode, boolean newLayoutAll) {
            this._oldMode = oldMode;
            this._oldLayoutAll = oldLayoutAll;
            this._newMode = newMode;
            this._newLayoutAll = newLayoutAll;
        }

        public void execute() {
            boolean oldFreezeLayout = LayoutViewAdapter.this._freezeLayout;
            LayoutViewAdapter.this._freezeLayout = true;
            LayoutViewAdapter.this.setLayoutMode(this._newMode, this._newLayoutAll, false, false);
            LayoutViewAdapter.this.updateToolbar(this._newMode, this._newLayoutAll);
            LayoutViewAdapter.this._freezeLayout = oldFreezeLayout;
        }

        public void undo() {
            boolean oldFreezeLayout = LayoutViewAdapter.this._freezeLayout;
            LayoutViewAdapter.this._freezeLayout = true;
            LayoutViewAdapter.this.setLayoutMode(this._oldMode, this._oldLayoutAll, false, false);
            LayoutViewAdapter.this.updateToolbar(this._oldMode, this._oldLayoutAll);
            LayoutViewAdapter.this._freezeLayout = oldFreezeLayout;
        }

        public String getDescription() {
            return "Change layout mode";
        }
    }

    private class OnceOffLayoutListener
    implements PropertyChangeListener {
        private OnceOffLayoutListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("isLayouting".equals(evt.getPropertyName())) {
                LayoutViewAdapter.this.getView().updateView();
            }
        }
    }

    private class LegendLayoutBackgroundRenderer
    extends LegendBackgroundRenderer {
        private static final String LAYOUTING_TEXT = "Layouting...";

        public LegendLayoutBackgroundRenderer(GraphID graphID, U view) {
            super(graphID, view);
        }

        public void paint(Graphics2D g, int x, int y, int width, int height) {
            OnceOffLayoutViewHandler onceOffHandler;
            super.paint(g, x, y, width, height);
            LayoutHandler layoutHandler = LayoutViewAdapter.this.getLayoutHandler();
            if (layoutHandler instanceof OnceOffLayoutViewHandler && (onceOffHandler = (OnceOffLayoutViewHandler)layoutHandler).isLayouting()) {
                int marginX = 25;
                int marginY = 25;
                Point p = new Point(marginX, this.view.getHeight() - marginY);
                this.undoWorldTransform(g);
                g.setFont(this.getFont());
                g.setColor(Color.LIGHT_GRAY);
                g.drawString(LAYOUTING_TEXT, p.x, p.y);
                this.redoWorldTransform(g);
            }
        }
    }

    private class InteractiveLayoutListener
    implements PropertyChangeListener {
        private InteractiveLayoutListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutViewAdapter.this.updateEditMode();
        }
    }

    protected class ToolbarListener
    implements PropertyChangeListener {
        protected ToolbarListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("layoutModeChanged".equals(evt.getPropertyName()) || "layoutAllOrNewChanged".equals(evt.getPropertyName())) {
                LayoutViewToolbar toolbar = LayoutViewAdapter.this.getLayoutToolbar();
                LayoutMode layoutMode = toolbar.getLayoutMode();
                boolean layoutAll = toolbar.isLayoutAll();
                LayoutViewAdapter.this.setLayoutMode(layoutMode, layoutAll, true, true);
            }
        }
    }
}

