/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityDecorator;
import com.paterva.maltego.entity.api.LinkDecorator;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;

public class ChatPartDecorator
implements EntityDecorator,
LinkDecorator {
    public MaltegoEntity decorate(GraphID graphID, MaltegoEntity entity) {
        ChatRoom chatRoom = this.toChatRoom(graphID);
        if (chatRoom != null) {
            entity = this.decorate(entity, chatRoom);
        }
        return entity;
    }

    public MaltegoLink decorate(GraphID graphID, MaltegoLink link) {
        ChatRoom chatRoom = this.toChatRoom(graphID);
        if (chatRoom != null) {
            link = this.decorate(link, chatRoom);
        }
        return link;
    }

    private ChatRoom toChatRoom(GraphID graphID) {
        ChatRoomCookie cookie;
        ChatRoom chatRoom = null;
        GraphDataObject gdo = GraphDataUtils.getGraphDataObject((GraphID)graphID);
        if (gdo != null && (cookie = (ChatRoomCookie)gdo.getLookup().lookup(ChatRoomCookie.class)) != null) {
            chatRoom = cookie.getChatRoom();
        }
        return chatRoom;
    }

    private MaltegoEntity decorate(MaltegoEntity entity, ChatRoom chatRoom) {
        DateTime now = new DateTime();
        String alias = chatRoom.getClientUser().getAlias();
        ModifiedHelper.addCreatedAndModifiedIfMissing((MaltegoPart)entity, (String)alias, (DateTime)now);
        return entity;
    }

    private MaltegoLink decorate(MaltegoLink link, ChatRoom chatRoom) {
        DateTime now = new DateTime();
        String alias = chatRoom.getClientUser().getAlias();
        ModifiedHelper.addCreatedAndModifiedIfMissing((MaltegoPart)link, (String)alias, (DateTime)now);
        return link;
    }
}

