/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.inputs;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.Map;
import java.util.TreeMap;

class LatchedDataSource
implements DataSource {
    private DataSource _delegate;
    private Map<PropertyDescriptor, Object> _map;

    public LatchedDataSource(DataSource delegate) {
        this._delegate = delegate;
        this._map = new TreeMap<PropertyDescriptor, Object>();
    }

    public Object getValue(PropertyDescriptor descriptor) {
        Object value = this._map.get(descriptor);
        if (value == null) {
            value = this._delegate.getValue(descriptor);
            this._map.put(descriptor, value);
        }
        return value;
    }

    public void setValue(PropertyDescriptor descriptor, Object value) {
        this._map.put(descriptor, value);
    }

    public void clear() {
        this._map.clear();
    }

    public void commitToDelegate() {
        for (Map.Entry<PropertyDescriptor, Object> entry : this._map.entrySet()) {
            this._delegate.setValue(entry.getKey(), entry.getValue());
        }
    }
}

