/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.lazy.etable;

import com.paterva.maltego.treelist.lazy.etable.ETableColumn;
import com.paterva.maltego.treelist.lazy.etable.ETableColumnModel;
import com.paterva.maltego.treelist.lazy.etable.LazyETable;
import com.paterva.maltego.util.IconSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ETableHeader
extends JTableHeader {
    private final boolean _small;

    public ETableHeader() {
        this(null);
    }

    public ETableHeader(TableColumnModel cm) {
        this(cm, false);
    }

    public ETableHeader(TableColumnModel cm, boolean small) {
        super(cm);
        this._small = small;
    }

    @Override
    public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
        super.setDefaultRenderer(new ETableHeaderRenderer(defaultRenderer));
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tooltip = null;
        if (!this._small) {
            Point p = event.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            TableColumn column = this.columnModel.getColumn(index);
            tooltip = column.getHeaderValue().toString();
        }
        return tooltip;
    }

    private Icon mergeIcons(final Icon icon1, final Icon icon2, final int xOffset, int yOffset, Component c) {
        int w = 0;
        int h = 0;
        if (icon1 != null) {
            w = icon1.getIconWidth();
            h = icon1.getIconHeight();
        }
        if (icon2 != null) {
            w = icon2.getIconWidth() + xOffset > w ? icon2.getIconWidth() + xOffset : w;
            h = icon2.getIconHeight() + yOffset > h ? icon2.getIconHeight() + yOffset : h;
        }
        int iconSize = IconSize.TINY.getSize();
        if (w < 1) {
            w = iconSize;
        }
        if (h < 1) {
            h = iconSize;
        }
        final int width = w;
        final int hight = h;
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2D = (Graphics2D)g.create();
                    g2D.translate(x, y);
                    icon1.paintIcon(c, g2D, 0, 0);
                    icon2.paintIcon(c, g2D, xOffset, 0);
                    g2D.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return hight;
            }
        };
    }

    private class SortUpIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return ETableHeader.this._small ? 4 : 8;
        }

        @Override
        public int getIconHeight() {
            return ETableHeader.this._small ? 4 : 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            if (ETableHeader.this._small) {
                g.fillPolygon(new int[]{x, x + 2, x + 4}, new int[]{y + 3, y + 1, y + 3}, 3);
            } else {
                g.fillPolygon(new int[]{x - 1, x + 4, x + 8}, new int[]{y + 7, y + 2, y + 7}, 3);
            }
        }
    }

    private class SortDownIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return ETableHeader.this._small ? 4 : 8;
        }

        @Override
        public int getIconHeight() {
            return ETableHeader.this._small ? 4 : 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            if (ETableHeader.this._small) {
                g.fillPolygon(new int[]{x, x + 2, x + 4}, new int[]{y + 1, y + 3, y + 1}, 3);
            } else {
                g.fillPolygon(new int[]{x, x + 4, x + 8}, new int[]{y + 2, y + 6, y + 2}, 3);
            }
        }
    }

    private class ETableHeaderRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer headerRendererUI;
        private Map<ETableColumn, TableCellRenderer> defaultColumnHeaderRenderers = new HashMap<ETableColumn, TableCellRenderer>();

        private ETableHeaderRenderer(TableCellRenderer headerRenderer) {
            this.headerRendererUI = headerRenderer;
            this.setName("TableHeader.renderer");
        }

        @Override
        public void updateUI() {
            TableCellRenderer defaultTableHeaderRenderer = this.headerRendererUI;
            if (defaultTableHeaderRenderer instanceof JComponent) {
                ((JComponent)((Object)defaultTableHeaderRenderer)).updateUI();
            } else {
                super.updateUI();
            }
        }

        private TableCellRenderer getColumnHeaderRenderer(TableColumn tc) {
            if (tc instanceof ETableColumn) {
                TableCellRenderer columnHeaderRenderer;
                ETableColumn eColumn = (ETableColumn)tc;
                if (!this.defaultColumnHeaderRenderers.containsKey(eColumn)) {
                    TableCellRenderer tcr = eColumn.createDefaultHeaderRenderer();
                    if (tcr instanceof ETableColumn.ETableColumnHeaderRendererDelegate) {
                        this.defaultColumnHeaderRenderers.put(eColumn, null);
                        columnHeaderRenderer = null;
                    } else {
                        eColumn.setTableHeaderRendererDelegate(this.headerRendererUI);
                        columnHeaderRenderer = tcr;
                    }
                } else {
                    columnHeaderRenderer = this.defaultColumnHeaderRenderers.get(eColumn);
                }
                if (columnHeaderRenderer != null) {
                    return columnHeaderRenderer;
                }
                return this.headerRendererUI;
            }
            return this.headerRendererUI;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableColumn tcm = ETableHeader.this.getColumnModel().getColumn(column);
            TableCellRenderer headerRenderer = this.getColumnHeaderRenderer(tcm);
            Component resUI = headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (resUI instanceof JLabel) {
                JLabel label = (JLabel)resUI;
                String valueString = "";
                if (value != null) {
                    valueString = value.toString();
                }
                if (table instanceof LazyETable) {
                    LazyETable et = (LazyETable)table;
                    valueString = et.getColumnDisplayName(valueString);
                }
                Icon sortIcon = null;
                List<TableColumn> sortedColumns = ((ETableColumnModel)table.getColumnModel()).getSortedColumns();
                int sortRank = 0;
                boolean ascending = false;
                Icon customIcon = null;
                if (tcm instanceof ETableColumn) {
                    ETableColumn eColumn = (ETableColumn)tcm;
                    sortRank = eColumn.getSortRank();
                    ascending = eColumn.isAscending();
                    customIcon = eColumn.getCustomIcon();
                    if (eColumn.isHideHeaderText()) {
                        valueString = "";
                    }
                }
                if (sortRank != 0) {
                    if (sortedColumns.size() > 1) {
                        valueString = valueString == null || valueString.isEmpty() ? Integer.toString(sortRank) : sortRank + " " + valueString;
                    }
                    label.setFont(new Font(label.getFont().getName(), 1, label.getFont().getSize()));
                    if (ascending) {
                        sortIcon = UIManager.getIcon(ETableHeader.this._small ? "ETableHeader.ascendingSmallIcon" : "ETableHeader.ascendingIcon");
                        if (sortIcon == null) {
                            sortIcon = new SortUpIcon();
                        }
                    } else {
                        sortIcon = UIManager.getIcon(ETableHeader.this._small ? "ETableHeader.descendingSmallIcon" : "ETableHeader.descendingIcon");
                        if (sortIcon == null) {
                            sortIcon = new SortDownIcon();
                        }
                    }
                }
                label.setText(valueString);
                if (sortIcon == null) {
                    label.setIcon(customIcon);
                } else if (customIcon == null) {
                    label.setIcon(sortIcon);
                } else {
                    label.setIcon(ETableHeader.this.mergeIcons(customIcon, sortIcon, 0, 0, label));
                }
                label.setIconTextGap(ETableHeader.this._small ? 0 : 1);
            }
            return resUI;
        }
    }
}

