/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.actions.ExportAction;
import com.paterva.maltego.ui.graph.view2d.Graph2DExporter;
import com.paterva.maltego.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import yguard.A.J.SA;

public class ExportImageAction
extends ExportAction {
    public ExportImageAction() {
        super("exportImage");
    }

    @Override
    protected String getExtension(AutomationContext ctx, String path) {
        return FileUtilities.getFileExtension((String)path).toLowerCase();
    }

    @Override
    protected void perform(AutomationContext ctx, Payload payload, String path, Boolean suffixDate, String dateFormat) {
        if (this.checkSupportedType(ctx, path)) {
            super.perform(ctx, payload, path, suffixDate, dateFormat);
        }
    }

    @Override
    protected void export(AutomationContext ctx, Payload payload, FileObject file, SA graph) throws IOException {
        boolean transparentBackground = false;
        if (FileUtil.getFileDisplayName((FileObject)file).toLowerCase().endsWith(".png")) {
            transparentBackground = true;
        }
        Graph2DExporter.exportToFile((File)FileUtil.toFile((FileObject)file), (SA)graph, (boolean)transparentBackground, (int)1024, (boolean)true, null, null);
        ctx.getLogger().info("Graph exported to %s", FileUtil.getFileDisplayName((FileObject)file));
    }

    private boolean checkSupportedType(AutomationContext ctx, String path) {
        String ext = this.getExtension(ctx, path);
        Set types = Graph2DExporter.getFileTypes().keySet();
        boolean supportedType = types.contains(ext);
        if (!supportedType) {
            MachineMessageHandler.getDefault().error(ctx.getTarget(), "Image type \"%s\" is not supported in %s. Supported types are %s", ext, this.getName(), types);
            return false;
        }
        return true;
    }
}

