/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public final class PreCalculatedResultFactory
implements JsonConvertible {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] indices;
    @CompilerDirectives.CompilationFinal
    private int length;

    public PreCalculatedResultFactory(int nGroups) {
        this.indices = new int[nGroups * 2];
        Arrays.fill(this.indices, -1);
    }

    private PreCalculatedResultFactory(int[] indices, int length) {
        this.indices = indices;
        this.length = length;
    }

    public PreCalculatedResultFactory copy() {
        return new PreCalculatedResultFactory(Arrays.copyOf(this.indices, this.indices.length), this.length);
    }

    public int getStart(int groupNr) {
        return this.indices[groupNr * 2];
    }

    public void setStart(int groupNr, int value) {
        this.indices[groupNr * 2] = value;
    }

    public int getEnd(int groupNr) {
        return this.indices[groupNr * 2 + 1];
    }

    public void setEnd(int groupNr, int value) {
        this.indices[groupNr * 2 + 1] = value;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void updateIndices(TBitSet updateIndices, int index) {
        PrimitiveIterator.OfInt ofInt = updateIndices.iterator();
        while (ofInt.hasNext()) {
            int i = (Integer)ofInt.next();
            this.indices[i] = index;
        }
    }

    public RegexResult createFromStart(int start) {
        return this.createFromOffset(start);
    }

    public RegexResult createFromEnd(int end) {
        return this.createFromOffset(end - this.length);
    }

    public int[] createArrayFromEnd(int end) {
        int offset = end - this.length;
        int[] realIndices = new int[this.indices.length];
        this.applyOffset(realIndices, offset);
        return realIndices;
    }

    public int getNumberOfGroups() {
        return this.indices.length / 2;
    }

    private RegexResult createFromOffset(int offset) {
        if (this.indices.length == 2) {
            return RegexResult.create(this.indices[0] + offset, this.indices[1] + offset);
        }
        int[] realIndices = new int[this.indices.length];
        this.applyOffset(realIndices, offset);
        return RegexResult.create(realIndices);
    }

    public void applyRelativeToEnd(int[] target, int end) {
        this.applyOffset(target, end - this.length);
    }

    private void applyOffset(int[] target, int offset) {
        for (int i = 0; i < this.indices.length; ++i) {
            target[i] = this.indices[i] == -1 ? -1 : this.indices[i] + offset;
        }
    }

    public int hashCode() {
        return this.length * 31 + Arrays.hashCode(this.indices);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PreCalculatedResultFactory)) {
            return false;
        }
        PreCalculatedResultFactory o = (PreCalculatedResultFactory)obj;
        return this.length == o.length && Arrays.equals(this.indices, o.indices);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("indices", Json.array(this.indices)), Json.prop("length", this.length));
    }
}

