/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.registry.FileSystemRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.Collection;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DefaultEntityRegistry
extends EntityRegistry {
    private static final String MALTEGO_ENTITIES_FOLDER = "Maltego/Entities";
    private static final String DEFAULT_FOLDER = "Miscellaneous";
    private FileSystemRegistry<MaltegoEntitySpec> _delegate;

    public DefaultEntityRegistry() {
        this(MALTEGO_ENTITIES_FOLDER);
    }

    public DefaultEntityRegistry(FileObject configRoot) {
        this(configRoot, MALTEGO_ENTITIES_FOLDER);
    }

    public DefaultEntityRegistry(String folder) {
        this(FileUtil.getConfigRoot(), folder);
    }

    public DefaultEntityRegistry(FileObject configRoot, String folder) {
        this._delegate = new FileSystemRegistry(configRoot, folder, "entity");
    }

    public void reloadEntities() {
        this._delegate.reloadEntities();
    }

    public MaltegoEntitySpec get(String typeName) {
        return this._delegate.get(typeName);
    }

    public Collection<MaltegoEntitySpec> getAll() {
        return this._delegate.getAll();
    }

    public void put(MaltegoEntitySpec spec) {
        this.put(spec, spec.getDefaultCategory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(MaltegoEntitySpec spec, String category) {
        if (spec.getTypeName() != null && spec.getTypeName().toLowerCase().startsWith("maltego.affiliation.myspace_")) {
            return;
        }
        if (category == null) {
            category = DEFAULT_FOLDER;
        }
        boolean found = true;
        Object object = this._delegate.getLock();
        synchronized (object) {
            if (this._delegate.contains(spec.getTypeName())) {
                this._delegate.update(spec);
            } else {
                found = false;
                this._delegate.add(spec, category);
            }
        }
        if (found) {
            this.fireTypeUpdated((TypeSpec)spec);
        } else {
            this.fireTypeAdded((TypeSpec)spec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String typeName) {
        MaltegoEntitySpec spec;
        Object object = this._delegate.getLock();
        synchronized (object) {
            spec = this.get(typeName);
            if (spec != null) {
                this._delegate.remove(typeName);
            }
        }
        if (spec != null) {
            this.fireTypeRemoved((TypeSpec)spec);
        }
    }

    public boolean contains(String typeName) {
        return this._delegate.contains(typeName);
    }

    public String[] allCategories() {
        return this._delegate.getFolders();
    }
}

