/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.memory;

import com.oracle.truffle.api.memory.ByteArraySupport;

final class SimpleByteArraySupport
extends ByteArraySupport {
    SimpleByteArraySupport() {
    }

    @Override
    public byte getByte(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return buffer[byteOffset];
    }

    @Override
    public void putByte(byte[] buffer, int byteOffset, byte value) throws IndexOutOfBoundsException {
        buffer[byteOffset] = value;
    }

    @Override
    public short getShort(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return (short)((buffer[byteOffset] & 0xFF) << 8 | buffer[byteOffset + 1] & 0xFF);
    }

    @Override
    public void putShort(byte[] buffer, int byteOffset, short value) throws IndexOutOfBoundsException {
        buffer[byteOffset + 0] = (byte)(value >> 8);
        buffer[byteOffset + 1] = (byte)value;
    }

    @Override
    public int getInt(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return (buffer[byteOffset + 0] & 0xFF) << 24 | (buffer[byteOffset + 1] & 0xFF) << 16 | (buffer[byteOffset + 2] & 0xFF) << 8 | buffer[byteOffset + 3] & 0xFF;
    }

    @Override
    public void putInt(byte[] buffer, int byteOffset, int value) throws IndexOutOfBoundsException {
        buffer[byteOffset + 0] = (byte)(value >> 24);
        buffer[byteOffset + 1] = (byte)(value >> 16);
        buffer[byteOffset + 2] = (byte)(value >> 8);
        buffer[byteOffset + 3] = (byte)value;
    }

    @Override
    public long getLong(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return ((long)buffer[byteOffset + 0] & 0xFFL) << 56 | ((long)buffer[byteOffset + 1] & 0xFFL) << 48 | ((long)buffer[byteOffset + 2] & 0xFFL) << 40 | ((long)buffer[byteOffset + 3] & 0xFFL) << 32 | ((long)buffer[byteOffset + 4] & 0xFFL) << 24 | ((long)buffer[byteOffset + 5] & 0xFFL) << 16 | ((long)buffer[byteOffset + 6] & 0xFFL) << 8 | (long)buffer[byteOffset + 7] & 0xFFL;
    }

    @Override
    public void putLong(byte[] buffer, int byteOffset, long value) throws IndexOutOfBoundsException {
        buffer[byteOffset + 0] = (byte)(value >> 56);
        buffer[byteOffset + 1] = (byte)(value >> 48);
        buffer[byteOffset + 2] = (byte)(value >> 40);
        buffer[byteOffset + 3] = (byte)(value >> 32);
        buffer[byteOffset + 4] = (byte)(value >> 24);
        buffer[byteOffset + 5] = (byte)(value >> 16);
        buffer[byteOffset + 6] = (byte)(value >> 8);
        buffer[byteOffset + 7] = (byte)value;
    }

    @Override
    public float getFloat(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.getInt(buffer, byteOffset));
    }

    @Override
    public void putFloat(byte[] buffer, int byteOffset, float value) throws IndexOutOfBoundsException {
        this.putInt(buffer, byteOffset, Float.floatToRawIntBits(value));
    }

    @Override
    public double getDouble(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.getLong(buffer, byteOffset));
    }

    @Override
    public void putDouble(byte[] buffer, int byteOffset, double value) throws IndexOutOfBoundsException {
        this.putLong(buffer, byteOffset, Double.doubleToRawLongBits(value));
    }
}

