/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio;

import gov.nist.isg.pyramidio.PartialImageReader;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;

class ImageReaderCache {
    private final BufferedImage cachedImage;
    private final Rectangle cachedRegion;

    ImageReaderCache(PartialImageReader imageReader, Rectangle cacheRegion) throws IOException {
        this.cachedImage = imageReader.read(cacheRegion);
        this.cachedRegion = cacheRegion;
    }

    BufferedImage read(Rectangle rectangle) throws IOException {
        if (!this.cachedRegion.contains(rectangle)) {
            throw new IOException(rectangle + " is outside of cached region " + this.cachedRegion);
        }
        return this.cachedImage.getSubimage(rectangle.x - this.cachedRegion.x, rectangle.y - this.cachedRegion.y, rectangle.width, rectangle.height);
    }
}

