/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.layout;

import com.paterva.graph.store.pandora.layout.LayoutArtifactUtils;
import com.paterva.graph.store.pandora.layout.LayoutCache;
import com.paterva.graph.store.pandora.parts.PandoraPartsReader;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.pinkmatter.pandora.Artifact;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraQueryResult;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PandoraGraphLayoutReader
extends PandoraPartsReader
implements GraphLayoutReader {
    PandoraGraphLayoutReader(GraphID id) {
        super(id);
    }

    public int getEntityCount() throws GraphStoreException {
        return this.getCenterCache().size();
    }

    public int getLinkCount() throws GraphStoreException {
        return this.getPathsCache().size();
    }

    public boolean exists(EntityID entityID) throws GraphStoreException {
        return this.getCenterCache().containsKey(entityID);
    }

    public boolean exists(LinkID linkID) throws GraphStoreException {
        return this.getPathsCache().containsKey(linkID);
    }

    public Map<EntityID, Point> getAllCenters() throws GraphStoreException {
        try {
            return Collections.unmodifiableMap(this.getCenterCache());
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Map<LinkID, List<Point>> getAllPaths() throws GraphStoreException {
        try {
            return Collections.unmodifiableMap(this.getPathsCache());
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Map<EntityID, Point> getCenters(Collection<EntityID> entities) throws GraphStoreException {
        if (entities.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        try {
            Map<EntityID, Point> cache = this.getCenterCache();
            HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>(entities.size());
            for (EntityID entityID : entities) {
                Point point = cache.get(entityID);
                centers.put(entityID, point);
            }
            return centers;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public Point getCenter(EntityID entity) throws GraphStoreException {
        Map<EntityID, Point> cache = this.getCenterCache();
        Point point = cache.get(entity);
        return point;
    }

    public Map<LinkID, List<Point>> getPaths(Collection<LinkID> links) throws GraphStoreException {
        if (links.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        try {
            Map<LinkID, List<Point>> cache = this.getPathsCache();
            HashMap<LinkID, List<Point>> paths = new HashMap<LinkID, List<Point>>(links.size());
            for (LinkID linkID : links) {
                List<Point> path = cache.get(linkID);
                paths.put(linkID, path);
            }
            return paths;
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public List<Point> getPath(LinkID link) throws GraphStoreException {
        Map<LinkID, List<Point>> pathsCache = this.getPathsCache();
        List<Point> path = pathsCache.get(link);
        return path;
    }

    private List<Artifact> toArtifacts(PandoraQueryResult result) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(result.getCount());
        for (Artifact artifact : result) {
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private Map<EntityID, Point> getCenterCache() throws GraphStoreException {
        return this.getLayoutCache().getCenterCache();
    }

    private Map<LinkID, List<Point>> getPathsCache() throws GraphStoreException {
        return this.getLayoutCache().getPathsCache();
    }

    private LayoutCache getLayoutCache() throws GraphStoreException {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)this.getGraphID());
        LayoutCache cache = (LayoutCache)gud.get((Object)(key = LayoutCache.class.getName()));
        if (cache == null) {
            cache = new LayoutCache();
            gud.put((Object)key, (Object)cache);
            this.initialize(cache);
        }
        return cache;
    }

    private void initialize(LayoutCache cache) throws GraphStoreException {
        try {
            this.initializeCenters(cache);
            this.initializePaths(cache);
        }
        catch (PandoraException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private void initializeCenters(LayoutCache cache) throws PandoraException {
        Map<EntityID, Point> centerCache = cache.getCenterCache();
        List<Artifact> artifacts = this.toArtifacts(this.getEntitySearch().query().includeAll().list());
        for (Artifact artifact : artifacts) {
            EntityID entityID = EntityID.create((long)artifact.getKey());
            Point point = LayoutArtifactUtils.getPoint((Map)artifact);
            centerCache.put(entityID, point);
        }
    }

    private void initializePaths(LayoutCache cache) throws PandoraException, GraphStoreException {
        Map<LinkID, List<Point>> pathsCache = cache.getPathsCache();
        List<Artifact> artifacts = this.toArtifacts(this.getLinkSearch().query().list());
        for (Artifact artifact : artifacts) {
            LinkID linkID = LinkID.create((long)artifact.getKey());
            List<Point> path = LayoutArtifactUtils.getPath(artifact);
            pathsCache.put(linkID, path);
        }
    }
}

