/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.server.HttpServerConnection;
import org.xlightweb.server.HttpSession;
import org.xlightweb.server.ISessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
implements ISessionManager {
    public static final Logger LOG = Logger.getLogger(SessionManager.class.getName());
    private static final long CLEANING_PERIOD_MILLIS = 5000L;
    private Cleaner cleaner;
    private final HashMap<String, HttpSession> sessions = new HashMap();
    private int numCreatedSessions = 0;
    private int numRemovedSessions = 0;
    private int numExpiredSessions = 0;

    public SessionManager() {
        this.cleaner = new Cleaner(this);
        HttpServerConnection.schedule(this.cleaner, 5000L, 5000L);
    }

    @Override
    public boolean isEmtpy() {
        return this.sessions.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpSession getSession(String sessionId) {
        HashMap<String, HttpSession> hashMap = this.sessions;
        synchronized (hashMap) {
            HttpSession session = this.sessions.get(sessionId);
            if (session != null) {
                long currentMillis = System.currentTimeMillis();
                session.setLastAccessTime(currentMillis);
                if (!session.isValid()) {
                    this.sessions.remove(session.getId());
                    session = null;
                }
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, HttpSession> getSessionMap() {
        Map sessionMap = null;
        HashMap<String, HttpSession> hashMap = this.sessions;
        synchronized (hashMap) {
            sessionMap = (Map)this.sessions.clone();
        }
        return sessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSession(HttpSession session) throws IOException {
        HashMap<String, HttpSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(session.getId(), session);
        }
    }

    @Override
    public void saveSession(String sessionId) throws IOException {
    }

    @Override
    public String newSession(String idPrefix) throws IOException {
        ++this.numCreatedSessions;
        String sessionId = idPrefix + "-" + UUID.randomUUID().toString();
        this.registerSession(new HttpSession(sessionId));
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(String sessionId) {
        ++this.numRemovedSessions;
        HashMap<String, HttpSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap sessionsCopy = null;
        HashMap<String, HttpSession> hashMap = this.sessions;
        synchronized (hashMap) {
            sessionsCopy = (HashMap)this.sessions.clone();
        }
        for (HttpSession httpSession : sessionsCopy.values()) {
            httpSession.invalidate();
        }
        hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.clear();
        }
        if (this.cleaner != null) {
            this.cleaner.close();
        }
        this.cleaner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clean() {
        block7: {
            try {
                HashMap sessionsCopy = null;
                HashMap<String, HttpSession> hashMap = this.sessions;
                synchronized (hashMap) {
                    sessionsCopy = (HashMap)this.sessions.clone();
                }
                for (Map.Entry entry : sessionsCopy.entrySet()) {
                    if (((HttpSession)entry.getValue()).isValid()) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("session " + entry.getValue() + " has been expired. Deleting it");
                    }
                    ++this.numExpiredSessions;
                    this.removeSession(((HttpSession)entry.getValue()).getId());
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by cleaning sessions " + e.toString());
            }
        }
    }

    public int getNumCreatedSessions() {
        return this.numCreatedSessions;
    }

    public int getNumRemovedSessions() {
        return this.numRemovedSessions;
    }

    public int getNumExpiredSessions() {
        return this.numExpiredSessions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (");
        for (Map.Entry<String, HttpSession> entry : this.sessions.entrySet()) {
            sb.append(entry.getKey() + "-> " + entry.getValue() + "  ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static final class Cleaner
    extends TimerTask
    implements Closeable {
        private WeakReference<SessionManager> sessionManagerRef;

        public Cleaner(SessionManager sessionManager) {
            this.sessionManagerRef = new WeakReference<SessionManager>(sessionManager);
        }

        public void run() {
            WeakReference<SessionManager> ref = this.sessionManagerRef;
            if (ref != null) {
                SessionManager sessionManager = (SessionManager)ref.get();
                if (sessionManager == null) {
                    this.close();
                } else {
                    sessionManager.clean();
                }
            }
        }

        public void close() {
            this.cancel();
            this.sessionManagerRef = null;
        }
    }
}

