/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome;

import com.paterva.maltego.util.ui.actions.ActionSupplemental;
import com.paterva.maltego.welcome.Bundle;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

@ActionSupplemental(key="description", value="Open the folder that contains the Maltego logs.")
public final class OpenLogsFolderAction
extends SystemAction {
    public String getName() {
        return Bundle.CTL_OpenLogsFolderAction();
    }

    public void actionPerformed(ActionEvent ev) {
        File userDir = Places.getUserDirectory();
        if (!userDir.isDirectory()) {
            this.showNotExist(userDir);
        } else {
            File varDir = new File(userDir, "var");
            if (!varDir.isDirectory()) {
                this.showNotExist(varDir);
            } else {
                File logDir = new File(varDir, "log");
                if (!logDir.isDirectory()) {
                    this.showNotExist(logDir);
                } else {
                    try {
                        Desktop.getDesktop().open(logDir);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void showNotExist(File folder) {
        String msg = "Folder does not exist: " + folder;
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
        nd.setTitle("Folder Missing");
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
    }
}

