/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class DefaultTreeListItemRenderer
implements TreeListItemRenderer {
    private final UIDefaults LAF = UIManager.getLookAndFeelDefaults();

    private Font getFontScaled(String key) {
        Font font = this.LAF.getFont(key);
        return font;
    }

    protected String getLafKey(TreeListItem item, String attribute) {
        return "run-" + item.getLafPrefix() + "-" + attribute;
    }

    @Override
    public Font getDisplayNameFont(TreeListItem item) {
        return this.getFontScaled(this.getLafKey(item, "name-font"));
    }

    @Override
    public Font getDescriptionFont(TreeListItem item) {
        return this.getFontScaled(this.getLafKey(item, "description-font"));
    }

    @Override
    public boolean displayIcon(TreeListItem item) {
        return this.LAF.getBoolean(this.getLafKey(item, "pic"));
    }

    @Override
    public Color getBgColor(TreeListItem item, boolean selected, boolean hovered) {
        return this.getColor(item, "bg", selected, hovered);
    }

    @Override
    public Color getDisplayNameFgColor(TreeListItem item, boolean selected, boolean hovered) {
        return this.getColor(item, "name-fg", selected, false);
    }

    @Override
    public Color getDescriptionFgColor(TreeListItem item, boolean selected, boolean hovered) {
        return this.getColor(item, "description-fg", selected, false);
    }

    protected Color getColor(TreeListItem item, String attribute, boolean selected, boolean hovered) {
        String attr = this.getAttribute(attribute, selected, hovered);
        return this.getColor(item, attr);
    }

    protected String getAttribute(String attr, boolean selected, boolean hovered) {
        if (selected) {
            attr = attr + "-selected";
        }
        if (hovered) {
            attr = attr + "-hovered";
        }
        return attr;
    }

    protected Color getColor(TreeListItem item, String attribute) {
        return this.LAF.getColor(this.getLafKey(item, attribute));
    }

    @Override
    public void paintBackground(TreeListItem item, Graphics2D g2D, int width, int height, boolean hovered) {
        this.paintBackground(item, g2D, width, height, hovered, false);
    }

    protected void paintBackground(TreeListItem item, Graphics2D g2D, int width, int height, boolean hovered, boolean basic) {
        Color bg = this.getBgColor(item, item.isSelected(), hovered);
        if (bg != null) {
            if (!this.isLeaf(item) || basic) {
                g2D.setColor(UIManager.getLookAndFeelDefaults().getColor("run-bg-color"));
                g2D.fillRect(0, 0, width, 1);
                g2D.setColor(bg);
                g2D.fillRect(0, 1, width, height);
            } else {
                g2D.setColor(bg);
                g2D.fillRoundRect(0, 0, width, height, 0, 0);
            }
        }
    }

    @Override
    public void paintBorder(TreeListItem item, Graphics2D g2D, int width, int height, boolean hovered) {
        this.paintBorder(item, g2D, width, height, hovered, false);
    }

    protected void paintBorder(TreeListItem item, Graphics2D g2D, int width, int height, boolean hovered, boolean basic) {
    }

    protected boolean isLeaf(TreeListItem item) {
        return item.getChildren().isEmpty();
    }
}

