/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Set;
import javax.swing.JComponent;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.TopComponent;
import yguard.A.A.E;
import yguard.A.A.Z;
import yguard.A.J.SA;
import yguard.A.J.U;

public class ZoomToSelectionAction
extends TopGraphAction {
    public String getName() {
        return "Zoom Selection";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/ZoomSelection.png";
    }

    @Override
    protected void actionPerformed(TopComponent tc) {
        this.zoomToSelection(this.getTopGraphView());
    }

    public void zoomToSelection() {
        this.zoomToSelection(this.getCookie());
    }

    private GraphViewCookie getCookie() {
        TopComponent topComponent = this.getTopComponent();
        if (topComponent == null) {
            return null;
        }
        return (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class);
    }

    public void zoomToSelection(GraphViewCookie cookie) {
        if (cookie != null) {
            GraphView graphView = cookie.getGraphView();
            this.zoomToSelection(graphView);
        }
    }

    public void zoomToSelection(GraphView graphView) {
        JComponent viewControl;
        if (graphView != null && (viewControl = graphView.getViewControl()) instanceof U) {
            U g2DView = (U)viewControl;
            this.zoomToSelection(g2DView);
        }
    }

    private void zoomToSelection(U g2DView) {
        Rectangle2D.Double awtRect;
        Object rectangle;
        SA graph2D = g2DView.getGraph2D();
        Rectangle2D.Double allRect = null;
        E selectedNodes = graph2D.\u0108();
        Z selectedLinks = graph2D.\u0101();
        if (selectedNodes == null || selectedNodes.size() == 0) {
            if (selectedLinks == null || selectedLinks.size() == 0) {
                StatusDisplayer.getDefault().setStatusText("No entities or links selected");
                return;
            }
            while (selectedLinks.ok()) {
                rectangle = graph2D.X(selectedLinks.D()).getPath().getBounds();
                awtRect = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (allRect == null) {
                    allRect = awtRect;
                } else {
                    allRect.add(awtRect);
                }
                selectedLinks.next();
            }
        } else {
            while (selectedNodes.ok()) {
                rectangle = graph2D.M(selectedNodes.B());
                awtRect = new Rectangle2D.Double(rectangle.\u00fa, rectangle.\u00fc, rectangle.\u00f9, rectangle.\u00f8);
                if (allRect == null) {
                    allRect = awtRect;
                } else {
                    allRect.add(awtRect);
                }
                selectedNodes.next();
            }
        }
        if (allRect != null) {
            Dimension viewSize = g2DView.getViewSize();
            Rectangle2D.Double rect = new Rectangle2D.Double(allRect.x - 30.0, allRect.y - 30.0, allRect.width + 60.0, allRect.height + 60.0);
            double zoomCalc = Math.min((double)viewSize.width / ((RectangularShape)rect).getWidth(), (double)viewSize.height / ((RectangularShape)rect).getHeight());
            if (zoomCalc > 1.0) {
                zoomCalc = 1.0;
            }
            g2DView.focusView(zoomCalc, (Point2D)new Point2D.Double(rect.getCenterX(), rect.getCenterY()), true);
        }
    }

    public void zoomToSelection(SA viewGraph) {
        Set<TopComponent> openTCs = GraphEditorRegistry.getDefault().getOpen();
        for (TopComponent tc : openTCs) {
            GraphView graphView;
            SA graph;
            GraphViewCookie cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
            if (cookie == null || !viewGraph.equals(graph = (graphView = cookie.getGraphView()).getViewGraph())) continue;
            this.zoomToSelection(cookie);
        }
    }
}

