/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import com.paterva.maltego.ui.graph.view2d.layout.FastHierarchicLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoHierarchicLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.MatrixLayouter;
import com.paterva.maltego.ui.graph.view2d.layout.SmartLayouter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.I;
import yguard.A.A.X;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.G.D.B;
import yguard.A.G.D.K;
import yguard.A.G.H.m;
import yguard.A.G.P;
import yguard.A.G.RA;
import yguard.A.G.n;
import yguard.A.G.t;

public class MaltegoLayouter
extends SmartLayouter {
    private static final Logger LOG = Logger.getLogger(MaltegoLayouter.class.getName());
    private Set<Y> _newNodes = Collections.EMPTY_SET;
    private Set<Y> _leafNodes;
    private boolean _incremental = false;

    public boolean canLayout(RA lg) {
        return true;
    }

    public void setIncremental(boolean incremental) {
        this._incremental = incremental;
    }

    public void setNewNodes(Set<Y> newNodes) {
        this._newNodes = new HashSet<Y>(newNodes);
        this.expandNewNodesToParents();
    }

    @Override
    protected void initialize(RA currentGraph) {
        super.initialize(currentGraph);
        this._leafNodes = new HashSet<Y>();
        E nc = this.getLayoutGraph().\u00a4();
        while (nc.ok()) {
            Y layoutNode = nc.B();
            Y originalNode = this.getOriginalNode(layoutNode);
            if (MaltegoLayouter.isLeefNode(originalNode)) {
                this._leafNodes.add(layoutNode);
            }
            nc.next();
        }
    }

    private void configureGroups(n outer, n inner) {
        RA layoutGraph = this.getLayoutGraph();
        I nodeId = layoutGraph.\u00ba();
        I parentNodeId = layoutGraph.\u00ba();
        I groupKey = layoutGraph.\u00ba();
        I layoutMap = layoutGraph.\u00ba();
        layoutGraph.A(K.E, (yguard.A.A.K)nodeId);
        layoutGraph.A(K.B, (yguard.A.A.K)parentNodeId);
        layoutGraph.A(K.A, (yguard.A.A.K)groupKey);
        layoutGraph.A(t.\u10af, (yguard.A.A.K)layoutMap);
        LinkedHashMap<Y, X> leafNodeMap = new LinkedHashMap<Y, X>();
        int index = 0;
        E nc = layoutGraph.\u00a4();
        while (nc.ok()) {
            Y layoutNode = nc.B();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Node: {0}", layoutNode);
                LOG.log(Level.FINE, "Original node: {0}", this.getOriginalNode(layoutNode));
            }
            if (this._leafNodes.contains(layoutNode)) {
                LOG.log(Level.FINE, "Leaf=YES");
                Y originalNode = this.getOriginalNode(layoutNode);
                Y parent = originalNode.Q().X();
                LOG.log(Level.FINE, "Parent: {0}", parent);
                parent = this.getLayoutNode(parent);
                X leafNodes = (X)leafNodeMap.get(parent);
                if (leafNodes == null) {
                    leafNodes = new X();
                    leafNodeMap.put(parent, leafNodes);
                }
                leafNodes.add((Object)layoutNode);
                layoutMap.set((Object)layoutNode, (Object)inner);
            } else {
                LOG.log(Level.FINE, "Leaf=NO");
                layoutMap.set((Object)layoutNode, (Object)outer);
            }
            LOG.log(Level.FINE, "Index: {0}\n", index);
            nodeId.set((Object)layoutNode, (Object)index++);
            nc.next();
        }
        int groupIndex = 0x3FFFFFFF;
        for (X list : leafNodeMap.values()) {
            Y groupNode = layoutGraph.w();
            groupKey.setBool((Object)groupNode, true);
            nodeId.set((Object)groupNode, (Object)groupIndex);
            E nc2 = list.\u0121();
            while (nc2.ok()) {
                Y node = nc2.B();
                parentNodeId.set((Object)node, (Object)groupIndex);
                nc2.next();
            }
            if (this._incremental) {
                this._newNodes.add(groupNode);
            }
            ++groupIndex;
        }
    }

    private void logWarning(String msg) {
        this.getLogger().log(Level.WARNING, msg);
    }

    private Logger getLogger() {
        return Logger.getLogger(MaltegoLayouter.class.getName());
    }

    private void restoreGroups(RA graph) {
        E nodes = graph.\u00a4();
        if (nodes == null) {
            this.logWarning("LayoutGraph.nodes() returned null.");
        } else {
            yguard.A.A.K dataProvider = graph.B(K.A);
            if (dataProvider == null) {
                this.logWarning("GROUP_DPKEY data provider is null.");
            } else {
                X groups = new X(nodes, dataProvider);
                E nc = groups.\u0121();
                while (nc.ok()) {
                    graph.B(nc.B());
                    nc.next();
                }
            }
        }
        this.disposeNodeMap(graph, K.E);
        this.disposeNodeMap(graph, K.B);
        this.disposeNodeMap(graph, K.A);
        this.disposeNodeMap(graph, t.\u10af);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout(RA graph) {
        LOG.fine("Layout Start");
        try {
            Object outerLayouter;
            if (LOG.isLoggable(Level.FINE)) {
                E nc = graph.\u00a4();
                while (nc.ok()) {
                    Y node = nc.B();
                    LOG.log(Level.FINE, "{0}", node);
                    nc.next();
                }
            }
            this.initialize(graph);
            if (this._incremental) {
                m ihl = new m();
                ihl.n(60.0);
                ihl.K((byte)0);
                MaltegoHierarchicLayouter mhl = new MaltegoHierarchicLayouter(this._newNodes);
                mhl.setCoreLayouter((n)ihl);
                outerLayouter = mhl;
            } else {
                FastHierarchicLayouter hierarchicLayouter = new FastHierarchicLayouter();
                hierarchicLayouter.setMinimalFirstSegmentLength(60.0);
                outerLayouter = hierarchicLayouter;
            }
            try {
                this.configureGroups((n)outerLayouter, new MatrixLayouter());
                t lm = new t();
                B rgl = new B((n)lm);
                rgl.doLayout(graph);
                this.repositionEdges();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.restoreGroups(graph);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this._leafNodes = null;
        }
        LOG.fine("Layout End");
    }

    private void repositionEdges() {
        RA layoutGraph = this.getLayoutGraph();
        E nc = layoutGraph.\u00a4();
        while (nc.ok()) {
            H edge;
            Y layoutNode = nc.B();
            if (this._leafNodes.contains(layoutNode) && (edge = layoutNode.Q()) != null) {
                P layout = layoutGraph.Q(edge);
                layout.clearPoints();
                layoutGraph.B(edge, layoutGraph.P(edge.X()));
                layoutGraph.D(edge, layoutGraph.P(layoutNode));
            }
            nc.next();
        }
    }

    private static boolean isLeefNode(Y node) {
        return node.C() == 0 && node.O() == 1;
    }

    private void expandNewNodesToParents() {
        HashSet<Y> parents = new HashSet<Y>();
        for (Y node : this._newNodes) {
            if (node.O() <= 0) continue;
            Z edges = node.M();
            while (edges.ok()) {
                parents.add(edges.D().X());
                edges.next();
            }
        }
        this._newNodes.addAll(parents);
    }

    private X getSortedNodes(RA graph) {
        final yguard.A.A.K idProvider = graph.B((Object)"nodeOrder");
        X nodes = new X(graph.\u00a4());
        nodes.sort((Comparator)new Comparator<Y>(){

            @Override
            public int compare(Y o1, Y o2) {
                int o1Int = idProvider.getInt((Object)o1);
                LOG.log(Level.FINE, "{0}->{1}", new Object[]{o1Int, MaltegoLayouter.this.getOriginalNode(o1)});
                int o2Int = idProvider.getInt((Object)o2);
                LOG.log(Level.FINE, "{0}->{1}", new Object[]{o2Int, MaltegoLayouter.this.getOriginalNode(o2)});
                return o1Int - o2Int;
            }
        });
        return nodes;
    }
}

