/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.EntityRegistryTableModel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.util.List;
import javax.swing.table.TableModel;

class EntityQuickFilter
implements TextQuickFilter {
    private String _text;
    private final EntityRegistryTableModel _model;
    private final List<MaltegoEntitySpec> _specs;

    public EntityQuickFilter(EntityRegistryTableModel model) {
        this._model = model;
        this._specs = this._model.getRows();
    }

    public boolean accept(Object obj) {
        return true;
    }

    public boolean accept(TableModel model, int row, int quickFilterColumn, Object obj) {
        if (obj instanceof String) {
            MaltegoEntitySpec spec;
            String displayNameColumnValue = ((String)obj).toLowerCase();
            if (displayNameColumnValue.contains(this._text)) {
                return true;
            }
            if (this._specs == null) {
                return false;
            }
            try {
                spec = this._specs.get(row);
            }
            catch (IndexOutOfBoundsException ex) {
                return false;
            }
            return this.descriptionOrTypeContainsSearch(spec, displayNameColumnValue);
        }
        return true;
    }

    private boolean descriptionOrTypeContainsSearch(MaltegoEntitySpec spec, String displayNameColumnValue) {
        String specDisplayName = spec.getDisplayName();
        if (displayNameColumnValue.equalsIgnoreCase(specDisplayName)) {
            String description = spec.getDescription();
            if (description != null && description.toLowerCase().contains(this._text)) {
                return true;
            }
            String typeName = spec.getTypeName();
            if (typeName != null && typeName.toLowerCase().contains(this._text)) {
                return true;
            }
        }
        return false;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text.toLowerCase();
    }
}

