/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub.item;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedIcon;
import com.paterva.maltego.seeds.api.HubSeedProvider;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedHoverPanel;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedListenerHoverAwarePanel;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedMainPanel;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedRefreshCallback;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.BusySpinnerPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class HubSeedPanel
extends HubSeedListenerHoverAwarePanel {
    public static final ImageIcon IMG_HUB_SEED_DEFAULT = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/seeds/ui/resources/DefaultHubSeed.png", (boolean)true);
    public static final ImageIcon IMG_CUSTOM_SEED_DEFAULT = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/seeds/ui/resources/DefaultCustomSeed.png", (boolean)true);
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final String MAIN_CARD = "main";
    private static final String HOVER_CARD = "hover";
    private static final String PROGRESS_VIEW = "progress";
    private final BusySpinnerPanel _busySpinnerPanel = new BusySpinnerPanel();
    private final HubSeedDescriptor _seed;
    private final CardLayout _cardLayout;
    private final HubSeedHoverPanel _hubSeedHoverPanel;
    private boolean _inProgress = false;
    private JPanel _cardPanel;
    private JPanel _hubItemDivider;
    private JLabel _iconLabel;
    private JLabel _nameLabel;
    private JPanel _nameStatusPanel;
    private JLabel _providerLabel;
    private JLabel _statusLabel;
    private JPanel _topNamePanel;

    public HubSeedPanel(HubSeedDescriptor seed) {
        this._seed = seed;
        this.initComponents();
        this._cardLayout = new CardLayout();
        this._cardPanel.setLayout(this._cardLayout);
        HubSeedRefreshCallback cb = new HubSeedRefreshCallback(){

            @Override
            public void started() {
                HubSeedPanel.this._inProgress = true;
                HubSeedPanel.this._busySpinnerPanel.setBackground(HubSeedPanel.this.getUpdatedBackground());
                HubSeedPanel.this._cardLayout.show(HubSeedPanel.this._cardPanel, HubSeedPanel.PROGRESS_VIEW);
            }

            @Override
            public void completed() {
                HubSeedPanel.this._inProgress = false;
                HubSeedPanel.this.onHoveredChanged();
            }

            @Override
            public void failed(String message, Exception ex) {
                HubSeedPanel.this._inProgress = false;
                HubSeedPanel.this.onHoveredChanged();
            }
        };
        this._cardPanel.add((Component)((Object)new HubSeedMainPanel(this._seed)), MAIN_CARD);
        this._hubSeedHoverPanel = new HubSeedHoverPanel(this._seed, cb);
        this._cardPanel.add((Component)((Object)this._hubSeedHoverPanel), HOVER_CARD);
        this._busySpinnerPanel.setBackground(this.getUpdatedBackground());
        this._cardPanel.add((Component)this._busySpinnerPanel, PROGRESS_VIEW);
        if (this._seed != null) {
            if (this._seed.isCustom()) {
                this._hubItemDivider.setBackground(LAF.getColor("hub-item-divider-custom-bg"));
            } else {
                this._hubItemDivider.setBackground(LAF.getColor("hub-item-divider-bg"));
            }
            this.update();
        }
    }

    @Override
    public HubSeedDescriptor getSeed() {
        return this._seed;
    }

    private void update() {
        this.updateName();
        this.updateStatus();
        this.updateProvider();
        this.updateIcon();
        this.updateBackground();
    }

    private void updateName() {
        this._nameLabel.setText(this._seed.getDisplayName());
        Color color = LAF.getColor("hub-item-name-fg");
        this._nameLabel.setForeground(color);
        this._nameLabel.setFont(this.getFontScaled("hub-item-name-font"));
    }

    private void updateStatus() {
        String colorString;
        String text;
        if (this._seed.isCustom()) {
            text = "";
            colorString = "hub-item-type-fg-custom";
        } else {
            text = "";
            colorString = "hub-item-type-fg-online";
        }
        this._statusLabel.setText(text);
        this._statusLabel.setForeground(LAF.getColor(colorString));
        this._statusLabel.setFont(this.getFontScaled("hub-item-type-font"));
    }

    private void updateProvider() {
        HubSeedProvider provider = this._seed.getProvider();
        String providerName = "";
        if (provider != null) {
            providerName = provider.getName();
        }
        if (!StringUtilities.isNullOrEmpty((String)providerName)) {
            providerName = "by " + providerName;
        }
        this._providerLabel.setText(providerName);
        this._providerLabel.setVisible(!StringUtilities.isNullOrEmpty((String)providerName));
        Color color = LAF.getColor("hub-item-provider-fg");
        this._providerLabel.setForeground(color);
        this._providerLabel.setFont(this.getFontScaled("hub-item-provider-font"));
    }

    private void updateIcon() {
        HubSeedIcon seedIcon;
        this._iconLabel.setText("");
        if (this._iconLabel.getIcon() == null) {
            this.setImage(this._seed.isCustom() ? IMG_CUSTOM_SEED_DEFAULT : IMG_HUB_SEED_DEFAULT);
        }
        if ((seedIcon = this._seed.getIcon()) != null) {
            Image image = seedIcon.getImage((ImageCallback)new SeedIconCallback());
            this.setImage(ImageUtils.toIcon((Image)image));
        }
    }

    private void setImage(ImageIcon icon) {
        if (icon != null) {
            this._iconLabel.setIcon(icon);
        }
    }

    private Font getFontScaled(String key) {
        Font font = LAF.getFont(key);
        return font;
    }

    private void initComponents() {
        this._iconLabel = new JLabel();
        this._topNamePanel = new JPanel();
        this._nameStatusPanel = new JPanel();
        this._nameLabel = new JLabel();
        this._statusLabel = new JLabel();
        this._providerLabel = new JLabel();
        this._hubItemDivider = new JPanel();
        this._cardPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._iconLabel, (String)NbBundle.getMessage(HubSeedPanel.class, (String)"HubSeedPanel._iconLabel.text"));
        this._iconLabel.setMaximumSize(new Dimension(48, 48));
        this._iconLabel.setMinimumSize(new Dimension(48, 48));
        this._iconLabel.setPreferredSize(new Dimension(48, 48));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 3, 3);
        this.add(this._iconLabel, gridBagConstraints);
        this._topNamePanel.setOpaque(false);
        this._topNamePanel.setLayout(new GridBagLayout());
        this._nameStatusPanel.setOpaque(false);
        this._nameStatusPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._nameLabel, (String)NbBundle.getMessage(HubSeedPanel.class, (String)"HubSeedPanel._nameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this._nameStatusPanel.add((Component)this._nameLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._statusLabel, (String)NbBundle.getMessage(HubSeedPanel.class, (String)"HubSeedPanel._statusLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(1, 1, 1, 6);
        this._nameStatusPanel.add((Component)this._statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4;
        this._topNamePanel.add((Component)this._nameStatusPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._providerLabel, (String)NbBundle.getMessage(HubSeedPanel.class, (String)"HubSeedPanel._providerLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this._topNamePanel.add((Component)this._providerLabel, gridBagConstraints);
        this._hubItemDivider.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this._hubItemDivider.setMinimumSize(new Dimension(10, 2));
        this._hubItemDivider.setPreferredSize(new Dimension(10, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this._topNamePanel.add((Component)this._hubItemDivider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add(this._topNamePanel, gridBagConstraints);
        this._cardPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add(this._cardPanel, gridBagConstraints);
    }

    protected void onHoveredChanged() {
        if (!this._inProgress) {
            this.updateBackground();
            this._cardLayout.show(this._cardPanel, this.isHovered(true) ? HOVER_CARD : MAIN_CARD);
        }
    }

    @Override
    public void onSeedChanged() {
        this.update();
    }

    protected void onPanelClicked() {
        this._hubSeedHoverPanel.onPanelClicked();
    }

    private void updateBackground() {
        if (!this._inProgress) {
            Color bgColor = this.getUpdatedBackground();
            this.setBackground(bgColor);
            this.repaint();
        }
    }

    private Color getUpdatedBackground() {
        if (this._seed != null) {
            boolean installed = HubSeedSettings.getDefault().isInstalled(this._seed);
            Color bgColor = installed ? LAF.getColor("hub-item-installed-bg") : LAF.getColor("hub-item-bg");
            return bgColor;
        }
        return this.getBackground();
    }

    private class SeedIconCallback
    implements ImageCallback {
        private SeedIconCallback() {
        }

        public void imageReady(Image image) {
            HubSeedPanel.this.setImage(this.toIcon(image));
        }

        public void imageFailed(Exception ex) {
            String msg = ex.getMessage();
            if (msg != null && msg.contains("dropped due to load")) {
                SwingUtilities.invokeLater(() -> HubSeedPanel.this.updateIcon());
            }
        }
    }
}

