/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.menu;

import com.paterva.maltego.util.ui.menu.MenuViewItem;
import com.paterva.maltego.util.ui.menu.MultiActionMenu;
import com.paterva.maltego.util.ui.menu.MultiActionMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;

public abstract class MenuViewFactory<T> {
    public static String ACTION_CAN_REPEAT = "maltego.canRepeat";
    private static DefaultMenuViewFactory _menu;
    private static DefaultPopupViewFactory _popup;
    private static final TimerAction _timer;

    public static MenuViewFactory<JMenu> menu() {
        if (_menu == null) {
            _menu = new DefaultMenuViewFactory();
        }
        return _menu;
    }

    public static MenuViewFactory<JPopupMenu> popup() {
        if (_popup == null) {
            _popup = new DefaultPopupViewFactory();
        }
        return _popup;
    }

    public abstract void populate(T var1, MenuViewItem[] var2);

    protected void populateMenu(JMenu menu, MenuViewItem[] nodes) {
        for (MenuViewItem node : nodes) {
            if (node == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(this.createItem(node));
        }
    }

    protected JMenuItem createItem(MenuViewItem node) {
        JMenuItem item;
        MenuViewItem[] children = node.getChildren();
        if (children.length > 0) {
            JMenu menu = node.getSettingsAction() == null ? new JMenu(node.getDisplayName()) : new MultiActionMenu(node.getDisplayName(), MenuViewFactory.createSecondaryActions(node));
            this.populateMenu(menu, children);
            item = menu;
        } else {
            item = node.getAction() != null ? new MultiActionMenuItem(node.getAction(), MenuViewFactory.createSecondaryActions(node)) : new JMenuItem(node.getDisplayName());
        }
        item.setToolTipText(node.getDescription());
        return item;
    }

    private static Action[] createSecondaryActions(MenuViewItem node) {
        int count = 0;
        Action action = node.getAction();
        ActionListener settingsAction = node.getSettingsAction();
        ActionListener helpAction = node.getHelpAction();
        if (settingsAction != null) {
            ++count;
        }
        if (action != null && action.getValue(ACTION_CAN_REPEAT) == Boolean.TRUE) {
            ++count;
        }
        if (helpAction != null) {
            ++count;
        }
        Action[] actions = new Action[count];
        int index = 0;
        if (settingsAction != null) {
            actions[index] = new SettingsAction(settingsAction);
            ++index;
        }
        if (action != null && action.getValue(ACTION_CAN_REPEAT) == Boolean.TRUE) {
            actions[index] = _timer;
            ++index;
        }
        if (helpAction != null) {
            actions[index] = new HelpAction(helpAction);
            ++index;
        }
        return actions;
    }

    static {
        _timer = new TimerAction();
    }

    private static class TimerAction
    extends AbstractAction {
        public TimerAction() {
            super("Timer");
            this.putValue("SmallIcon", ImageUtilities.loadImage((String)"com/paterva/maltego/transform/runner/actions/Clock.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"You had to try...", 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private static class SettingsAction
    extends AbstractAction {
        private final ActionListener _action;

        public SettingsAction(ActionListener action) {
            super("Settings");
            this._action = action;
            this.putValue("SmallIcon", ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/menu/Config.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._action.actionPerformed(e);
        }
    }

    private static class HelpAction
    extends AbstractAction {
        private final ActionListener _action;

        public HelpAction(ActionListener action) {
            super("Help");
            this._action = action;
            this.putValue("SmallIcon", ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/menu/Help.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._action.actionPerformed(e);
        }
    }

    private static class DefaultPopupViewFactory
    extends MenuViewFactory<JPopupMenu> {
        private DefaultPopupViewFactory() {
        }

        @Override
        public void populate(JPopupMenu menu, MenuViewItem[] nodes) {
            for (MenuViewItem node : nodes) {
                if (node == null) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(this.createItem(node));
            }
        }
    }

    private static class DefaultMenuViewFactory
    extends MenuViewFactory<JMenu> {
        private DefaultMenuViewFactory() {
        }

        @Override
        public void populate(JMenu menu, MenuViewItem[] nodes) {
            this.populateMenu(menu, nodes);
        }
    }
}

