# Gufw 12.10.0 - http://gufw.tuxfamily.org
# Copyright (C) 2008-2012 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Giacomo Picchiarelli https://launchpad.net/~gpicchiarelli
# 	
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

import commands
import time
from time import strftime
import os
import hashlib

class BackupRules:  
    rules_file = 'user.rules'
    rules6_file = 'user6.rules'
    
    def __init__(self):
      self = self.backup()
      
    def templateFile(self):
        tempo = strftime("%a, %d %b %Y %H:%M:%S", time.localtime())
        file = "Gufw - Uncomplicated Firewall GUI Backup Rules file\n\n@@ DO NOT EDIT THIS FILE @@\n\nCreated: "+tempo+"\n"
        return file 
  
    def backup(self):
        #READ FILE AND EXTRACT RULES TEXT
        input = open(self.getRulesPath(self.rules_file),'r') 
        content = input.read()
        input.close()
        sect1 = content.partition("### RULES ###")
        sect2 = sect1[2].partition("### END RULES ###")
        rules = sect2[0]
        
        #READ FILE AND EXTRACT RULES6 TEXT
        input = open(self.getRulesPath(self.rules6_file),'r') 
        content = input.read()
        input.close()
        sect1 = content.partition("### RULES ###")
        sect2 = sect1[2].partition("### END RULES ###")
        rules6 = sect2[0]
                
        #COMPILE FILEBACKUP  
        comp = ''
        comp += str(self.templateFile())
        comp += '#RULES-SECTION'+str(rules)+'#END-RULES-SECTION'
        comp +='\n'+'#RULES6-SECTION'+str(rules6)+'#END6-RULES-SECTION'
        checkin = self.integrityCheck(comp) 
        comp += '\n --- INTEGRITY CHECK SHA512 --- \n' + checkin 
        
        #Save file        
        namesave = 'gufw_rules_'+strftime("%d-%m-%Y_%H.%M.%S", time.localtime())
        fsave = open(self.getBackupPath(namesave),'w+b') 
        fsave.write(comp)
        fsave.close()        
      
    def restore(self):
        input = open(self.getBackupPath(namesave),'w+b')
    
    def integrityCheck(self,p_file):
        return hashlib.sha512(p_file).hexdigest()
    
    #/lib/ufw/user.rules
    def getRulesPath (self,rsfile):
        """Return Rules Path"""  # /lib/ufw      
        path = os.path.join('/home', 'giacomo', rsfile)
        if not os.path.exists(path):
            print "Error: rules file not found"
        return path
        #/lib/ufw/user.rules
    def getBackupPath (self,rsfile):
        path = os.path.join('/home', 'giacomo', rsfile)
        return path

obj = BackupRules()




