/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomMgr;
import ancestris.gedcom.GedcomUndoRedo;
import ancestris.util.TimingUtility;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Property;
import genj.util.Resources;
import genj.view.SelectionListener;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class GedcomDataObject
extends MultiDataObject
implements SelectionListener,
GedcomMetaListener {
    static final Resources RES = Resources.get(GedcomMgr.class);
    private Context context;
    private GedcomUndoRedo undoredo;
    private final Lookup lookup;
    private final InstanceContent lookupContents = new InstanceContent();
    private final Lookup.Result<Context> result;
    private FileObject fileObject = null;
    private boolean isCancelled = false;
    private final SaveCookie saveCookie;

    public GedcomDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.fileObject = pf;
        this.saveCookie = new SaveCookie(){

            public void save() throws IOException {
                GedcomDataObject.this.saveDocument();
            }
        };
        this.lookup = new ProxyLookup(new Lookup[]{super.getLookup(), new AbstractLookup((AbstractLookup.Content)this.lookupContents)});
        this.result = this.lookup.lookupResult(Context.class);
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Context context = (Context)GedcomDataObject.this.lookup.lookup(Context.class);
                if (context != null) {
                    for (SelectionListener listener : AncestrisPlugin.lookupAll(SelectionListener.class)) {
                        listener.setContext(context);
                    }
                }
            }
        });
        this.registerEditor("text/x-gedcom", true);
        this.load();
    }

    public boolean load() {
        this.context = GedcomMgr.getDefault().openGedcom(this.fileObject);
        if (this.context == null) {
            GedcomMgr.LOG.log(Level.SEVERE, "{0}: gedcomOpened", TimingUtility.getInstance().getTime());
            GedcomMgr.LOG.log(Level.SEVERE, "Unable to open file {0}", this.fileObject.getPath());
            return false;
        }
        this.context.getGedcom().addGedcomListener(this);
        GedcomDirectory.getDefault().registerGedcom(this);
        this.undoredo = new GedcomUndoRedo(this.context.getGedcom());
        AncestrisPlugin.register((Object)this);
        return true;
    }

    public void setCancelled(boolean set) {
        this.isCancelled = set;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    protected Node createNodeDelegate() {
        return new DataNode((DataObject)this, Children.LEAF, this.getLookup());
    }

    protected int associateLookup() {
        return 1;
    }

    public InstanceContent getLookupContents() {
        return this.lookupContents;
    }

    public <T> void assign(Class<? extends T> clazz, T ... instances) {
        for (Object ic : this.lookup.lookupAll(clazz)) {
            this.lookupContents.remove(ic);
        }
        for (T ic : instances) {
            this.lookupContents.add(ic);
        }
    }

    public GedcomUndoRedo getUndoRedo() {
        return this.undoredo;
    }

    public static MultiViewEditorElement createEditor(Lookup lkp) {
        return new MultiViewEditorElement(lkp);
    }

    @Override
    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        this.updateModified();
    }

    @Override
    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        this.updateModified();
    }

    @Override
    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        this.updateModified();
    }

    @Override
    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        this.updateModified();
    }

    @Override
    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        this.updateModified();
    }

    @Override
    public void gedcomHeaderChanged(Gedcom gedcom) {
        this.updateModified();
    }

    @Override
    public void gedcomWriteLockAcquired(Gedcom gedcom) {
    }

    @Override
    public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
    }

    @Override
    public void gedcomAfterUnitOfWork(Gedcom gedcom) {
    }

    @Override
    public void gedcomWriteLockReleased(Gedcom gedcom) {
        try {
            this.getUndoRedo().gedcomUpdated(gedcom);
            this.updateModified();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void updateModified() {
        if (this.context.getGedcom().hasChanged()) {
            if (this.getLookup().lookup(SaveCookie.class) == null) {
                this.getCookieSet().add((Node.Cookie)this.saveCookie);
            }
        } else {
            Node.Cookie cookie = (Node.Cookie)this.getLookup().lookup(SaveCookie.class);
            if (cookie != null && cookie.equals(this.saveCookie)) {
                this.getCookieSet().remove((Node.Cookie)this.saveCookie);
            }
        }
    }

    private void saveDocument() {
        GedcomMgr.getDefault().saveGedcom(this.context);
        this.updateModified();
    }

    @Override
    public void setContext(Context context) {
        if (this.context != null && this.context.sameGedcom(context)) {
            this.context = context;
        }
    }

    public Context getContext() {
        return this.context;
    }
}

