/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.TagPath;
import genj.io.InputSource;
import java.util.List;
import java.util.Optional;

public class Media
extends Entity {
    private static final TagPath TITLE55 = new TagPath("OBJE:TITL");
    private static final TagPath TITLE551 = new TagPath("OBJE:FILE:TITL");
    private TagPath titlepath = TITLE55;

    public Media(String tag, String id) {
        super(tag, id);
        this.assertTag("OBJE");
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty();
    }

    @Override
    public void moveEntityValue() {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.getTitle().isEmpty()) {
                this.setTitle(value);
                this.setValue("");
            } else {
                super.moveEntityValue();
            }
        }
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        return this.getTitle();
    }

    @Override
    public String getDisplayTitle() {
        return this.getDisplayTitle(true);
    }

    @Override
    public String getDisplayTitle(boolean showIds) {
        int cut;
        int len;
        int maxLen = 30;
        String str = this.getTitle().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut);
        }
        if (str.isEmpty()) {
            str = "?";
        }
        if (showIds) {
            return this.getId() + " - " + str;
        }
        return str;
    }

    @Override
    public boolean addFile(InputSource file) {
        if (!this.getMetaProperty().allows("BLOB")) {
            return super.addFile(file);
        }
        List<PropertyBlob> blobs = this.getProperties(PropertyBlob.class);
        PropertyBlob blob = blobs.isEmpty() ? (PropertyBlob)this.addProperty("BLOB", "") : blobs.get(0);
        return blob.addFile(file);
    }

    public InputSource getFile() {
        Optional<InputSource> ois;
        Property file = this.getProperty("FILE", false);
        if (file instanceof PropertyFile && (ois = ((PropertyFile)file).getInput()).isPresent()) {
            return ois.get();
        }
        return null;
    }

    public PropertyBlob getBlob() {
        Property blob = this.getProperty("BLOB", true);
        return blob instanceof PropertyBlob ? (PropertyBlob)blob : null;
    }

    public String getTitle() {
        Property title = this.getProperty(this.titlepath);
        return title == null ? "" : title.getValue();
    }

    @Override
    void addNotify(Gedcom ged) {
        super.addNotify(ged);
        this.titlepath = this.getMetaProperty().allows("TITL") ? TITLE55 : TITLE551;
    }

    public void setTitle(String title) {
        this.setValue(this.titlepath, title);
    }
}

