/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import swingx.docking.DockingPane;

public class Bridge
extends JPanel {
    private DockingPane dockingPane;
    private Object key;
    private JComponent bridged;

    public Bridge() {
        this.setLayout(new BridgeLayout());
    }

    public DockingPane getDockingPane() {
        return this.dockingPane;
    }

    public void setDockingPane(DockingPane dockingPane) {
        this.dockingPane = dockingPane;
    }

    public JComponent clearBridged() {
        JComponent bridged = this.bridged;
        this.setBridged(this.key, null);
        this.key = null;
        this.revalidate();
        this.repaint();
        this.fireBridgeChanged();
        return bridged;
    }

    public boolean hasBridged() {
        return this.key != null;
    }

    public JComponent setBridged(Object key, JComponent component) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.key = key;
        JComponent old = this.bridged;
        if (this.bridged != null) {
            this.remove(this.bridged);
        }
        this.bridged = component;
        if (this.bridged != null) {
            this.add(this.bridged);
        }
        this.revalidate();
        this.repaint();
        this.fireBridgeChanged();
        return old;
    }

    public Object getKey() {
        return this.key;
    }

    public JComponent getBridged() {
        return this.bridged;
    }

    protected void fireBridgeChanged() {
        DockingPane dockingPane = this.getDockingPane();
        if (dockingPane != null) {
            dockingPane.bridgeChanged(this);
        }
    }

    private class BridgeLayout
    extends MouseInputAdapter
    implements LayoutManager {
        private BridgeLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets insets = Bridge.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = parent.getWidth() - insets.left - insets.right;
            int height = parent.getHeight() - insets.top - insets.bottom;
            if (Bridge.this.bridged != null) {
                Bridge.this.bridged.setBounds(x, y, width, height);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension size = new Dimension();
            Insets insets = Bridge.this.getInsets();
            size.width = insets.left + insets.right;
            size.height = insets.top + insets.bottom;
            if (Bridge.this.bridged != null) {
                Dimension componentSize = Bridge.this.bridged.getMinimumSize();
                size.width += componentSize.width;
                size.height += componentSize.height;
            }
            return size;
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }
    }
}

