/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import swingx.dnd.ObjectTransferable;
import swingx.docking.Bridge;
import swingx.docking.Dock;
import swingx.docking.Dockable;
import swingx.docking.Docking;
import swingx.docking.Slice;
import swingx.docking.dock.TabbedDock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockingPane
extends JPanel {
    private static ResourceBundle resources = ResourceBundle.getBundle("swingx.docking.resources");
    private DragSource dragSource = new DragSource();
    private DragDropHandler dragDropHandler = new DragDropHandler();
    private DialogHandler dialogHandler = new DialogHandler();
    private PopupHandler popupHandler = new PopupHandler();
    private List<Object> keys = new ArrayList<Object>();
    private List<Docking> dockings = new ArrayList<Docking>();
    private Map<Docking, JDialog> dockingToDialog = new HashMap<Docking, JDialog>();
    private Map<JDialog, Docking> dialogToDocking = new HashMap<JDialog, Docking>();

    public DockingPane() {
        this.setLayout(new BorderLayout());
        Docking docking = this.createDocking();
        docking.setRoot(this.createDock());
        this.dockings.add(docking);
        this.add(docking);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        for (Docking docking : this.dockings) {
            this.updateVisibility(docking);
        }
    }

    @Override
    public void removeNotify() {
        for (Docking docking : this.dockings) {
            this.updateVisibility(docking);
        }
        super.removeNotify();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.dockings == null) {
            return;
        }
        int d = 1;
        while (d < this.dockings.size()) {
            Docking docking = this.dockings.get(d);
            JDialog dialog = this.dockingToDialog.get(docking);
            if (dialog == null) {
                SwingUtilities.updateComponentTreeUI(docking);
            } else {
                SwingUtilities.updateComponentTreeUI(dialog);
            }
            ++d;
        }
        SwingUtilities.updateComponentTreeUI(this.popupHandler.popupMenu);
    }

    protected List<Docking> getDockings() {
        return Collections.unmodifiableList(this.dockings);
    }

    protected void setDockings(List<Docking> dockings) {
        if (dockings == null || dockings.size() == 0) {
            throw new IllegalArgumentException("dockings must not be empty");
        }
        for (Object key : this.getDockableKeys()) {
            this.removeDockable(key);
        }
        this.remove(this.dockings.get(0));
        this.dockings = new ArrayList<Docking>(dockings);
        this.add(dockings.get(0));
        for (Docking docking : dockings) {
            this.updateVisibility(docking);
        }
        this.keys.clear();
        this.repaint();
        this.revalidate();
    }

    public boolean containsDockable(Object key) {
        for (Docking docking : this.dockings) {
            if (docking.getDock(key) == null) continue;
            return true;
        }
        return false;
    }

    public List<Object> getDockableKeys() {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Docking docking : this.dockings) {
            keys.addAll(docking.getDockableKeys());
        }
        return keys;
    }

    public Dockable getDockable(Object key) {
        for (Docking docking : this.dockings) {
            Dock dock = docking.getDock(key);
            if (dock == null) continue;
            return dock.getDockable(key);
        }
        return null;
    }

    public Dockable putDockable(Object key, Dockable dockable) {
        Docking docking2;
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Dock dock = null;
        for (Docking docking2 : this.dockings) {
            dock = docking2.getDock(key);
            if (dock != null) break;
        }
        if (dock == null && (dock = (docking2 = this.dockings.get(0)).getDock(null)) == null) {
            dock = this.createDock();
            docking2.slice(docking2.getRoot(), dock);
        }
        Dockable old = dock.putDockable(key, dockable);
        if (dockable != null) {
            dock.setSelectedDockable(dockable);
        }
        if (old != null && old != dockable) {
            this.dismissDockable(old);
        }
        return old;
    }

    protected Dockable createDockable(Object key) {
        return null;
    }

    protected void dismissDockable(Dockable dockable) {
    }

    protected JComponent createComponent(Object key) {
        return null;
    }

    protected void dismissComponent(JComponent component) {
    }

    public Dockable removeDockable(Object key) {
        Dockable dockable = null;
        Dock dock = null;
        for (Docking docking : this.dockings) {
            dock = docking.getDock(key);
            if (dock != null) break;
        }
        if (dock != null) {
            dockable = dock.removeDockable(key);
        }
        this.keys.remove(key);
        if (dockable != null) {
            this.dismissDockable(dockable);
        }
        return dockable;
    }

    public JComponent getComponent(Object key) {
        for (Docking docking : this.dockings) {
            Bridge bridge = docking.getBridge(key);
            if (bridge == null) continue;
            return bridge.getBridged();
        }
        return null;
    }

    public JComponent putComponent(Object key, JComponent component) {
        JComponent old;
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Bridge bridge = null;
        for (Docking docking : this.dockings) {
            bridge = docking.getBridge(key);
            if (bridge != null) break;
        }
        if (bridge == null) {
            Docking docking;
            docking = this.dockings.get(0);
            bridge = this.createBridge();
            docking.slice(docking.getRoot(), bridge);
        }
        if ((old = bridge.setBridged(key, component)) != null) {
            this.dismissComponent(old);
        }
        return old;
    }

    public JComponent removeComponent(Object key) {
        JComponent component = null;
        Bridge bridge = null;
        for (Docking docking : this.dockings) {
            bridge = docking.getBridge(key);
            if (bridge != null) break;
        }
        if (bridge != null) {
            component = bridge.clearBridged();
        }
        if (component != null) {
            this.dismissComponent(component);
        }
        return component;
    }

    private Dock getDock(Component component) {
        while (!(component instanceof Dock)) {
            component = component.getParent();
        }
        return (Dock)component;
    }

    private Docking getDocking(Component component) {
        while (component != null && !(component instanceof Docking)) {
            component = component.getParent();
        }
        return (Docking)component;
    }

    protected JDialog createDialog() {
        return new JDialog((JFrame)SwingUtilities.windowForComponent(this));
    }

    protected void dismissDialog(JDialog dialog) {
        dialog.dispose();
    }

    public final Docking createDocking() {
        Docking docking = this.createDockingImpl();
        docking.setDockingPane(this);
        new DropTarget(docking.getDropReceiver(), this.dragDropHandler);
        return docking;
    }

    public final Slice createSlice() {
        Slice slice = this.createSliceImpl();
        return slice;
    }

    public final Dock createDock() {
        Dock dock = this.createDockImpl();
        JComponent initiator = dock.getDragInitiator();
        initiator.addMouseListener(this.popupHandler);
        this.dragSource.createDefaultDragGestureRecognizer(initiator, 2, this.dragDropHandler);
        return dock;
    }

    public final Bridge createBridge() {
        Bridge bridge = new Bridge();
        bridge.setDockingPane(this);
        return bridge;
    }

    protected Docking createDockingImpl() {
        return new Docking();
    }

    protected Slice createSliceImpl() {
        return new Slice();
    }

    protected Dock createDockImpl() {
        return new TabbedDock(this);
    }

    protected Bridge createBridgeImpl() {
        return new Bridge();
    }

    protected void bridgeChanged(Bridge bridge) {
        Docking docking = this.getDocking(bridge);
        if (this.dockings.contains(docking)) {
            if (!bridge.hasBridged()) {
                docking.unslice(bridge);
            }
            this.updateVisibility(docking);
        }
    }

    protected void dockChanged(Dock dock) {
        Docking docking = this.getDocking(dock);
        if (this.dockings.contains(docking)) {
            if (!dock.hasDockable()) {
                docking.unslice(dock);
            }
            this.updateVisibility(docking);
        }
    }

    protected void updateVisibility(Docking docking) {
        boolean hasVisible = docking.updateVisibility();
        if (docking != this.dockings.get(0)) {
            if (hasVisible) {
                JDialog dialog;
                if (this.isDisplayable() && (dialog = this.dockingToDialog.get(docking)) == null) {
                    dialog = this.createDialog();
                    this.dockingToDialog.put(docking, dialog);
                    this.dialogToDocking.put(dialog, docking);
                    dialog.setDefaultCloseOperation(0);
                    dialog.getContentPane().add(docking);
                    dialog.pack();
                    Point offset = SwingUtilities.convertPoint(docking.getRoot(), 0, 0, dialog);
                    Rectangle screenBounds = docking.getScreenBounds();
                    dialog.setLocation(screenBounds.x - offset.x, screenBounds.y - offset.y);
                    dialog.addWindowListener(this.dialogHandler);
                    dialog.addComponentListener(this.dialogHandler);
                    dialog.setVisible(true);
                }
            } else {
                JDialog dialog = this.dockingToDialog.get(docking);
                if (dialog != null) {
                    dialog.setVisible(false);
                    dialog.removeComponentListener(this.dialogHandler);
                    dialog.removeWindowListener(this.dialogHandler);
                    dialog.getContentPane().remove(docking);
                    this.dockingToDialog.remove(docking);
                    this.dialogToDocking.remove(dialog);
                    this.dismissDialog(dialog);
                }
                if (!docking.hasDockable()) {
                    this.dockings.remove(docking);
                }
            }
        }
    }

    static /* synthetic */ ResourceBundle access$0() {
        return resources;
    }

    protected class DialogHandler
    implements WindowListener,
    ComponentListener {
        protected DialogHandler() {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            Docking docking = (Docking)DockingPane.this.dialogToDocking.get(e.getWindow());
            List<Object> keys = docking.getDockableKeys();
            int k = 0;
            while (k < keys.size()) {
                Object key = keys.get(k);
                Dock dock = docking.getDock(key);
                dock.closeDockable(dock.getDockable(key));
                ++k;
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
            this.updateScreenBounds(e);
        }

        public void componentResized(ComponentEvent e) {
            this.updateScreenBounds(e);
        }

        private void updateScreenBounds(ComponentEvent e) {
            Docking docking = (Docking)DockingPane.this.dialogToDocking.get(e.getSource());
            if (docking.isShowing()) {
                Point location = docking.getLocationOnScreen();
                Rectangle screenBounds = new Rectangle();
                screenBounds.x = location.x;
                screenBounds.y = location.y;
                screenBounds.width = docking.getWidth();
                screenBounds.height = docking.getHeight();
                docking.setScreenBounds(screenBounds);
            }
        }
    }

    protected class DragDropHandler
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private ObjectTransferable transferable;
        private Docking docking;
        private Dock drag;
        private JComponent drop;
        private int orientation = -1;
        private float weight;

        protected DragDropHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            this.drag = DockingPane.this.getDock(dge.getComponent());
            this.drop = null;
            this.orientation = -1;
            Point point = SwingUtilities.convertPoint(dge.getComponent(), dge.getDragOrigin(), this.drag);
            DockingPane.this.keys.clear();
            Object key = this.drag.getDockableKey(point);
            if (key == null) {
                DockingPane.this.keys.addAll(this.drag.getVisibleDockableKeys());
            } else {
                DockingPane.this.keys.add(key);
                this.drag.setSelectedDockable(this.drag.getDockable(key));
            }
            for (Docking docking : DockingPane.this.dockings) {
                docking.startDrop();
            }
            this.transferable = new ObjectTransferable(DockingPane.this.keys);
            dge.startDrag(null, null, new Point(), this.transferable, this);
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            this.transferable.clear();
            this.transferable = null;
            this.drag = null;
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dse) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            this.docking = DockingPane.this.getDocking(dtde.getDropTargetContext().getComponent());
        }

        public void dragOver(DropTargetDragEvent dtde) {
            Point location = dtde.getLocation();
            int x = location.x;
            int y = location.y;
            this.drop = this.getDrop(x, y, this.docking.getRoot());
            this.weight = this.getWeight();
            this.orientation = this.getOrientation(x, y);
            Rectangle rect = SwingUtilities.convertRectangle(this.drop.getParent(), this.drop.getBounds(), this.docking.dropLayer);
            this.docking.dropLayer.setMark(rect, this.orientation, this.weight);
        }

        public void dragExit(DropTargetEvent dte) {
            this.docking.dropLayer.clearMark();
            this.docking = null;
            this.drop = null;
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent arg0) {
            if (this.drop != null) {
                if (this.orientation != 0) {
                    Dock newDock = DockingPane.this.createDock();
                    Slice slice = this.docking.slice(this.drop, newDock);
                    slice.setOrientation(this.orientation);
                    slice.setWeight(this.weight);
                    this.drop = newDock;
                }
                if (this.drag != this.drop || this.drag.getVisibleDockableCount() > DockingPane.this.keys.size()) {
                    Dockable selectedDockable = this.drag.getSelectedDockable();
                    int k = DockingPane.this.keys.size() - 1;
                    while (k >= 0) {
                        Object key = DockingPane.this.keys.get(k);
                        Dockable dockable = this.drag.removeDockable(key);
                        ((Dock)this.drop).putDockable(key, dockable);
                        --k;
                    }
                    if (selectedDockable != null) {
                        ((Dock)this.drop).setSelectedDockable(selectedDockable);
                    }
                }
            }
            this.drop = null;
            this.orientation = -1;
            for (Docking docking : DockingPane.this.dockings) {
                docking.endDrop();
            }
        }

        private int getOrientation(int x, int y) {
            int orientation = 0;
            Point point = SwingUtilities.convertPoint(this.docking, x, y, this.drop);
            int width = this.drop.getWidth();
            int height = this.drop.getHeight();
            if (this.drag == this.drop && this.drag.getVisibleDockableCount() == DockingPane.this.keys.size()) {
                return orientation;
            }
            if (this.drop instanceof Dock && point.x > width / 4 && point.x < width * 3 / 4 && point.y > height / 4 && point.y < height * 3 / 4) {
                return orientation;
            }
            float xd = (float)(point.x - width / 2) / (float)(width / 2);
            float yd = (float)(point.y - height / 2) / (float)(height / 2);
            orientation = xd > 0.0f ? (yd > 0.0f ? (xd - yd > 0.0f ? 4 : 3) : (xd + yd > 0.0f ? 4 : 1)) : (yd > 0.0f ? (yd + xd > 0.0f ? 3 : 2) : (yd - xd > 0.0f ? 2 : 1));
            return orientation;
        }

        private float getWeight() {
            return this.drop instanceof Dock ? 0.5f : 0.25f;
        }

        private JComponent getDrop(int x, int y, JComponent component) {
            x -= component.getX();
            y -= component.getY();
            if (component instanceof Slice) {
                Slice slice = (Slice)component;
                JComponent main = slice.getMain();
                JComponent remainder = slice.getRemainder();
                if (main.isVisible() && main.getX() < x && main.getX() + main.getWidth() > x && main.getY() < y && main.getY() + main.getHeight() > y) {
                    return this.getDrop(x, y, main);
                }
                if (remainder.isVisible() && remainder.getX() < x && remainder.getX() + remainder.getWidth() > x && remainder.getY() < y && remainder.getY() + remainder.getHeight() > y) {
                    return this.getDrop(x, y, remainder);
                }
            }
            return component;
        }
    }

    protected class PopupHandler
    extends MouseAdapter
    implements ActionListener {
        private boolean popup;
        private Dock dock;
        private JPopupMenu popupMenu = new JPopupMenu();
        private JMenuItem closeAllMenuItem = new JMenuItem(DockingPane.access$0().getString("closeAll"));
        private JMenuItem closeOthersMenuItem = new JMenuItem(DockingPane.access$0().getString("closeOthers"));
        private JMenuItem closeMenuItem = new JMenuItem(DockingPane.access$0().getString("close"));
        private JMenuItem undockMenuItem = new JMenuItem(DockingPane.access$0().getString("undock"));

        public PopupHandler() {
            this.closeMenuItem.addActionListener(this);
            this.popupMenu.add(this.closeMenuItem);
            this.closeOthersMenuItem.addActionListener(this);
            this.popupMenu.add(this.closeOthersMenuItem);
            this.closeAllMenuItem.addActionListener(this);
            this.popupMenu.add(this.closeAllMenuItem);
            this.popupMenu.addSeparator();
            this.undockMenuItem.addActionListener(this);
            this.popupMenu.add(this.undockMenuItem);
        }

        public void mousePressed(MouseEvent e) {
            this.popup = false;
            this.dock = DockingPane.this.getDock(e.getComponent());
            Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.dock);
            DockingPane.this.keys.clear();
            Object key = this.dock.getDockableKey(point);
            if (key == null) {
                DockingPane.this.keys.addAll(this.dock.getVisibleDockableKeys());
            } else {
                DockingPane.this.keys.add(key);
            }
            this.checkPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.popup) {
                this.checkPopup(e);
            }
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup = true;
                this.closeMenuItem.setEnabled(DockingPane.this.keys.size() == 1);
                this.closeOthersMenuItem.setEnabled(DockingPane.this.keys.size() < this.dock.getVisibleDockableCount());
                this.closeAllMenuItem.setEnabled(DockingPane.this.keys.size() > 1);
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.closeMenuItem == e.getSource()) {
                int k = DockingPane.this.keys.size() - 1;
                while (k >= 0) {
                    this.dock.closeDockable(this.dock.getDockable(DockingPane.this.keys.get(k)));
                    --k;
                }
            } else if (this.closeOthersMenuItem == e.getSource()) {
                List<Object> visibles = this.dock.getVisibleDockableKeys();
                int k = visibles.size() - 1;
                while (k >= 0) {
                    if (!DockingPane.this.keys.contains(visibles.get(k))) {
                        this.dock.closeDockable(this.dock.getDockable(visibles.get(k)));
                    }
                    --k;
                }
            } else if (this.closeAllMenuItem == e.getSource()) {
                List<Object> visibles = this.dock.getVisibleDockableKeys();
                int k = visibles.size() - 1;
                while (k >= 0) {
                    this.dock.closeDockable(this.dock.getDockable(visibles.get(k)));
                    --k;
                }
            } else if (this.undockMenuItem == e.getSource()) {
                Rectangle bounds = new Rectangle();
                bounds.x = this.dock.getLocationOnScreen().x;
                bounds.y = this.dock.getLocationOnScreen().y;
                bounds.width = this.dock.getWidth();
                bounds.height = this.dock.getHeight();
                Dock undocked = DockingPane.this.createDock();
                int k = DockingPane.this.keys.size() - 1;
                while (k >= 0) {
                    Object key = DockingPane.this.keys.get(k);
                    undocked.putDockable(key, this.dock.removeDockable(key));
                    --k;
                }
                Docking docking = DockingPane.this.createDocking();
                docking.setRoot(undocked);
                docking.setScreenBounds(bounds);
                DockingPane.this.dockings.add(docking);
                DockingPane.this.updateVisibility(docking);
            }
        }
    }
}

