/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.arrange;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.arrange.AbstractArranger;
import ancestris.report.svgtree.arrange.AlignLeftArranger;
import ancestris.report.svgtree.arrange.AlignRightArranger;

public class CenteredArranger
extends AlignLeftArranger {
    protected AbstractArranger leftArranger;
    protected AbstractArranger rightArranger;

    public CenteredArranger(int spacing) {
        super(spacing);
        this.leftArranger = new AlignRightArranger(spacing);
        this.rightArranger = new AlignLeftArranger(spacing);
    }

    @Override
    protected void arrangeSpouseParent(IndiBox indibox, IndiBox parent) {
        if (indibox.parent != null) {
            parent.x = this.spacing / 2;
            this.rightArranger.filter(parent);
        } else {
            parent.x = indibox.spouse.width / 2 - parent.width;
            this.filter(parent);
        }
        parent.y = -parent.hPlus;
    }

    @Override
    protected void arrangeParent(IndiBox indibox, IndiBox parent) {
        if (indibox.spouse != null && indibox.spouse.parent != null) {
            parent.x = indibox.width - parent.width - this.spacing / 2;
            this.leftArranger.filter(parent);
        } else {
            if (!parent.hasChildren()) {
                parent.x = -parent.width / 2;
            }
            this.filter(parent);
        }
        parent.y = -parent.hPlus;
    }

    @Override
    protected void arrangeChildren(IndiBox indibox) {
        int currentX = 0;
        if (indibox.getDir() == IndiBox.Direction.PARENT) {
            currentX = indibox.prev.width / 2 - indibox.x + this.spacing;
        }
        for (IndiBox child : indibox.children) {
            child.y = 1;
            this.filter(child);
            child.x = currentX + child.wMinus;
            currentX += child.wMinus + child.wPlus + this.spacing;
        }
        if (indibox.getDir() == IndiBox.Direction.PARENT) {
            return;
        }
        int min = indibox.children[0].x - indibox.children[0].wMinus;
        int diff = min + (currentX - this.spacing - min) / 2;
        diff -= (indibox.wPlus + indibox.wMinus) / 2 - indibox.wMinus;
        for (IndiBox child : indibox.children) {
            child.x -= diff;
        }
    }
}

