/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.tools.ConnectedUserFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.openide.util.NbBundle;

public class ConnectedGedcomsPopup
extends JPopupMenu
implements TableModelListener {
    private static int PADDING = 10;
    private MyTableModel model = null;
    private JTable table = null;
    private JScrollPane jscrollpane = null;

    public ConnectedGedcomsPopup(List<ConnectedUserFrame> list) {
        this.initComponents();
        this.table = new JTable();
        this.setLayout(new BorderLayout());
        this.model = new MyTableModel();
        this.table.setModel(this.model);
        this.table.getModel().addTableModelListener(this);
        this.table.setAutoCreateRowSorter(true);
        this.table.getTableHeader().setToolTipText(NbBundle.getMessage(ConnectedGedcomsPopup.class, (String)"TIP_SortHeader"));
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        HeaderCellRenderer renderer = new HeaderCellRenderer();
        for (int col = 0; col < this.model.getColumnCount(); ++col) {
            this.table.getColumnModel().getColumn(col).setHeaderRenderer(renderer);
        }
        this.table.setDefaultRenderer(Object.class, new UserCellRenderer());
        this.table.getColumnModel().removeColumn(this.table.getColumnModel().getColumn(7));
        this.table.getColumnModel().removeColumn(this.table.getColumnModel().getColumn(0));
        this.jscrollpane = new JScrollPane(this.table);
        this.jscrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(this.jscrollpane);
        this.updateTable(list);
    }

    public void updateTable(List<ConnectedUserFrame> users) {
        if (this.model == null) {
            return;
        }
        this.model.refreshData(users);
        this.table.setRowSorter(new TableRowSorter<MyTableModel>(this.model));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(35);
        for (int col = 1; col < this.table.getColumnCount(); ++col) {
            this.table.getColumnModel().getColumn(col).setPreferredWidth(this.getMaxWidth(col));
        }
        Dimension preferredSize = this.table.getPreferredSize();
        preferredSize.height = this.table.getRowHeight() * Math.min(30, this.model.getRowCount() + 1) + 7;
        if (this.model.getRowCount() == 0) {
            preferredSize.height = 20;
        }
        this.table.setPreferredScrollableViewportSize(preferredSize);
        this.jscrollpane.repaint();
    }

    private int getMaxWidth(int col) {
        FontMetrics fm = this.getFontMetrics(this.getFont().deriveFont(1));
        int width = 80;
        int w = 0;
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            Object value = this.table.getValueAt(row, col);
            Object text = "";
            text = value instanceof String ? (String)value : (value instanceof Integer ? ((Integer)value).toString() : "WWWW");
            w = fm.stringWidth((String)text) + 2 * PADDING + 5;
            width = Math.max(width, w);
        }
        return width;
    }

    private void initComponents() {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.model == null || this.model.getRowCount() == 0) {
            return;
        }
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (column == 1) {
            ConnectedUserFrame user;
            user.showUser(!(user = (ConnectedUserFrame)this.model.getValueAt(row, 7)).isIncluded());
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"", "", "", "", "", "", "", ""};
        private Object[][] data = new Object[1][this.columnNames.length];

        MyTableModel() {
        }

        public void refreshData(List<ConnectedUserFrame> users) {
            this.data = new Object[users.size()][this.columnNames.length];
            int i = 0;
            for (ConnectedUserFrame user : users) {
                this.data[i][0] = user.isActive();
                this.data[i][1] = user.isIncluded();
                this.data[i][2] = user.getName();
                this.data[i][3] = user.getNbIndis();
                this.data[i][4] = user.getNbFams();
                this.data[i][5] = user.getNbSTs();
                this.data[i][6] = user.getTopST();
                this.data[i][7] = user;
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.data.length == 0) {
                switch (col) {
                    case 0: 
                    case 1: {
                        return false;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return 0;
                    }
                    case 2: 
                    case 6: {
                        return "";
                    }
                }
            }
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            if (c >= 3 && c <= 5) {
                return Integer.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    private class HeaderCellRenderer
    implements TableCellRenderer {
        private final URL[] url = new URL[]{this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/included.png"), this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/friend16.png"), this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/indi.png"), this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/fam.png"), this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/geost.png"), this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/star.png")};

        private HeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer r = table.getTableHeader().getDefaultRenderer();
            String html = String.format("<html><img src='%s'/></html>", this.url[column]);
            ((JLabel)((Object)r)).setHorizontalAlignment(0);
            return r.getTableCellRendererComponent(table, html, isSelected, hasFocus, row, column);
        }
    }

    private class UserCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private UserCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Font f = this.getFont();
            boolean isActive = (Boolean)table.getModel().getValueAt(row, 0);
            if (isActive) {
                this.setFont(f.deriveFont(0));
            } else {
                this.setFont(f.deriveFont(2));
            }
            switch (column) {
                case 0: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.setHorizontalAlignment(4);
                    this.setText("" + (Integer)value);
                    break;
                }
                case 1: 
                case 5: {
                    this.setHorizontalAlignment(2);
                    this.setText((String)value);
                }
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, PADDING, 0, PADDING));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                if (isActive) {
                    this.setForeground(table.getSelectionForeground());
                } else {
                    this.setForeground(table.getSelectionForeground().brighter().brighter());
                }
            } else {
                this.setBackground(table.getBackground());
                if (isActive) {
                    this.setForeground(table.getForeground());
                } else {
                    this.setForeground(table.getForeground().brighter().brighter());
                }
            }
            this.setOpaque(true);
            return this;
        }
    }
}

