/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.graphstream.algorithm.Prim;
import org.graphstream.algorithm.SpanningTree;
import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.algorithm.util.FibonacciHeap;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.PipeBase;
import org.graphstream.stream.Sink;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.view.Viewer;

public class HierarchicalLayout
extends PipeBase
implements Layout {
    final HashMap<String, Position> nodesPosition;
    final LinkedList<String> roots = new LinkedList();
    final Graph internalGraph;
    boolean structureChanged;
    Rendering renderingType;
    Point3 hi;
    Point3 lo;
    long lastStep;
    int nodeMoved;
    double distanceBetweenLevels = 1.0;
    double levelWidth = 1.0;
    double levelHeight = 1.0;

    public HierarchicalLayout() {
        this.nodesPosition = new HashMap();
        this.internalGraph = new AdjacencyListGraph("hierarchical_layout-intern");
        this.hi = new Point3();
        this.lo = new Point3();
        this.renderingType = Rendering.VERTICAL;
    }

    public void setRoots(String ... rootsId) {
        this.roots.clear();
        if (rootsId != null) {
            for (String id : rootsId) {
                this.roots.add(id);
            }
        }
    }

    public void clear() {
    }

    public void compute() {
        this.nodeMoved = 0;
        if (this.structureChanged) {
            this.structureChanged = false;
            this.computePositions();
        }
        this.publishPositions();
        this.lastStep = System.currentTimeMillis();
    }

    protected void computePositions() {
        int i;
        Box box;
        int[] levels = new int[this.internalGraph.getNodeCount()];
        Arrays.fill(levels, -1);
        int[] columns = new int[this.internalGraph.getNodeCount()];
        LinkedList<Object> roots = new LinkedList<Object>();
        LinkedList roots2 = new LinkedList();
        if (this.roots.size() > 0) {
            for (int i2 = 0; i2 < this.roots.size(); ++i2) {
                roots.add(this.internalGraph.getNode(this.roots.get(i2)));
            }
        }
        Prim tree = new Prim("weight", "inTree");
        tree.init(this.internalGraph);
        tree.compute();
        if (roots.size() == 0) {
            int max = this.internalGraph.getNode(0).getDegree();
            int maxIndex = 0;
            for (int i3 = 1; i3 < this.internalGraph.getNodeCount(); ++i3) {
                if (this.internalGraph.getNode(i3).getDegree() <= max) continue;
                max = this.internalGraph.getNode(i3).getDegree();
                maxIndex = i3;
            }
            roots.add(this.internalGraph.getNode(maxIndex));
        }
        Box rootBox = new Box();
        LevelBox rootLevelBox = new LevelBox(0);
        LinkedList<LevelBox> levelBoxes = new LinkedList<LevelBox>();
        rootLevelBox.add(rootBox);
        levelBoxes.add(rootLevelBox);
        int i4 = 0;
        while (i4 < roots.size()) {
            Node n = (Node)roots.get(i4);
            levels[n.getIndex()] = 0;
            columns[n.getIndex()] = i4++;
            this.setBox(rootBox, n);
        }
        while (true) {
            if (roots.size() > 0) {
                Node root = (Node)roots.poll();
                int level = levels[root.getIndex()] + 1;
                box = HierarchicalLayout.getChildrenBox(root);
                root.edges().filter(e -> e.getAttribute(tree.getFlagAttribute()).equals(tree.getFlagOn())).forEach(e -> {
                    Node op = e.getOpposite(root);
                    if (levels[op.getIndex()] < 0 || level < levels[op.getIndex()]) {
                        levels[op.getIndex()] = level;
                        roots2.add(op);
                        op.setAttribute("parent", new Object[]{root});
                        this.setBox(box, op);
                    }
                });
                continue;
            }
            roots.addAll(roots2);
            roots2.clear();
            if (roots.size() <= 0) break;
        }
        FibonacciHeap<Integer, Box> boxes = new FibonacciHeap<Integer, Box>();
        boxes.add(0, rootBox);
        for (i = 0; i < this.internalGraph.getNodeCount(); ++i) {
            box = HierarchicalLayout.getChildrenBox(this.internalGraph.getNode(i));
            if (box == null) continue;
            boxes.add(box.level, box);
            while (levelBoxes.size() <= box.level) {
                levelBoxes.add(new LevelBox(levelBoxes.size()));
            }
            ((LevelBox)levelBoxes.get(box.level)).add(box);
        }
        for (i = 0; i < levelBoxes.size(); ++i) {
            ((LevelBox)levelBoxes.get(i)).sort();
        }
        while (boxes.size() > 0) {
            this.renderBox((Box)boxes.extractMin());
        }
        this.hi.y = Double.MIN_VALUE;
        this.hi.x = Double.MIN_VALUE;
        this.lo.y = Double.MAX_VALUE;
        this.lo.x = Double.MAX_VALUE;
        for (int idx = 0; idx < this.internalGraph.getNodeCount(); ++idx) {
            Node n = this.internalGraph.getNode(idx);
            double y = n.getNumber("y");
            double x = n.getNumber("x");
            if (!n.hasNumber("oldX") || n.getNumber("oldX") != x || !n.hasNumber("oldY") || n.getNumber("oldY") != y) {
                n.setAttribute("oldX", new Object[]{x});
                n.setAttribute("oldY", new Object[]{y});
                n.setAttribute("changed", new Object[0]);
                ++this.nodeMoved;
            }
            this.hi.x = Math.max(this.hi.x, x);
            this.hi.y = Math.max(this.hi.y, y);
            this.lo.x = Math.min(this.lo.x, x);
            this.lo.y = Math.min(this.lo.y, y);
        }
    }

    protected void setBox(Box box, Node node) {
        if (node.hasAttribute("box")) {
            HierarchicalLayout.getBox(node).remove(node);
        }
        box.add(node);
        node.setAttribute("box", new Object[]{box});
        if (!node.hasAttribute("children")) {
            node.setAttribute("children", new Object[]{new Box(node, 1)});
        }
        HierarchicalLayout.getChildrenBox((Node)node).level = box.level + 1;
    }

    protected static Box getBox(Node node) {
        Box box = (Box)node.getAttribute("box");
        return box;
    }

    protected static Box getChildrenBox(Node node) {
        Box box = (Box)node.getAttribute("children");
        return box;
    }

    protected void renderBox(Box box) {
        Box parentBox;
        if (box.size() == 0) {
            return;
        }
        block12: for (int i = 0; i < box.size(); ++i) {
            Node n = (Node)box.get(i);
            switch (this.renderingType) {
                case VERTICAL: {
                    n.setAttribute("x", new Object[]{box.width * (double)i / (double)box.size()});
                    n.setAttribute("y", new Object[]{box.height / 2.0});
                    continue block12;
                }
                case DISK: 
                case HORIZONTAL: {
                    n.setAttribute("x", new Object[]{box.width / 2.0});
                    n.setAttribute("y", new Object[]{box.height * (double)i / (double)box.size()});
                }
            }
        }
        double sx = 1.0;
        double sy = 1.0;
        double dx = 0.0;
        double dy = 0.0;
        if (box.parent != null) {
            parentBox = HierarchicalLayout.getBox(box.parent);
            switch (this.renderingType) {
                case VERTICAL: {
                    sx = 1.0 / (double)parentBox.size();
                    sy = 1.0 / Math.pow(2.0, box.level);
                    break;
                }
                case DISK: 
                case HORIZONTAL: {
                    sx = 1.0 / Math.pow(2.0, box.level);
                    sy = 1.0 / (double)parentBox.size();
                }
            }
        }
        box.scale(sx, sy);
        if (box.parent != null) {
            parentBox = HierarchicalLayout.getBox(box.parent);
            dx = box.parent.getNumber("x");
            dy = box.parent.getNumber("y");
            switch (this.renderingType) {
                case VERTICAL: {
                    dx -= box.width / 2.0;
                    dy += parentBox.height / 2.0;
                    break;
                }
                case DISK: 
                case HORIZONTAL: {
                    dx += parentBox.width / 2.0;
                    dy -= box.height / 2.0;
                }
            }
        }
        box.translate(dx, dy);
    }

    protected void explore(Node parent, Node who, SpanningTree tree, int[] levels) {
    }

    protected void publishPositions() {
        this.internalGraph.nodes().filter(n -> n.hasAttribute("changed")).forEach(n -> {
            n.removeAttribute("changed");
            this.sendNodeAttributeChanged(this.sourceId, n.getId(), "xyz", null, new double[]{n.getNumber("x"), n.getNumber("y"), 0.0});
        });
    }

    public void freezeNode(String id, boolean frozen) {
    }

    public double getForce() {
        return 0.0;
    }

    public Point3 getHiPoint() {
        return this.hi;
    }

    public long getLastStepTime() {
        return this.lastStep;
    }

    public String getLayoutAlgorithmName() {
        return "Hierarchical";
    }

    public Point3 getLowPoint() {
        return this.lo;
    }

    public int getNodeMovedCount() {
        return this.nodeMoved;
    }

    public double getQuality() {
        return 0.0;
    }

    public double getStabilization() {
        return 1.0 - (double)this.nodeMoved / (double)this.internalGraph.getNodeCount();
    }

    public double getStabilizationLimit() {
        return 1.0;
    }

    public int getSteps() {
        return 0;
    }

    public void inputPos(String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void moveNode(String id, double x, double y, double z) {
    }

    public void outputPos(String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setForce(double value) {
    }

    public void setQuality(double qualityLevel) {
    }

    public void setSendNodeInfos(boolean send) {
    }

    public void setStabilizationLimit(double value) {
    }

    public void shake() {
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.internalGraph.addNode(nodeId);
        this.structureChanged = true;
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.internalGraph.removeNode(nodeId);
        this.structureChanged = true;
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromId, String toId, boolean directed) {
        this.internalGraph.addEdge(edgeId, fromId, toId, directed);
        this.structureChanged = true;
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.internalGraph.removeEdge(edgeId);
        this.structureChanged = true;
    }

    public void graphCleared(String sourceId, long timeId) {
        this.internalGraph.clear();
        this.structureChanged = true;
    }

    public static void main(String ... args) {
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        BarabasiAlbertGenerator gen = new BarabasiAlbertGenerator();
        HierarchicalLayout hl = new HierarchicalLayout();
        gen.addSink((Sink)g);
        gen.begin();
        for (int i = 0; i < 200; ++i) {
            gen.nextEvents();
        }
        gen.end();
        Viewer v = g.display(false);
        v.enableAutoLayout((Layout)hl);
    }

    public static enum Rendering {
        VERTICAL,
        HORIZONTAL,
        DISK;

    }

    static class Box
    extends LinkedList<Node> {
        private static final long serialVersionUID = -1929536876444346726L;
        Node parent;
        int level;
        double x;
        double y;
        double width;
        double height;
        int order;

        Box() {
            this(null, 0);
        }

        Box(Node parent, int level) {
            this.parent = parent;
            this.level = level;
            this.width = 5.0;
            this.height = 1.0;
            this.order = 0;
            this.x = 0.0;
            this.y = 0.0;
        }

        void scale(double sx, double sy) {
            this.width *= sx;
            this.height *= sy;
            for (int i = 0; i < this.size(); ++i) {
                ((Node)this.get(i)).setAttribute("x", new Object[]{sx * ((Node)this.get(i)).getNumber("x")});
                ((Node)this.get(i)).setAttribute("y", new Object[]{sy * ((Node)this.get(i)).getNumber("y")});
            }
        }

        void translate(double dx, double dy) {
            for (int i = 0; i < this.size(); ++i) {
                ((Node)this.get(i)).setAttribute("x", new Object[]{dx + ((Node)this.get(i)).getNumber("x")});
                ((Node)this.get(i)).setAttribute("y", new Object[]{dy + ((Node)this.get(i)).getNumber("y")});
            }
        }
    }

    static class LevelBox
    extends LinkedList<Box> {
        private static final long serialVersionUID = -5818919480025868466L;
        int level;

        LevelBox(int level) {
            this.level = level;
        }

        void sort() {
            if (this.level > 0) {
                Collections.sort(this, new Comparator<Box>(){

                    @Override
                    public int compare(Box b0, Box b1) {
                        Box pb0 = HierarchicalLayout.getBox(b0.parent);
                        Box pb1 = HierarchicalLayout.getBox(b1.parent);
                        if (pb0.order < pb1.order) {
                            return -1;
                        }
                        if (pb0.order > pb1.order) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            for (int i = 0; i < this.size(); ++i) {
                ((Box)this.get((int)i)).order = i;
            }
        }
    }

    static class Position {
        int level;
        int order;
        String parent;
        boolean changed;
        double x;
        double y;

        Position(int level, int order) {
            this.level = level;
            this.order = order;
            this.changed = true;
        }
    }
}

