/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.api.core.Version;
import ancestris.app.AppOptions;
import ancestris.app.ControlCenter;
import ancestris.app.MacOSAdapter;
import ancestris.core.pluginservice.AncestrisPlugin;
import genj.option.OptionProvider;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class App {
    static final Logger LOG = Logger.getLogger("ancestris");
    static File LOGFILE;
    private static Startup startup;
    public static ControlCenter center;
    private static final String JAVA_VERSION = "17.";
    private static MacOSAdapter macosAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object object = App.class;
        synchronized (App.class) {
            if (startup == null) {
                startup = new Startup();
                SwingUtilities.invokeLater(startup);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = startup;
            synchronized (object) {
                if (center == null) {
                    try {
                        startup.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
    }

    public static boolean closing() {
        LOG.info("Shutdown");
        App.saveModesIfRestartRequired();
        return true;
    }

    public static void close() {
        EnvironmentChecker.logOff();
        OptionProvider.persistAll();
        Registry.persist();
        App.loadModesIfRestartRequired();
        macosAdapter.uninstall();
        LOG.info("/Shutdown");
        LOG.info("==================>     A N C E S T R I S      is      closed      <======================================\n\n");
    }

    public static void setLogLevel(String logLevel) {
        Logger root = Logger.getLogger("");
        Level level = Level.INFO;
        try {
            level = Level.parse(logLevel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LOG.setLevel(level);
        Logger.getLogger("ancestris").setLevel(level);
        if (level.intValue() < Level.CONFIG.intValue()) {
            root.setLevel(Level.CONFIG);
        } else {
            root.setLevel(level);
        }
    }

    public static void setFontSize() throws UnsupportedLookAndFeelException {
        final int fontsize = Integer.parseInt(AppOptions.getFontSize());
        UIDefaults uiDefaults = UIManager.getDefaults();
        LookAndFeel laf = UIManager.getLookAndFeel();
        boolean isNimbus = laf.getName().contains("Nimbus");
        LOG.log(Level.INFO, "LookAndFeel is {0}", laf.getName());
        if (isNimbus) {
            UIManager.setLookAndFeel(new NimbusLookAndFeel(){

                @Override
                public UIDefaults getDefaults() {
                    UIDefaults ret = super.getDefaults();
                    Font dFont = ret.getFont("defaultFont");
                    Font newFont = new Font("SansSerif", dFont.getStyle(), fontsize);
                    ret.put("defaultFont", newFont);
                    LOG.log(Level.INFO, "LookAndFeel : set default font to {0}", newFont);
                    return ret;
                }
            });
        } else {
            Enumeration enume = uiDefaults.keys();
            int i = 0;
            while (enume.hasMoreElements()) {
                Object key = enume.nextElement();
                Object o = uiDefaults.get(key);
                if (!(o instanceof Font)) continue;
                Font dFont = (Font)o;
                ++i;
                Font newFont = new Font(dFont.getFontName(), dFont.getStyle(), fontsize);
                uiDefaults.put(key.toString(), newFont);
            }
            LOG.log(Level.INFO, "LookAndFeel (not nimbus) : set {0} default properties to fontsize {1}", new Object[]{i, fontsize});
        }
    }

    private static void saveModesIfRestartRequired() {
        if (!App.isRestartSet()) {
            return;
        }
        String baseDir = System.getProperty("netbeans.user") + File.separator + "config" + File.separator + "Windows2Local";
        File dirToSaveFile = new File(baseDir);
        File dirTempFile = new File(baseDir + "Tmp");
        try {
            FileObject dirToSave = FileUtil.createFolder((File)dirToSaveFile);
            FileObject dirTemp = FileUtil.createFolder((File)dirTempFile);
            App.copyFolder(dirToSave, dirTemp);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void loadModesIfRestartRequired() {
        if (!App.isRestartSet()) {
            return;
        }
        String baseDir = System.getProperty("netbeans.user") + File.separator + "config" + File.separator + "Windows2Local";
        File dirTempFile = new File(baseDir + "Tmp");
        File dirToLoadFile = new File(baseDir);
        try {
            FileObject dirTemp = FileUtil.createFolder((File)dirTempFile);
            FileObject dirToLoad = FileUtil.createFolder((File)dirToLoadFile);
            dirToLoad.delete();
            dirToLoad = FileUtil.createFolder((File)dirToLoadFile);
            App.copyFolder(dirTemp, dirToLoad);
            dirTemp.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static boolean isRestartSet() {
        String userDir = new File(System.getProperty("user.home.ancestris")).getParent();
        String restartFlagFileStr = userDir + File.separator + "var" + File.separator + "restart";
        File restartFlagFile = new File(restartFlagFileStr);
        return restartFlagFile.exists();
    }

    private static void copyFolder(FileObject dirFrom, FileObject dirTo) throws IOException {
        FileObject[] children;
        for (FileObject fileObject : children = dirFrom.getChildren()) {
            if (fileObject.isFolder()) {
                App.copyFolder(fileObject, dirTo.createFolder(fileObject.getNameExt()));
                continue;
            }
            FileUtil.copyFile((FileObject)fileObject, (FileObject)dirTo, (String)fileObject.getName());
        }
    }

    private static class Startup
    implements Runnable {
        private Startup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File home = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris", null, (String)"determining home directory"));
                home.mkdirs();
                if (!home.exists() || !home.isDirectory()) {
                    throw new IOException("Can't initialize home directoy " + home);
                }
                LogFormatter formatter = new LogFormatter();
                App.setLogLevel("INFO");
                System.setOut(new PrintStream(new LogOutputStream(Level.INFO, "System", "out")));
                System.setErr(new PrintStream(new LogOutputStream(Level.WARNING, "System", "err")));
                OptionProvider.getAllOptions();
                App.setFontSize();
                LOGFILE = new File(home, "ancestris.log");
                FileHandler handler = new FileHandler(LOGFILE.getAbsolutePath(), AppOptions.getMaxLogSizeKB() * 1024, 1, true);
                handler.setLevel(Level.ALL);
                handler.setFormatter(formatter);
                Logger.getLogger("ancestris").addHandler(handler);
                LOG.info("\n\n==================>     A N C E S T R I S      is      starting      <======================================");
                LOG.info("Startup");
                if (System.getProperty("ancestris.debug.level") != null) {
                    App.setLogLevel(System.getProperty("ancestris.debug.level"));
                } else {
                    App.setLogLevel(Registry.get(App.class).get("logLevel", ""));
                }
                EnvironmentChecker.log();
                Object version = System.getProperty("java.version");
                if (((String)version).length() < 3) {
                    version = (String)version + ".00";
                }
                if (App.JAVA_VERSION.compareTo(((String)version).substring(0, 3)) > 0) {
                    String errorMessage = NbBundle.getMessage(App.class, (String)"EM_JavaVersion");
                    JOptionPane.showMessageDialog(null, errorMessage, "Error Message", 0);
                    throw new RuntimeException("Java Version not compatible.");
                }
                macosAdapter = new MacOSAdapter();
                macosAdapter.install();
                LOG.info("Launching control center...");
                center = new ControlCenter();
                LOG.info("/Startup");
                LOG.info("   ");
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Cannot instantiate the Ancestris application", t);
                System.exit(1);
                return;
            }
            Startup startup = this;
            synchronized (startup) {
                this.notifyAll();
            }
        }
    }

    public static class AppPlugin
    extends AncestrisPlugin
    implements Version {
        public String getBuildString() {
            return this.getPluginVersion();
        }

        public String getVersionString() {
            return this.getPluginVersion();
        }

        public String getDescription() {
            return this.getPluginShortDescription();
        }
    }

    private static class LogOutputStream
    extends OutputStream {
        private final char[] buffer = new char[256];
        private int size = 0;
        private final Level level;
        private final String sourceClass;
        private final String sourceMethod;

        public LogOutputStream(Level level, String sourceClass, String sourceMethod) {
            this.level = level;
            this.sourceClass = sourceClass;
            this.sourceMethod = sourceMethod;
        }

        @Override
        public void write(int b) throws IOException {
            if (b != 10) {
                this.buffer[this.size++] = (char)b;
                if (this.size < this.buffer.length) {
                    return;
                }
            }
            this.flush();
        }

        @Override
        public void flush() throws IOException {
            if (this.size > 0) {
                LOG.logp(this.level, this.sourceClass, this.sourceMethod, String.valueOf(this.buffer, 0, this.size).trim());
                this.size = 0;
            }
        }
    }

    private static class LogFormatter
    extends Formatter {
        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder result = new StringBuilder(120);
            result.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(record.getMillis())));
            result.append(" = ");
            result.append(record.getLevel());
            result.append(":");
            result.append(record.getSourceClassName());
            result.append(".");
            result.append(record.getSourceMethodName());
            result.append(":   ");
            String msg = record.getMessage();
            Object[] parms = record.getParameters();
            if (parms == null || parms.length == 0) {
                result.append(record.getMessage());
            } else {
                result.append(MessageFormat.format(msg, parms));
            }
            result.append(System.getProperty("line.separator"));
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                try (PrintWriter pw = new PrintWriter(sw);){
                    try {
                        record.getThrown().printStackTrace(pw);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                result.append(sw.toString());
            }
            return result.toString();
        }
    }
}

