/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.actions;

import ancestris.modules.editors.aries.AriesTopComponent;
import ancestris.modules.editors.aries.editors.MultiMediaObjectEditor;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Media;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class AriesCreateMultiMediaAction
implements ActionListener {
    private final DataObject context;
    private Media mMedia;

    public AriesCreateMultiMediaAction(DataObject context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Context gedcomContext = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (gedcomContext != null) {
            Gedcom gedcom = gedcomContext.getGedcom();
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            if (atc == null) {
                AncestrisTopComponent win = new AriesTopComponent().create(gedcomContext);
                win.open();
                win.requestActive();
            }
            int undoNb = gedcom.getUndoNb();
            try {
                gedcom.doUnitOfWork(gedcom1 -> {
                    this.mMedia = (Media)gedcom1.createEntity("OBJE");
                });
                MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor(true);
                multiMediaObjectEditor.setContext(new Context((Entity)this.mMedia));
                if (!multiMediaObjectEditor.showPanel()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

