/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Grammar;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyXRef;
import genj.io.InputSource;
import genj.io.input.URLInput;
import genj.renderer.MediaRenderer;
import genj.util.swing.ImageIcon;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class MultiMediaObjectCitationsTableModel
extends AbstractTableModel {
    private final ImageIcon MINISTAR;
    List<Property> multimediaObjectsRefList = new ArrayList<Property>();
    private final String[] columnsName = new String[]{"", NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.ID.title"), NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.title.title"), NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.fileName.title"), NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.title")};

    public MultiMediaObjectCitationsTableModel() {
        this.MINISTAR = new ImageIcon(MultiMediaObjectCitationsTableModel.class, "/ancestris/modules/editors/aries/resources/starmini.png");
    }

    @Override
    public int getRowCount() {
        return this.multimediaObjectsRefList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.multimediaObjectsRefList.size()) {
            Property multimediaObject = this.multimediaObjectsRefList.get(row);
            switch (column) {
                case 0: {
                    if (multimediaObject instanceof PropertyMedia && multimediaObject.isValid()) {
                        multimediaObject = (Property)((PropertyMedia)multimediaObject).getTargetEntity().get();
                    }
                    if (multimediaObject instanceof Media && multimediaObject.getGedcom().getGrammar().equals(Grammar.V55)) {
                        PropertyBlob propertyBlob = (PropertyBlob)multimediaObject.getProperty("BLOB", true);
                        if (propertyBlob != null) {
                            Optional obi = MediaRenderer.getImage((InputSource)propertyBlob.getInput().orElse(null));
                            if (obi.isPresent()) {
                                Image image = (Image)obi.get();
                                image = image.getScaledInstance(-1, 16, 1);
                                return new javax.swing.ImageIcon(image);
                            }
                            return new javax.swing.ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/media.png"));
                        }
                        return new javax.swing.ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/media.png"));
                    }
                    if (multimediaObject instanceof Media) {
                        Property propertyfile = multimediaObject.getProperty("FILE", false);
                        if (propertyfile != null && propertyfile instanceof PropertyFile) {
                            InputSource multimediaFile = ((PropertyFile)propertyfile).getInput().orElse(null);
                            javax.swing.ImageIcon imageIcon = new javax.swing.ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/media.png"));
                            Optional obi = MediaRenderer.getImage((InputSource)multimediaFile);
                            if (obi.isPresent()) {
                                Image image = (Image)obi.get();
                                if ((image = image.getScaledInstance(-1, 16, 1)) != null) {
                                    imageIcon = new javax.swing.ImageIcon(image);
                                    if (row == 0) {
                                        return new ImageIcon((Icon)imageIcon).getOverLayed(this.MINISTAR);
                                    }
                                }
                                return imageIcon;
                            }
                            imageIcon = this.manageIcon(multimediaFile);
                            if (row == 0) {
                                return new ImageIcon((Icon)imageIcon).getOverLayed(this.MINISTAR);
                            }
                        } else {
                            return new javax.swing.ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit_delete.png"));
                        }
                    }
                }
                case 1: {
                    if (multimediaObject instanceof PropertyMedia && multimediaObject.isValid()) {
                        return ((Media)((PropertyMedia)multimediaObject).getTargetEntity().get()).getId();
                    }
                    return "";
                }
                case 2: {
                    if (multimediaObject instanceof PropertyMedia && multimediaObject.isValid()) {
                        return ((Media)((PropertyMedia)multimediaObject).getTargetEntity().get()).getTitle();
                    }
                    Property title = multimediaObject.getProperty("TITL", true);
                    if (title != null) {
                        return title.getValue();
                    }
                    return "";
                }
                case 3: {
                    if (multimediaObject instanceof PropertyMedia && multimediaObject.isValid()) {
                        Property propertyFile = ((Entity)((PropertyMedia)multimediaObject).getTargetEntity().get()).getProperty("FILE", false);
                        if (propertyFile != null && propertyFile instanceof PropertyFile) {
                            InputSource file = ((PropertyFile)propertyFile).getInput().orElse(null);
                            if (file != null) {
                                return file.getLocation();
                            }
                            return "";
                        }
                        return "";
                    }
                    Property propertyFile = multimediaObject.getProperty("FILE", false);
                    if (propertyFile != null && propertyFile instanceof PropertyFile) {
                        InputSource file = ((PropertyFile)propertyFile).getInput().orElse(null);
                        if (file != null) {
                            return file.getLocation();
                        }
                        return "";
                    }
                    return "";
                }
                case 4: {
                    if (multimediaObject instanceof PropertyMedia && multimediaObject.isValid()) {
                        Entity media = (Entity)((PropertyMedia)multimediaObject).getTargetEntity().get();
                        boolean hasNote = media.getProperty("NOTE") != null;
                        boolean bl = hasNote = hasNote || media.isGrammar7() && media.getProperty("SNOTE") != null;
                        if (hasNote) {
                            return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.yes");
                        }
                        return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.no");
                    }
                    boolean hasNote = multimediaObject.getProperty("NOTE") != null;
                    boolean bl = hasNote = hasNote || multimediaObject.isGrammar7() && multimediaObject.getProperty("SNOTE") != null;
                    if (hasNote) {
                        return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.yes");
                    }
                    return NbBundle.getMessage(MultiMediaObjectCitationsTableModel.class, (String)"MultiMediaObjectCitationsTableModel.column.note.value.no");
                }
            }
            return "";
        }
        return "";
    }

    private javax.swing.ImageIcon manageIcon(InputSource multimediaFile) {
        try {
            String extension = multimediaFile.getExtension();
            BufferedImage image = Arrays.asList(FileChooserBuilder.vidExtensions).contains(extension) ? ImageIO.read(this.getClass().getResource("/ancestris/modules/editors/aries/resources/video.png")) : (Arrays.asList(FileChooserBuilder.sndExtensions).contains(extension) ? ImageIO.read(this.getClass().getResource("/ancestris/modules/editors/aries/resources/sound.png")) : (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(extension) ? ImageIO.read(this.getClass().getResource("/ancestris/modules/editors/aries/resources/pdf.png")) : (multimediaFile instanceof URLInput ? ImageIO.read(this.getClass().getResource("/ancestris/modules/editors/aries/resources/weblink.png")) : ImageIO.read(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit_delete.png")))));
            return new javax.swing.ImageIcon(image.getScaledInstance(-1, 16, 1));
        }
        catch (IOException | NullPointerException e) {
            return new javax.swing.ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit_delete.png"));
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return javax.swing.ImageIcon.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void add(Property multimediaObject) {
        this.multimediaObjectsRefList.add(multimediaObject);
        this.fireTableDataChanged();
    }

    public void addAll(List<Property> multimediaObjectsList) {
        this.multimediaObjectsRefList.addAll(multimediaObjectsList);
        this.fireTableDataChanged();
    }

    public Property getValueAt(int row) {
        return this.multimediaObjectsRefList.get(row);
    }

    public void remove(int rowIndex) {
        this.multimediaObjectsRefList.remove(rowIndex);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.multimediaObjectsRefList.clear();
    }

    protected javax.swing.ImageIcon createImageIcon(String path, String description) {
        return new javax.swing.ImageIcon(path, description);
    }

    public int getRowOf(Property p) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Property pList = this.getValueAt(row);
            if (pList instanceof PropertyXRef) {
                PropertyXRef propertyXRef = (PropertyXRef)pList;
                pList = propertyXRef.getTargetEntity().orElse(null);
            }
            if (pList != p) continue;
            return row;
        }
        return -1;
    }
}

