/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedcomstatistics;

import ancestris.core.actions.AncestrisAPIEntry;
import ancestris.modules.document.view.WidgetDocumentView;
import ancestris.reports.FilterOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.gedcomstatistics.FamStat;
import ancestris.reports.gedcomstatistics.Frequency;
import ancestris.reports.gedcomstatistics.IndiStat;
import ancestris.reports.gedcomstatistics.LinksMap;
import ancestris.reports.utils.PropUtils;
import ancestris.util.swing.DialogManager;
import genj.common.ContextListWidget;
import genj.fo.Document;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.option.Multiline;
import genj.report.Report;
import genj.util.ReferenceSet;
import genj.view.ViewContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.openide.util.NbBundle;

public class ReportGenealogyStatistics
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    @Multiline
    public int[] sectionSelector = IntStream.range(1, SECTIONS.length).toArray();
    public String[] sectionSelectors = SECTIONS;
    public int topLimit = 20;
    public FilterOptions filterOptions = new FilterOptions();
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private static final String[] SECTIONS = new String[]{NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.individuals"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.families"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.places"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.occupations"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.sources"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.repositories"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.medias"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.snotes"), NbBundle.getMessage(ReportGenealogyStatistics.class, (String)"section.notes")};
    private static final String[] TAGS = new String[]{"INDI", "FAM", "PLAC", "OCCU", "SOUR", "REPO", "OBJE", "SNOTE", "NOTE"};
    private Document doc;
    private Gedcom gedcom;
    private boolean extract = false;
    private String run_Id = "";
    private final LinksMap linkSets = new LinksMap();
    private static final String ENTRY_ID = "GenStatsId";
    private static final int LIST_LIMIT = 300;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.getScope(entity, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        this.gedcom = indis[0].getGedcom();
        List<Indi> indisList = Arrays.asList(indis);
        return this.main(indisList);
    }

    public Document main(List<Indi> indisList) {
        this.run_Id = ENTRY_ID + String.valueOf(new Random().nextInt(1000));
        this.linkSets.clear();
        HashSet<Object> indis = new HashSet<Indi>(indisList);
        boolean bl = this.extract = this.scope.isLimited() || this.filterOptions.isFilterOn();
        if (this.extract) {
            ArrayList<Indi> filteredIndis = new ArrayList<Indi>();
            for (Indi indi : indis) {
                if (!this.filterOptions.matchRecord((Property)indi, indi.getName(), PropUtils.getStringFromIndi(indi))) continue;
                filteredIndis.add(indi);
            }
            indis = new HashSet(filteredIndis);
        }
        Set<Fam> fams = this.getFamFromIndis(this.extract, indis);
        Set<Property> places = this.getFrom(this.extract, "PLAC", indis, fams);
        Set<Property> set = this.getFrom(this.extract, "OCCU", indis);
        Set<Property> sources = this.getFrom(this.extract, "SOUR", indis, fams);
        Set<Property> repos = this.getFrom(this.extract, "REPO", sources);
        Set<Property> objes = this.getFrom(this.extract, "OBJE", indis, fams, sources);
        Set<Property> snotes = this.getFrom(this.extract, "SNOTE", indis, fams, sources, objes, repos);
        Set<Property> notes = this.getFrom(this.extract, "NOTE", indis, fams, sources, objes, repos);
        ArrayList<Set<Object>> dataSets = new ArrayList<Set<Object>>();
        dataSets.add(indis);
        dataSets.add(fams);
        dataSets.add(places);
        dataSets.add(set);
        dataSets.add(sources);
        dataSets.add(repos);
        dataSets.add(objes);
        dataSets.add(snotes);
        dataSets.add(notes);
        String number = String.valueOf(indis.size());
        String title = this.translate("title", new Object[]{this.gedcom.getDisplayName()});
        this.doc = this.formattingOptions.common.createDocument(this.translate("name"), this.colors.getTextColor(), this.colors.getBackgroundColor());
        if (this.sectionSelector.length == 0) {
            this.doc.addText(this.translate("NothingToReport"));
            return this.doc;
        }
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.common.includeTOC) {
            this.doc.addTOC(2, false, false);
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.addText(this.scope.getMainMessage(), "font-weight=bold");
        this.doc.nextParagraph();
        this.doc.addText("\u2219  " + this.translate("subtitle", new Object[]{number}));
        if (this.scope.isLimited()) {
            this.doc.nextParagraph("space-before=1cm");
            for (String[] scopeLine : this.scope.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + scopeLine[0]);
                if (scopeLine[1].isBlank()) continue;
                this.doc.addText(" : " + scopeLine[1], "font-weight=bold");
            }
        }
        if (this.filterOptions.isFilterOn()) {
            this.doc.nextParagraph("space-before=1cm");
            this.doc.addText(this.filterOptions.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        int sectionSize = this.formattingOptions.common.getTextSize() + 4;
        String sectionAttr = ",text-align=left, space-before=1cm, space-after=0.2cm";
        for (int section : this.sectionSelector) {
            this.doc.startSection(this.translate(SECTIONS[section]), "", 1, this.formattingOptions.generatePageBreak, true, "font-size=" + sectionSize + sectionAttr);
            this.displaySection(this.doc, section, (Set)dataSets.get(section));
        }
        return this.doc;
    }

    private void displaySection(Document doc, int section, Set<? extends Property> set) {
        switch (section) {
            case 0: {
                this.displayIndiStats(doc, set);
                break;
            }
            case 1: {
                this.displayFamStats(doc, set);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.displayTopOccurrences(doc, TAGS[section], set);
                break;
            }
        }
    }

    private void displayIndiStats(Document doc, Set<? extends Property> set) {
        int totalKey = 99;
        Map<Integer, Integer> col2sex = Map.of(1, 1, 2, 2, 3, 0, 4, totalKey);
        HashMap<Integer, IndiStat> sex2IndiStats = new HashMap<Integer, IndiStat>();
        for (Integer n : col2sex.values()) {
            IndiStat stats = new IndiStat();
            sex2IndiStats.put(n, stats);
        }
        for (Property property : set) {
            if (!(property instanceof Indi)) continue;
            Indi indi = (Indi)property;
            Integer sex = indi.getSex();
            if (sex != 1 && sex != 2) {
                sex = 0;
            }
            ((IndiStat)sex2IndiStats.get(sex)).increment(indi);
        }
        IndiStat statsTotals = new IndiStat();
        for (IndiStat stats : sex2IndiStats.values()) {
            stats.calculateTotals(set.size());
            statsTotals.counter += stats.counter;
            statsTotals.counterWithAge += stats.counterWithAge;
            statsTotals.sumAgeDays += stats.sumAgeDays;
            if (stats.minAgeDays < statsTotals.minAgeDays) {
                statsTotals.minAgeDays = stats.minAgeDays;
                statsTotals.minAgeDelta = stats.minAgeDelta;
            }
            if (stats.maxAgeDays > statsTotals.maxAgeDays) {
                statsTotals.maxAgeDays = stats.maxAgeDays;
                statsTotals.maxAgeDelta = stats.maxAgeDelta;
            }
            statsTotals.addSets(stats);
        }
        statsTotals.calculateTotals(set.size());
        sex2IndiStats.put(totalKey, statsTotals);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int nbCols = sex2IndiStats.size() + 6;
        int c = 0;
        String[] tmpLine = new String[nbCols];
        tmpLine[c++] = "Nb";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = String.valueOf(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).counter);
            tmpLine[c + 4] = "";
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "percentage";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = String.valueOf(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).percent) + "%";
            tmpLine[c + 4] = "";
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "withAge";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = String.valueOf(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).counterWithAge);
            tmpLine[c + 4] = "";
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "percentage";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = String.valueOf(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).percentWithAge) + "%";
            tmpLine[c + 4] = "";
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "minAge";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = ((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).minAgeDelta.toReportString();
            tmpLine[c + 4] = "";
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "minAgeNb";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = String.valueOf(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).counterMinAge);
            tmpLine[c + 4] = this.getLinkId(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).minAgeSet);
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "averageAge";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = ((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).avgAgeDelta.toReportString();
            tmpLine[c + 4] = "";
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "maxAge";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = ((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).maxAgeDelta.toReportString();
            tmpLine[c + 4] = "";
            ++c;
        }
        arrayList.add(tmpLine);
        c = 0;
        tmpLine = new String[nbCols];
        tmpLine[c++] = "maxAgeNb";
        for (Integer sex : sex2IndiStats.keySet()) {
            tmpLine[c] = String.valueOf(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).counterMaxAge);
            tmpLine[c + 4] = this.getLinkId(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).maxAgeSet);
            ++c;
        }
        arrayList.add(tmpLine);
        for (int metric = 0; metric < 3; ++metric) {
            int maxLines = 0;
            for (int l = 0; l < 100; ++l) {
                c = 0;
                tmpLine = new String[nbCols];
                tmpLine[c] = l == 0 ? IndiStat.REFSET_LABELS[metric] : String.valueOf(l);
                ++c;
                boolean allNull = true;
                for (Integer sex : sex2IndiStats.keySet()) {
                    Set tmpSet;
                    int maxKeys;
                    if (l == 0 && (maxKeys = IndiStat.getMaxKey(((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).refSets[metric])) > maxLines) {
                        maxLines = maxKeys;
                    }
                    if ((tmpSet = ((IndiStat)sex2IndiStats.get((Object)col2sex.get((Object)Integer.valueOf((int)c)))).refSets[metric].getReferences((Object)l)) == null || tmpSet.isEmpty()) {
                        tmpLine[c] = "0";
                        tmpLine[c + 4] = "";
                    } else {
                        tmpLine[c] = String.valueOf(tmpSet.size());
                        tmpLine[c + 4] = this.getLinkId(tmpSet);
                        allNull = false;
                    }
                    ++c;
                }
                if (!allNull) {
                    arrayList.add(tmpLine);
                }
                if (l < maxLines) continue;
                l = 100;
            }
        }
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String[] styles = new String[]{"font-weight=bold", "", "", "", "font-weight=bold"};
        HashSet<String> topBorders = new HashSet<String>(Arrays.asList("withAge"));
        topBorders.addAll(Arrays.asList(IndiStat.REFSET_LABELS));
        String rowHeight = "height=" + (double)this.formattingOptions.common.getTextSize() * 2.5 + "px, display-align=center";
        doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=0cm, border-color=" + textColor);
        doc.addTableColumn("column-width=16%");
        doc.addTableColumn("column-width=21%");
        doc.addTableColumn("column-width=21%");
        doc.addTableColumn("column-width=21%");
        doc.addTableColumn("column-width=21%");
        doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + header_row, "display-align=center");
        doc.addText("\u00a0");
        doc.nextTableCell(rowHeight);
        doc.addText(Gedcom.getName((String)PropertySex.TXT_MALE));
        doc.nextTableCell(rowHeight);
        doc.addText(Gedcom.getName((String)PropertySex.TXT_FEMALE));
        doc.nextTableCell(rowHeight);
        doc.addText(Gedcom.getName((String)PropertySex.TXT_UNKNOWN));
        doc.nextTableCell(rowHeight);
        doc.addText(this.translate("totals"), "font-weight=bold");
        if (!sex2IndiStats.isEmpty()) {
            int row = 0;
            for (String[] line : arrayList) {
                String bgColor = ++row % 2 == 0 ? even_row : odd_row;
                String border = "";
                if (topBorders.contains(line[0])) {
                    border = ", border-top-width=1, border-top-style=dashed, border-top-color=rgb(0,0,0)";
                }
                doc.nextTableRow("text-align=center, background-color=" + bgColor + border, rowHeight);
                doc.addText(this.translate(line[0]), styles[0]);
                for (int col = 1; col < 5; ++col) {
                    doc.nextTableCell("text-align=center, " + rowHeight);
                    if (line[col + 4].isBlank()) {
                        doc.addText(line[col], styles[col]);
                        continue;
                    }
                    doc.addLink(line[col], line[col + 4], styles[col]);
                }
            }
        } else {
            doc.nextTableRow("text-align=left, background-color=" + even_row, "text-align=center, number-columns-spanned=3");
            doc.addText(this.translate("none"));
        }
        doc.endTable();
    }

    private void displayFamStats(Document doc, Set<? extends Property> set) {
        FamStat famStat = new FamStat();
        for (Property property : set) {
            if (!(property instanceof Fam)) continue;
            Fam fam = (Fam)property;
            famStat.increment(fam);
        }
        String header_row = this.colors.getHeaderRowColor();
        String string = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String[] styles = new String[]{"font-weight=bold", "", ""};
        String rowHeight = "height=" + (double)this.formattingOptions.common.getTextSize() * 2.5 + "px, display-align=center";
        String[][] spouseTable = famStat.getSpouseTable(this);
        doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=0cm, border-color=" + textColor);
        doc.addTableColumn("column-width=33%");
        doc.addTableColumn("column-width=33%");
        doc.addTableColumn("column-width=34%");
        doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + header_row, "display-align=center");
        doc.addText(this.translate(spouseTable[0][0]));
        doc.nextTableCell(rowHeight);
        doc.addText(this.translate(spouseTable[0][1]));
        doc.nextTableCell(rowHeight);
        doc.addText(this.translate(spouseTable[0][2]));
        if (spouseTable.length > 1) {
            for (int row = 1; row < spouseTable.length; ++row) {
                String bgColor = row % 2 == 0 ? string : odd_row;
                doc.nextTableRow("text-align=center, background-color=" + bgColor, rowHeight);
                doc.addText(this.translate(spouseTable[row][0]), styles[0]);
                doc.nextTableCell("text-align=center, " + rowHeight);
                if (spouseTable[row][3].isBlank()) {
                    doc.addText(spouseTable[row][1], styles[1]);
                } else {
                    doc.addLink(spouseTable[row][1], spouseTable[row][3], styles[1]);
                }
                doc.nextTableCell("text-align=center, " + rowHeight);
                if (spouseTable[row][4].isBlank()) {
                    doc.addText(spouseTable[row][2], styles[2]);
                    continue;
                }
                doc.addLink(spouseTable[row][2], spouseTable[row][4], styles[1]);
            }
        } else {
            doc.nextTableRow("text-align=left, background-color=" + string, "text-align=center, number-columns-spanned=3");
            doc.addText(this.translate("none"));
        }
        doc.endTable();
        String[][] childrenTable = famStat.getChildrenTable(this);
        doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=1cm, border-color=" + textColor);
        doc.addTableColumn("column-width=33%");
        doc.addTableColumn("column-width=33%");
        doc.addTableColumn("column-width=34%");
        doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + header_row, "display-align=center");
        doc.addText(this.translate(childrenTable[0][0]));
        doc.nextTableCell(rowHeight);
        doc.addText(this.translate(childrenTable[0][1]));
        doc.nextTableCell(rowHeight);
        doc.addText(this.translate(childrenTable[0][2]));
        if (childrenTable.length > 1) {
            int row;
            for (row = 1; row < childrenTable.length - 1; ++row) {
                String bgColor = row % 2 == 0 ? string : odd_row;
                doc.nextTableRow("text-align=center, background-color=" + bgColor, rowHeight);
                doc.addText(this.translate(childrenTable[row][0]), styles[0]);
                doc.nextTableCell("text-align=center, " + rowHeight);
                if (childrenTable[row][3].isBlank()) {
                    doc.addText(childrenTable[row][1], styles[1]);
                } else {
                    doc.addLink(childrenTable[row][1], childrenTable[row][3], styles[1]);
                }
                doc.nextTableCell("text-align=center, " + rowHeight);
                doc.addText(childrenTable[row][2], styles[2]);
            }
            row = childrenTable.length - 1;
            String border = ", border-style=dashed, border-top-width=1, border-top-style=dashed, border-bottom-width=0, border-right-width=0, border-left-width=0, border-top-color=" + textColor;
            doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", text-align=center, font-weight=bold" + border, "display-align=center");
            doc.addText(this.translate(childrenTable[row][0]), "font-weight=bold");
            doc.nextTableCell(rowHeight);
            doc.addText(childrenTable[row][1], "font-weight=bold");
            doc.nextTableCell(rowHeight);
            doc.addText(childrenTable[row][2], "font-weight=bold");
        } else {
            doc.nextTableRow("text-align=left, background-color=" + string, "text-align=center, number-columns-spanned=3");
            doc.addText(this.translate("none"));
        }
        doc.endTable();
    }

    private void displayTopOccurrences(Document doc, String tag, Set<? extends Property> set) {
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String rowHeight = "height=" + this.formattingOptions.common.getTextSize() * 2 + "px, display-align=center";
        doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=0cm, border-color=" + textColor);
        doc.addTableColumn("column-width=80%");
        doc.addTableColumn("column-width=10%");
        doc.addTableColumn("column-width=10%");
        doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + header_row, rowHeight);
        doc.addText(Gedcom.getName((String)tag));
        doc.nextTableCell(rowHeight);
        doc.addText(this.translate("nb"));
        doc.nextTableCell(rowHeight);
        doc.addText(this.translate("percentage"));
        if (!set.isEmpty()) {
            int row = 0;
            for (Frequency freq : this.getFrequenciesFromSet(set)) {
                String bgColor = row % 2 == 0 ? even_row : odd_row;
                ++row;
                doc.nextTableRow("text-align=left, background-color=" + bgColor);
                if (!freq.id.isEmpty()) {
                    doc.addLink("(" + freq.id + ")", this.gedcom.getEntity(freq.id).getLinkAnchor());
                    doc.addText("\u00a0");
                }
                doc.addText(freq.label);
                doc.nextTableCell("text-align=center");
                this.putLink(doc, String.valueOf(freq.nb), "", freq.set);
                doc.nextTableCell("text-align=center");
                doc.addText(String.valueOf((double)((int)(freq.percent * 100.0)) / 100.0) + "%");
            }
        } else {
            doc.nextTableRow("text-align=left, background-color=" + even_row, "text-align=center, number-columns-spanned=3");
            doc.addText(this.translate("none"));
        }
        doc.endTable();
    }

    /*
     * WARNING - void declaration
     */
    private List<Frequency> getFrequenciesFromSet(Set<? extends Property> set) {
        void var6_8;
        String key;
        ArrayList<Frequency> result = new ArrayList<Frequency>();
        ReferenceSet countMap = new ReferenceSet();
        int total = 0;
        for (Property property : set) {
            Property[] xref;
            Entity entity;
            key = "";
            if (property instanceof Entity) {
                entity = (Entity)property;
                key = this.getEntityKey(entity);
            } else {
                key = property instanceof PropertyXRef && (xref = (Property[])property).isValid() && xref.getTargetEntity().isPresent() ? this.getEntityKey((Entity)xref.getTargetEntity().get()) : property.getDisplayValue();
            }
            if (!this.extract && property instanceof Entity) {
                entity = (Entity)property;
                xref = entity.getProperties("XREF");
                int n = xref.length;
                for (int i = 0; i < n; ++i) {
                    Property xref2 = xref[i];
                    countMap.add((Object)key, (Object)xref2);
                    ++total;
                }
                continue;
            }
            countMap.add((Object)key, (Object)property);
            ++total;
        }
        List keys = countMap.getKeys((o1, o2) -> {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int diff = countMap.getReferences((Object)s2).size() - countMap.getReferences((Object)s1).size();
            if (diff != 0) {
                return diff;
            }
            return s1.compareTo(s2);
        });
        boolean bl = false;
        while (var6_8 < this.topLimit && var6_8 < keys.size()) {
            key = (String)keys.get((int)var6_8);
            Set props = countMap.getReferences((Object)key);
            int nb = props.size();
            double percent = (double)(nb * 10000 / total) / 100.0;
            result.add(new Frequency(key, nb, percent, props));
            ++var6_8;
        }
        return result;
    }

    private String getEntityKey(Entity entity) {
        return entity.getId() + Frequency.DELIM + entity.toString(false);
    }

    private Set<Fam> getFamFromIndis(boolean extract, Set<Indi> indis) {
        HashSet<Fam> fams = new HashSet<Fam>();
        if (extract) {
            for (Indi indi : indis) {
                fams.addAll(Arrays.asList(indi.getFamiliesWhereChild()));
                fams.addAll(Arrays.asList(indi.getFamiliesWhereSpouse()));
            }
        } else {
            fams.addAll(this.gedcom.getFamilies());
        }
        return fams;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Property> getFrom(boolean extract, String tag, Set<? extends Property> ... sets) {
        HashSet<Property> ret = new HashSet<Property>();
        boolean isEntity = tag.matches("(SOUR|REPO|OBJE|SNOTE)");
        if (tag.equals("SNOTE") && !this.gedcom.isGrammar7()) {
            tag = "NOTE";
        }
        if (extract) {
            for (Set<? extends Property> set : sets) {
                for (Property property : set) {
                    void var11_16;
                    PropertyXRef xref;
                    if (property instanceof PropertyXRef && (xref = (PropertyXRef)property).isValid() && xref.getTargetEntity().isPresent()) {
                        Property property2 = (Property)xref.getTargetEntity().get();
                    }
                    List props = var11_16.getAllProperties(tag);
                    for (Property prop : props) {
                        PropertyXRef xref2;
                        if (prop instanceof PropertyXRef && (xref2 = (PropertyXRef)prop).isValid() && xref2.getTargetEntity().isPresent()) {
                            if (!isEntity) continue;
                            ret.add(prop);
                            continue;
                        }
                        if (isEntity || prop.getDisplayValue().isBlank()) continue;
                        ret.add(prop);
                    }
                }
            }
        } else if (isEntity) {
            ret.addAll(this.gedcom.getEntities(tag));
        } else {
            for (Entity entity : this.gedcom.getEntities()) {
                if (entity.getTag().equals("NOTE")) continue;
                List props = entity.getAllProperties(tag);
                for (Property prop : props) {
                    if (prop != null && prop instanceof PropertyXRef || prop == null || prop.getDisplayValue().isBlank()) continue;
                    ret.add(prop);
                }
            }
        }
        return ret;
    }

    private void putLink(Document doc, String value, String style, Set<Property> set) {
        String linkId = this.getLinkId(set);
        if (linkId.isBlank()) {
            doc.addText(value, style);
            return;
        }
        doc.addLink(value, linkId, style);
    }

    protected String getLinkId(Set<Property> set) {
        if (!this.formattingOptions.generateLinks || set == null || set.isEmpty()) {
            return "";
        }
        Integer key = this.linkSets.getNewKey();
        this.linkSets.put(key, set);
        Entity entity = set.iterator().next().getEntity();
        return AncestrisAPIEntry.Factory.getAnchor((String)"ReportContent", (String)(this.run_Id + "." + key.toString()), (Entity)entity);
    }

    public boolean isEntryId(String id) {
        if (id.contains(ENTRY_ID) && !this.run_Id.equals(id)) {
            String title = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"title.showList");
            String msg = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"title.showList.obsolete");
            LOG.warning(title);
            LOG.warning(msg);
            DialogManager.create((String)title, (String)msg).setMessageType(2).setOptionType(10).show();
        }
        return this.run_Id.equals(id);
    }

    public boolean processAction(String key) {
        ArrayList<ViewContext> list = new ArrayList<ViewContext>();
        Set set = (Set)this.linkSets.get(Integer.valueOf(key));
        int counter = 1;
        String title = "#" + key + "-" + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"title.showList");
        for (Property property : set) {
            if (counter > 300) {
                DialogManager.create((String)title, (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"title.showList.limitReached", (Object)set.size(), (Object)300)).setMessageType(2).setOptionType(10).show();
                break;
            }
            list.add(new ViewContext(property));
            ++counter;
        }
        String tip = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"title.showList.tip", (Object)list.size());
        ContextListWidget component = new ContextListWidget(list);
        new WidgetDocumentView(new Context(this.gedcom), title, tip, (JComponent)component);
        return true;
    }

    public class MyFormattingOptions {
        public FormattingOptions common = new FormattingOptions();
        public boolean generatePageBreak = true;
        public boolean generateLinks = true;
    }
}

