/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.topnames;

import ancestris.reports.FilterOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.ColorUtils;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.report.Report;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportTopNames
extends Report {
    public FormattingOptions formattingOptions = new FormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    public boolean showTopOnly = true;
    private static final int SIZEMAX = 30;
    public FilterOptions filterOptions = new FilterOptions();
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private Document doc;
    private Gedcom gedcom;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.getScope(entity, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        this.gedcom = indis[0].getGedcom();
        List<Indi> indisList = Arrays.asList(indis);
        return this.main(indisList);
    }

    public Document main(List<Indi> indis) {
        Collator collator = this.gedcom.getCollator();
        String surnLabel = Gedcom.getName((String)"SURN");
        String givnLabel = Gedcom.getName((String)"GIVN");
        String nbLabel = this.translate("nbLabel");
        String freqLabel = this.translate("freqLabel");
        String totalLabel = this.translate("total");
        String othersLabel = this.translate("others");
        String header_row = ColorUtils.color2string(this.colors.bgHeaderRow);
        String even_row = ColorUtils.color2string(this.colors.bgEvenRow);
        String odd_row = ColorUtils.color2string(this.colors.bgOddRow);
        String textColor = ColorUtils.color2string(this.colors.fgText);
        DecimalFormat df = new DecimalFormat("0.00");
        HashMap<String, Integer> surns = new HashMap<String, Integer>();
        HashMap<Object, Integer> givns = new HashMap<Object, Integer>();
        for (Indi indi : indis) {
            Object givn;
            String surn;
            if (!this.filterOptions.matchRecord((Property)indi, (surn = indi.getLastName()) + " " + (String)(givn = indi.getFirstName()), surn + " " + (String)givn)) continue;
            Integer nbSurn = (Integer)surns.get(surn);
            if (nbSurn == null) {
                nbSurn = 0;
            }
            Iterator<String[]> iterator = nbSurn;
            nbSurn = nbSurn + 1;
            surns.put(surn, nbSurn);
            Integer nbGivn = (Integer)givns.get(givn);
            if (nbGivn == null) {
                nbGivn = 0;
            }
            Integer n = nbGivn;
            nbGivn = nbGivn + 1;
            givns.put(givn, nbGivn);
        }
        ArrayList<Map.Entry<String, Integer>> sortedSurns = new ArrayList<Map.Entry<String, Integer>>(surns.entrySet());
        Collections.sort(sortedSurns, (o1, o2) -> {
            if (!Objects.equals(o1.getValue(), o2.getValue())) {
                return ((Integer)o2.getValue()).compareTo((Integer)o1.getValue());
            }
            return collator.compare((String)o1.getKey(), (String)o2.getKey());
        });
        ArrayList<Map.Entry<String, Integer>> sortedGivns = new ArrayList<Map.Entry<String, Integer>>(givns.entrySet());
        Collections.sort(sortedGivns, (o1, o2) -> {
            if (!Objects.equals(o1.getValue(), o2.getValue())) {
                return ((Integer)o2.getValue()).compareTo((Integer)o1.getValue());
            }
            return collator.compare((String)o1.getKey(), (String)o2.getKey());
        });
        int totalSurns = 0;
        for (Object key : surns.keySet()) {
            totalSurns += ((Integer)surns.get(key)).intValue();
        }
        int totalGivns = 0;
        for (String key : givns.keySet()) {
            totalGivns += ((Integer)givns.get(key)).intValue();
        }
        String title = this.translate("title", new Object[]{this.gedcom.getDisplayName()});
        this.doc = this.formattingOptions.createDocument(this.translate("name"), textColor, this.colors.getBackgroundColor());
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.scope.isLimited()) {
            this.doc.addText(this.scope.getMainMessage(), "font-weight=bold");
            for (String[] scopeLine : this.scope.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + scopeLine[0]);
                if (scopeLine[1].isBlank()) continue;
                this.doc.addText(" : " + scopeLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.filterOptions.isFilterOn()) {
            this.doc.addText(this.filterOptions.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=1cm, border-color=" + textColor);
        this.doc.addTableColumn("column-width=49%");
        this.doc.addTableColumn("column-width=2%");
        this.doc.addTableColumn("column-width=49%");
        this.doc.nextTableRow("font-weight=bold, text-align=center");
        this.doc.addText(surnLabel, "font-size=" + (this.formattingOptions.getTextSize() + 4));
        this.doc.nextTableCell("width=20pt");
        this.doc.addText("\u00a0");
        this.doc.nextTableCell();
        this.doc.addText(givnLabel, "font-size=" + (this.formattingOptions.getTextSize() + 4));
        this.doc.nextTableRow("", "text-align=center");
        this.displayTable(this.doc, surnLabel, nbLabel, freqLabel, totalLabel, othersLabel, totalSurns, sortedSurns, df, header_row, even_row, odd_row);
        this.doc.nextTableCell("genj:csv=false");
        this.doc.addText("\u00a0");
        this.doc.nextTableCell("text-align=center");
        this.displayTable(this.doc, givnLabel, nbLabel, freqLabel, totalLabel, othersLabel, totalGivns, sortedGivns, df, header_row, even_row, odd_row);
        return this.doc;
    }

    private void displayTable(Document doc, String colLabel, String nbLabel, String freqLabel, String totalLabel, String othersLabel, int total, List<Map.Entry<String, Integer>> sortedList, DecimalFormat df, String header_row, String even_row, String odd_row) {
        doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=1cm, border-color=" + this.colors.getTextColor());
        doc.addTableColumn("column-width=55%");
        doc.addTableColumn("column-width=20%");
        doc.addTableColumn("column-width=25%");
        doc.nextTableRow("font-weight=bold, background-color=" + header_row, "text-align=left, margin-left=10pt, width=55%");
        doc.addText(colLabel);
        doc.nextTableCell("text-align=center");
        doc.addText(nbLabel);
        doc.nextTableCell("text-align=right, margin-right=10pt");
        doc.addText(freqLabel);
        doc.nextTableRow("font-weight=bold", "text-align=left, margin-left=10pt");
        doc.addText(totalLabel);
        doc.nextTableCell("text-align=center");
        doc.addText(String.valueOf(total));
        doc.nextTableCell("text-align=right, margin-right=10pt");
        doc.addText("100.00%");
        doc.nextTableRow("font-weight=bold", "text-align=left, margin-left=10pt");
        doc.addText("\u00a0");
        doc.nextTableCell("text-align=center");
        doc.addText("\u00a0");
        doc.nextTableCell("text-align=right, margin-right=10pt");
        doc.addText("\u00a0");
        int row = 1;
        int restCounter = 0;
        for (Map.Entry<String, Integer> entry : sortedList) {
            if (this.showTopOnly && row > 30) {
                restCounter += entry.getValue().intValue();
                continue;
            }
            String bgColor = row % 2 == 0 ? even_row : odd_row;
            ++row;
            doc.nextTableRow("background-color=" + bgColor, "text-align=left, margin-left=10pt");
            doc.addText(entry.getKey() + "\u00a0");
            doc.nextTableCell("text-align=center");
            int n = entry.getValue();
            doc.addText(String.valueOf(n));
            doc.nextTableCell("text-align=right, margin-right=10pt");
            double d = (double)(n * 100) / (double)total;
            doc.addText(df.format(d) + "%");
        }
        if (this.showTopOnly && restCounter > 0) {
            String bgColor = row % 2 == 0 ? even_row : odd_row;
            ++row;
            doc.nextTableRow("background-color=" + bgColor, "text-align=left, margin-left=10pt");
            doc.addText(othersLabel);
            doc.nextTableCell("text-align=center");
            doc.addText(String.valueOf(restCounter));
            doc.nextTableCell("text-align=right, margin-right=10pt");
            double d = (double)(restCounter * 100) / (double)total;
            doc.addText(df.format(d) + "%");
        }
        doc.endTable();
    }
}

