/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentIsNotFocusedException;
import org.netbeans.jemmy.ComponentIsNotVisibleException;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.NoComponentUnderMouseException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;

public class EventDispatcher
implements Outputable,
Timeoutable {
    private static final long WAIT_QUEUE_EMPTY_TIMEOUT = 180000L;
    private static final long ROBOT_AUTO_DELAY = 10L;
    private static final long WAIT_COMPONENT_UNDER_MOUSE_TIMEOUT = 60000L;
    private static Field[] keyFields;
    private static MotionListener motionListener;
    protected Component component;
    private TestOut output;
    private Timeouts timeouts;
    private ClassReference reference;
    private int model;
    private ClassReference robotReference = null;
    private boolean outsider = false;
    private QueueTool queueTool;

    public EventDispatcher(Component comp) {
        this.component = comp;
        this.reference = new ClassReference(comp);
        this.queueTool = new QueueTool();
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setDispatchingModel(JemmyProperties.getProperties().getDispatchingModel());
    }

    public static void waitQueueEmpty(TestOut output, Timeouts timeouts) {
        QueueTool qt = new QueueTool();
        qt.setTimeouts(timeouts.cloneThis());
        qt.getTimeouts().setTimeout("QueueTool.WaitQueueEmptyTimeout", JemmyProperties.getCurrentTimeout("EventDispatcher.WaitQueueEmptyTimeout"));
        qt.setOutput(output);
        qt.waitEmpty();
    }

    public static void waitQueueEmpty() {
        EventDispatcher.waitQueueEmpty(JemmyProperties.getCurrentOutput(), JemmyProperties.getCurrentTimeouts());
    }

    public static void waitQueueEmpty(long emptyTime, TestOut output, Timeouts timeouts) {
        QueueTool qt = new QueueTool();
        qt.setTimeouts(timeouts.cloneThis());
        qt.getTimeouts().setTimeout("QueueTool.WaitQueueEmptyTimeout", JemmyProperties.getCurrentTimeout("EventDispatcher.WaitQueueEmptyTimeout"));
        qt.setOutput(output);
        qt.waitEmpty(emptyTime);
    }

    public static void waitQueueEmpty(long emptyTime) {
        EventDispatcher.waitQueueEmpty(emptyTime, JemmyProperties.getCurrentOutput(), JemmyProperties.getCurrentTimeouts());
    }

    public static String getModifiersString(int modifiers) {
        String result = "";
        if ((modifiers & 2) != 0) {
            result = result + "CTRL_MASK | ";
        }
        if ((modifiers & 4) != 0) {
            result = result + "META_MASK | ";
        }
        if ((modifiers & 8) != 0) {
            result = result + "ALT_MASK | ";
        }
        if ((modifiers & 0x20) != 0) {
            result = result + "ALT_GRAPH_MASK | ";
        }
        if ((modifiers & 1) != 0) {
            result = result + "SHIFT_MASK | ";
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 3);
        }
        return result;
    }

    public static String getKeyDescription(int keyCode) {
        for (int i = 0; i < keyFields.length; ++i) {
            try {
                if (!keyFields[i].getName().startsWith("VK_") || keyFields[i].getInt(null) != keyCode) continue;
                return keyFields[i].getName();
            }
            catch (IllegalAccessException e) {
                JemmyProperties.getCurrentOutput().printStackTrace(e);
            }
        }
        return "VK_UNKNOWN";
    }

    public static String getMouseButtonDescription(int button) {
        String result = (button & 0x10) != 0 ? "BUTTON1" : ((button & 8) != 0 ? "BUTTON2" : ((button & 4) != 0 ? "BUTTON3" : "UNKNOWN_BUTTON"));
        return result;
    }

    public static void performInit() {
        Timeouts.initDefault("EventDispatcher.WaitQueueEmptyTimeout", 180000L);
        Timeouts.initDefault("EventDispatcher.RobotAutoDelay", 10L);
        Timeouts.initDefault("EventDispatcher.WaitComponentUnderMouseTimeout", 60000L);
        try {
            keyFields = Class.forName("java.awt.event.KeyEvent").getFields();
        }
        catch (ClassNotFoundException e) {
            JemmyProperties.getCurrentOutput().printStackTrace(e);
        }
    }

    public void checkComponentUnderMouse(boolean yesOrNo) {
        this.outsider = !yesOrNo;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        this.queueTool.setOutput(out);
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        this.queueTool.setTimeouts(timeouts);
        this.queueTool.getTimeouts().setTimeout("QueueTool.WaitQueueEmptyTimeout", timeouts.getTimeout("EventDispatcher.WaitQueueEmptyTimeout"));
        if (this.robotReference != null) {
            try {
                Object[] params = new Object[]{new Integer((int)timeouts.getTimeout("EventDispatcher.RobotAutoDelay"))};
                Class[] paramClasses = new Class[]{Integer.TYPE};
                this.robotReference.invokeMethod("setAutoDelay", params, paramClasses);
            }
            catch (InvocationTargetException e) {
                this.output.printStackTrace(e);
            }
            catch (IllegalStateException e) {
                this.output.printStackTrace(e);
            }
            catch (NoSuchMethodException e) {
                this.output.printStackTrace(e);
            }
            catch (IllegalAccessException e) {
                this.output.printStackTrace(e);
            }
        }
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setDispatchingModel(int m) {
        this.model = m;
        if ((this.model & JemmyProperties.ROBOT_MODEL_MASK) != 0) {
            this.createRobot();
            try {
                Object[] params = new Object[]{(this.model & JemmyProperties.QUEUE_MODEL_MASK) != 0 ? Boolean.TRUE : Boolean.FALSE};
                Class[] paramClasses = new Class[]{Boolean.TYPE};
                this.robotReference.invokeMethod("setAutoWaitForIdle", params, paramClasses);
            }
            catch (InvocationTargetException e) {
                this.output.printStackTrace(e);
            }
            catch (IllegalStateException e) {
                this.output.printStackTrace(e);
            }
            catch (NoSuchMethodException e) {
                this.output.printStackTrace(e);
            }
            catch (IllegalAccessException e) {
                this.output.printStackTrace(e);
            }
        }
    }

    public int getDispatchingModel() {
        return this.model;
    }

    public void dispatchEvent(final AWTEvent event) {
        String eventToString = (String)this.queueTool.invokeSmoothly(new QueueTool.QueueAction("event.toString()"){

            @Override
            public Object launch() {
                return event.toString();
            }
        });
        this.output.printLine("Dispatch event " + eventToString);
        this.output.printGolden("Dispatch event " + event.getClass().toString());
        Dispatcher disp = new Dispatcher(event);
        this.queueTool.invokeAndWait(disp);
    }

    public void dispatchMouseEvent(int id, int mods, int clickCount, int x, int y, boolean popup) {
        MouseEvent event = new MouseEvent(this.component, id, System.currentTimeMillis(), mods, x, y, clickCount, popup);
        this.dispatchEvent(event);
    }

    public void dispatchMouseEvent(int id, int mods, int clickCount, boolean popup) {
        int x = this.component.getWidth() / 2;
        int y = this.component.getHeight() / 2;
        this.dispatchMouseEvent(id, mods, clickCount, x, y, popup);
    }

    public void dispatchWindowEvent(int id) {
        WindowEvent event = new WindowEvent((Window)this.component, id);
        this.dispatchEvent(event);
    }

    public void dispatchKeyEvent(int id, int mods, int keyCode) {
        KeyEvent event = new KeyEvent(this.component, id, System.currentTimeMillis(), mods, keyCode);
        this.dispatchEvent(event);
    }

    public void dispatchKeyEvent(int id, int mods, int keyCode, char keyChar) {
        KeyEvent event = new KeyEvent(this.component, id, System.currentTimeMillis(), mods, keyCode, keyChar);
        this.dispatchEvent(event);
    }

    public void waitForIdle() {
        this.makeRobotOperation("waitForIdle", null, null);
    }

    protected int getAbsoluteX(int x) {
        return (int)this.component.getLocationOnScreen().getX() + x;
    }

    protected int getAbsoluteY(int y) {
        return (int)this.component.getLocationOnScreen().getY() + y;
    }

    public void delayRobot(long time) {
        Object[] params = new Object[]{new Integer((int)time)};
        Class[] paramClasses = new Class[]{Integer.TYPE};
        this.makeRobotOperation("delay", params, paramClasses);
    }

    public void robotMoveMouse(int x, int y) {
        if (motionListener == null) {
            this.initMotionListener();
        }
        this.output.printLine("Move mouse to (" + Integer.toString(x) + "," + Integer.toString(y) + ")");
        Object[] params = new Object[]{new Integer(this.getAbsoluteX(x)), new Integer(this.getAbsoluteY(y))};
        Class[] paramClasses = new Class[]{Integer.TYPE, Integer.TYPE};
        this.makeRobotOperation("mouseMove", params, paramClasses);
    }

    public void robotPressMouse(int button, int modifiers) {
        if (!this.outsider) {
            this.waitMouseOver();
        }
        this.robotPressModifiers(modifiers);
        this.output.printLine("Press " + EventDispatcher.getMouseButtonDescription(button) + " mouse button");
        Object[] params = new Object[]{new Integer(button)};
        Class[] paramClasses = new Class[]{Integer.TYPE};
        this.makeRobotOperation("mousePress", params, paramClasses);
    }

    public void robotPressMouse(int button) {
        this.robotPressMouse(button, 0);
    }

    public void robotReleaseMouse(int button, int modifiers) {
        this.output.printLine("Release " + EventDispatcher.getMouseButtonDescription(button) + " mouse button");
        Object[] params = new Object[]{new Integer(button)};
        Class[] paramClasses = new Class[]{Integer.TYPE};
        this.makeRobotOperation("mouseRelease", params, paramClasses);
        this.robotReleaseModifiers(modifiers);
    }

    public void robotReleaseMouse(int button) {
        this.robotReleaseMouse(button, 0);
    }

    public void robotPressKey(int keyCode, int modifiers) {
        this.robotPressModifiers(modifiers);
        this.output.printLine("Press " + EventDispatcher.getKeyDescription(keyCode) + " key");
        Object[] params = new Object[]{new Integer(keyCode)};
        Class[] paramClasses = new Class[]{Integer.TYPE};
        this.makeRobotOperation("keyPress", params, paramClasses);
    }

    public void robotPressKey(int keyCode) {
        this.robotPressKey(keyCode, 0);
    }

    public void robotReleaseKey(int keyCode, int modifiers) {
        this.output.printLine("Release " + EventDispatcher.getKeyDescription(keyCode) + " key");
        Object[] params = new Object[]{new Integer(keyCode)};
        Class[] paramClasses = new Class[]{Integer.TYPE};
        this.makeRobotOperation("keyRelease", params, paramClasses);
        this.robotReleaseModifiers(modifiers);
    }

    public void robotReleaseKey(int keyCode) {
        this.robotReleaseKey(keyCode, 0);
    }

    public Object invokeMethod(String method_name, Object[] params, Class[] params_classes) throws InvocationTargetException, IllegalStateException, NoSuchMethodException, IllegalAccessException {
        Invoker invk = new Invoker(method_name, params, params_classes);
        try {
            return this.queueTool.invokeAndWait(invk);
        }
        catch (JemmyException e) {
            if (invk.getException() != null) {
                if (invk.getException() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)invk.getException();
                }
                if (invk.getException() instanceof IllegalStateException) {
                    throw (IllegalStateException)invk.getException();
                }
                if (invk.getException() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)invk.getException();
                }
                if (invk.getException() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)invk.getException();
                }
            }
            throw e;
        }
    }

    public Object getField(String field_name) throws InvocationTargetException, IllegalStateException, NoSuchFieldException, IllegalAccessException {
        Getter gtr = new Getter(field_name);
        try {
            return this.queueTool.invokeAndWait(gtr);
        }
        catch (JemmyException e) {
            if (gtr.getException() != null) {
                if (gtr.getException() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)gtr.getException();
                }
                if (gtr.getException() instanceof IllegalStateException) {
                    throw (IllegalStateException)gtr.getException();
                }
                if (gtr.getException() instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)gtr.getException();
                }
                if (gtr.getException() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)gtr.getException();
                }
            }
            throw e;
        }
    }

    public void setField(String field_name, Object newValue) throws InvocationTargetException, IllegalStateException, NoSuchFieldException, IllegalAccessException {
        Setter str = new Setter(field_name, newValue);
        try {
            this.queueTool.invokeAndWait(str);
        }
        catch (JemmyException e) {
            if (str.getException() != null) {
                if (str.getException() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)str.getException();
                }
                if (str.getException() instanceof IllegalStateException) {
                    throw (IllegalStateException)str.getException();
                }
                if (str.getException() instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)str.getException();
                }
                if (str.getException() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)str.getException();
                }
            }
            throw e;
        }
    }

    public Object invokeExistingMethod(String method_name, Object[] params, Class[] params_classes, TestOut out) {
        try {
            return this.invokeMethod(method_name, params, params_classes);
        }
        catch (InvocationTargetException e) {
            out.printStackTrace(e);
        }
        catch (IllegalStateException e) {
            out.printStackTrace(e);
        }
        catch (NoSuchMethodException e) {
            out.printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            out.printStackTrace(e);
        }
        return null;
    }

    public Object getExistingField(String field_name, TestOut out) {
        try {
            return this.getField(field_name);
        }
        catch (InvocationTargetException e) {
            out.printStackTrace(e);
        }
        catch (IllegalStateException e) {
            out.printStackTrace(e);
        }
        catch (NoSuchFieldException e) {
            out.printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            out.printStackTrace(e);
        }
        return null;
    }

    public void setExistingField(String field_name, Object newValue, TestOut out) {
        try {
            this.setField(field_name, newValue);
        }
        catch (InvocationTargetException e) {
            out.printStackTrace(e);
        }
        catch (IllegalStateException e) {
            out.printStackTrace(e);
        }
        catch (NoSuchFieldException e) {
            out.printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            out.printStackTrace(e);
        }
    }

    public Object invokeExistingMethod(String method_name, Object[] params, Class[] params_classes) {
        return this.invokeExistingMethod(method_name, params, params_classes, this.output);
    }

    public Object getExistingField(String field_name) {
        return this.getExistingField(field_name, this.output);
    }

    public void setExistingField(String field_name, Object newValue) {
        this.setExistingField(field_name, newValue, this.output);
    }

    private void robotReleaseModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.robotReleaseKey(16, modifiers - (1 & modifiers));
        } else if ((modifiers & 0x20) != 0) {
            this.robotReleaseKey(65406, modifiers - (0x20 & modifiers));
        } else if ((modifiers & 8) != 0) {
            this.robotReleaseKey(18, modifiers - (8 & modifiers));
        } else if ((modifiers & 4) != 0) {
            this.robotReleaseKey(157, modifiers - (4 & modifiers));
        } else if ((modifiers & 2) != 0) {
            this.robotReleaseKey(17, modifiers - (2 & modifiers));
        }
    }

    private void checkVisibility() {
        if (!this.component.isVisible()) {
            throw new ComponentIsNotVisibleException(this.component);
        }
    }

    private void checkFocus() {
        if (!this.component.hasFocus()) {
            throw new ComponentIsNotFocusedException(this.component);
        }
    }

    private void createRobot() {
        try {
            ClassReference robotClassReverence = new ClassReference("java.awt.Robot");
            this.robotReference = new ClassReference(robotClassReverence.newInstance(null, null));
        }
        catch (ClassNotFoundException e) {
            this.output.printStackTrace(e);
        }
        catch (InstantiationException e) {
            this.output.printStackTrace(e);
        }
        catch (InvocationTargetException e) {
            this.output.printStackTrace(e);
        }
        catch (IllegalStateException e) {
            this.output.printStackTrace(e);
        }
        catch (NoSuchMethodException e) {
            this.output.printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            this.output.printStackTrace(e);
        }
    }

    private void waitMouseOver() {
        try {
            Waiter wt = new Waiter(new Waitable(){

                @Override
                public Object actionProduced(Object obj) {
                    if (motionListener.getComponent() != null) {
                        return "";
                    }
                    return null;
                }

                @Override
                public String getDescription() {
                    return "Mouse over component";
                }
            });
            wt.setTimeoutsToCloneOf(this.timeouts, "EventDispatcher.WaitComponentUnderMouseTimeout");
            wt.setOutput(this.output.createErrorOutput());
            wt.waitAction(this.component);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
        }
        catch (TimeoutExpiredException e) {
            throw new NoComponentUnderMouseException();
        }
    }

    private void makeRobotOperation(String method, Object[] params, Class[] paramClasses) {
        try {
            this.robotReference.invokeMethod(method, params, paramClasses);
        }
        catch (InvocationTargetException e) {
            this.output.printStackTrace(e);
        }
        catch (IllegalStateException e) {
            this.output.printStackTrace(e);
        }
        catch (NoSuchMethodException e) {
            this.output.printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            this.output.printStackTrace(e);
        }
        if ((this.model & JemmyProperties.QUEUE_MODEL_MASK) != 0) {
            try {
                EventDispatcher.waitQueueEmpty(this.output.createErrorOutput(), this.timeouts);
            }
            catch (TimeoutExpiredException e) {
                this.output.printStackTrace(e);
            }
        }
    }

    private void robotPressModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.robotPressKey(16, modifiers & 0xFFFFFFFE);
        } else if ((modifiers & 0x20) != 0) {
            this.robotPressKey(65406, modifiers & 0xFFFFFFDF);
        } else if ((modifiers & 8) != 0) {
            this.robotPressKey(18, modifiers & 0xFFFFFFF7);
        } else if ((modifiers & 4) != 0) {
            this.robotPressKey(157, modifiers & 0xFFFFFFFB);
        } else if ((modifiers & 2) != 0) {
            this.robotPressKey(17, modifiers & 0xFFFFFFFD);
        }
    }

    private void initMotionListener() {
        if (motionListener == null) {
            motionListener = new MotionListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(motionListener, 16L);
            Object[] params = new Object[2];
            Class[] paramClasses = new Class[]{Integer.TYPE, Integer.TYPE};
            params[0] = new Integer(this.getAbsoluteX(-1));
            params[1] = new Integer(this.getAbsoluteX(-1));
            this.makeRobotOperation("mouseMove", params, paramClasses);
            params[0] = new Integer(this.getAbsoluteX(0));
            params[1] = new Integer(this.getAbsoluteX(0));
            this.makeRobotOperation("mouseMove", params, paramClasses);
        }
    }

    static {
        motionListener = null;
        EventDispatcher.performInit();
    }

    private static class MotionListener
    implements AWTEventListener {
        private Component mouseComponent;

        private MotionListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                MouseEvent e = (MouseEvent)event;
                if (e.getID() == 504) {
                    this.mouseComponent = e.getComponent();
                } else if (e.getID() == 505) {
                    this.mouseComponent = null;
                }
            }
        }

        public Component getComponent() {
            return this.mouseComponent;
        }
    }

    private class Setter
    extends QueueTool.QueueAction {
        String fieldName;
        Object newValue;

        public Setter(String fn, Object nv) {
            super(fn + " field changing");
            this.fieldName = fn;
            this.newValue = nv;
        }

        @Override
        public Object launch() throws InvocationTargetException, NoSuchFieldException, IllegalAccessException {
            EventDispatcher.this.reference.setField(this.fieldName, this.newValue);
            return null;
        }
    }

    private class Getter
    extends QueueTool.QueueAction {
        String fieldName;

        public Getter(String fn) {
            super(fn + " field receiving");
            this.fieldName = fn;
        }

        @Override
        public Object launch() throws InvocationTargetException, NoSuchFieldException, IllegalAccessException {
            return EventDispatcher.this.reference.getField(this.fieldName);
        }
    }

    private class Invoker
    extends QueueTool.QueueAction {
        protected String methodName;
        protected Object[] params;
        protected Class[] paramClasses;

        public Invoker(String mn, Object[] p, Class[] pc) {
            super(mn + " method invocation");
            this.methodName = mn;
            this.params = p;
            this.paramClasses = pc;
        }

        @Override
        public Object launch() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            EventDispatcher.this.checkVisibility();
            if (this.methodName.equals("keyPress") || this.methodName.equals("keyRelease")) {
                EventDispatcher.this.checkFocus();
            }
            return EventDispatcher.this.reference.invokeMethod(this.methodName, this.params, this.paramClasses);
        }
    }

    private class Dispatcher
    extends QueueTool.QueueAction {
        AWTEvent event;

        public Dispatcher(AWTEvent e) {
            super(e.getClass().getName() + " event dispatching");
            this.event = e;
        }

        @Override
        public Object launch() {
            if (this.event instanceof MouseEvent || this.event instanceof KeyEvent) {
                EventDispatcher.this.checkVisibility();
            }
            EventDispatcher.this.component.dispatchEvent(this.event);
            return null;
        }
    }
}

