/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.flashlist;

import ancestris.modules.flashlist.ReportFlashList;
import genj.common.SelectEntityWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyPlace;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class FlashListPanel
extends JPanel {
    private Registry registry = null;
    private static final Color UNSELECTED_COLOR = new Color(0, 0, 0);
    private static final Color SELECTED_COLOR = new Color(255, 0, 0);
    private static final ImageIcon GEO_ICON = new ImageIcon(FlashListPanel.class.getResource("/ancestris/modules/flashlist/place.png"));
    private static final ImageIcon NAME_ICON = new ImageIcon(FlashListPanel.class.getResource("/ancestris/modules/flashlist/name.png"));
    private static final String GEO_LABEL = NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.location1Label.text");
    private static final String NAME_LABEL = NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.location3Label.text");
    protected final String[] fonts;
    private String[] placeBits = null;
    private String[] placeBitsFull = null;
    private String country = "";
    private String city = "";
    private boolean existPlaceTag = false;
    private final int MAXROWS = 3;
    private int selectedRow = 0;
    private SortRow[] rows = null;
    public String[] legends = new String[]{"FlashListPanel.displayLegendComboBox.legendNone", "FlashListPanel.displayLegendComboBox.legendTop", "FlashListPanel.displayLegendComboBox.legendBot"};
    private SelectEntityWidget selectEntityWidget = null;
    private JCheckBox addTOCCheckBox;
    private JLabel boldLabel;
    private JComboBox<String> displayLegendComboBox;
    private JLabel displayLegendLabel;
    private JCheckBox displayZerosCheckBox;
    private JButton downButton;
    private JLabel filterHeaderLabel;
    private JTextField filterKey1TextField;
    private JTextField filterKey2TextField;
    private JTextField filterKey3TextField;
    private JComboBox<String> fontNameComboBox;
    private JLabel fontNameLabel;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JPanel formattingPanel;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JComboBox location1ComboBox1;
    private JComboBox location1ComboBox2;
    private JLabel location1Label;
    private JComboBox location2ComboBox1;
    private JComboBox location2ComboBox2;
    private JLabel location2Label;
    private JComboBox location3ComboBox1;
    private JComboBox location3ComboBox2;
    private JLabel location3Label;
    private JFormattedTextField minSosaFormattedTextField;
    private JLabel minSosaLabel;
    private JFormattedTextField nbEventsFormattedTextField;
    private JLabel nbEventsLabel;
    private JCheckBox repeatHeaderCheckBox;
    private JCheckBox repeatKeysCheckBox;
    private JPanel selectIndiPanel;
    private JLabel selectLabel;
    private JLabel sortingHeaderLabel;
    private JLabel sortingLabel;
    private JPanel sortingPanel;
    private JLabel structureLabel;
    private JButton upButton;
    private JFormattedTextField yearSpanFormattedTextField;
    private JLabel yearSpanLabel;
    private JLabel zerosLabel;

    public FlashListPanel(Gedcom gedcom) {
        this.registry = gedcom.getRegistry();
        this.placeBits = PropertyPlace.getFormat((Gedcom)gedcom);
        this.country = PropertyPlace.getCountryTag((Gedcom)gedcom);
        this.city = PropertyPlace.getCityTag((Gedcom)gedcom);
        boolean bl = this.existPlaceTag = this.placeBits.length > 0 && !this.placeBits[0].isEmpty();
        if (this.existPlaceTag) {
            this.placeBitsFull = new String[this.placeBits.length + 1];
            System.arraycopy(this.placeBits, 0, this.placeBitsFull, 1, this.placeBits.length);
            this.placeBitsFull[0] = "";
        } else {
            this.placeBitsFull = this.placeBits;
        }
        this.initComponents();
        this.initContextIndi(gedcom);
        this.location3ComboBox1.setVisible(false);
        this.location3ComboBox2.setVisible(false);
        this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addAll(Arrays.asList(this.fonts));
        this.fontNameComboBox.setModel(model);
        this.load();
        this.setRows();
        this.selectRow(0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.sortingPanel = new JPanel();
        this.sortingLabel = new JLabel();
        this.sortingHeaderLabel = new JLabel();
        this.filterHeaderLabel = new JLabel();
        this.location1Label = new JLabel();
        this.location1ComboBox1 = new JComboBox();
        this.location1ComboBox2 = new JComboBox();
        this.filterKey1TextField = new JTextField();
        this.location2Label = new JLabel();
        this.location2ComboBox1 = new JComboBox();
        this.location2ComboBox2 = new JComboBox();
        this.filterKey2TextField = new JTextField();
        this.location3Label = new JLabel();
        this.location3ComboBox1 = new JComboBox();
        this.location3ComboBox2 = new JComboBox();
        this.filterKey3TextField = new JTextField();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.repeatKeysCheckBox = new JCheckBox();
        this.formattingPanel = new JPanel();
        this.structureLabel = new JLabel();
        this.addTOCCheckBox = new JCheckBox();
        this.repeatHeaderCheckBox = new JCheckBox();
        this.displayLegendLabel = new JLabel();
        this.displayLegendComboBox = new JComboBox<String>(this.initDisplayLegendComboBox());
        this.boldLabel = new JLabel();
        this.yearSpanLabel = new JLabel();
        this.yearSpanFormattedTextField = new JFormattedTextField();
        this.nbEventsLabel = new JLabel();
        this.nbEventsFormattedTextField = new JFormattedTextField();
        this.minSosaLabel = new JLabel();
        this.minSosaFormattedTextField = new JFormattedTextField();
        this.zerosLabel = new JLabel();
        this.displayZerosCheckBox = new JCheckBox();
        this.selectLabel = new JLabel();
        this.selectIndiPanel = new JPanel();
        this.fontNameLabel = new JLabel();
        this.fontNameComboBox = new JComboBox();
        this.fontSizeLabel = new JLabel();
        this.fontSizeSpinner = new JSpinner();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FlashListPanel.this.formComponentResized(evt);
            }
        });
        this.jScrollPane1.setPreferredSize(new Dimension(686, 280));
        this.jTabbedPane1.setPreferredSize(new Dimension(580, 260));
        this.sortingPanel.setPreferredSize(new Dimension(600, 250));
        this.sortingPanel.setRequestFocusEnabled(false);
        this.sortingLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.sortingLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.sortingLabel.text"));
        this.sortingHeaderLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.sortingHeaderLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.sortingHeaderLabel.text"));
        this.filterHeaderLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.filterHeaderLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.filterHeaderLabel.text"));
        this.location1Label.setForeground(new Color(255, 0, 0));
        this.location1Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/flashlist/place.png")));
        Mnemonics.setLocalizedText((JLabel)this.location1Label, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.location1Label.text"));
        this.location1ComboBox1.setModel(new DefaultComboBoxModel<String>(this.placeBits));
        this.location1ComboBox1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.location1ComboBox1FocusGained(evt);
            }
        });
        this.location1ComboBox2.setModel(new DefaultComboBoxModel<String>(this.placeBitsFull));
        this.location1ComboBox2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.location1ComboBox2FocusGained(evt);
            }
        });
        this.filterKey1TextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.filterKey1TextFieldFocusGained(evt);
            }
        });
        this.location2Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/flashlist/place.png")));
        Mnemonics.setLocalizedText((JLabel)this.location2Label, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.location2Label.text"));
        this.location2ComboBox1.setModel(new DefaultComboBoxModel<String>(this.placeBits));
        this.location2ComboBox1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.location2ComboBox1FocusGained(evt);
            }
        });
        this.location2ComboBox2.setModel(new DefaultComboBoxModel<String>(this.placeBitsFull));
        this.location2ComboBox2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.location2ComboBox2FocusGained(evt);
            }
        });
        this.filterKey2TextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.filterKey2TextFieldFocusGained(evt);
            }
        });
        this.location3Label.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/flashlist/name.png")));
        Mnemonics.setLocalizedText((JLabel)this.location3Label, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.location3Label.text"));
        this.location3ComboBox1.setModel(new DefaultComboBoxModel<String>(this.placeBits));
        this.location3ComboBox1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.location3ComboBox1FocusGained(evt);
            }
        });
        this.location3ComboBox2.setModel(new DefaultComboBoxModel<String>(this.placeBitsFull));
        this.location3ComboBox2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.location3ComboBox2FocusGained(evt);
            }
        });
        this.filterKey3TextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FlashListPanel.this.filterKey3TextFieldFocusGained(evt);
            }
        });
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/flashlist/MoveUp.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.upButton.text"));
        this.upButton.setToolTipText(NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.upButton.toolTipText"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlashListPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/flashlist/MoveDown.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.downButton.text"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlashListPanel.this.downButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.repeatKeysCheckBox, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.repeatKeysCheckBox.text"));
        GroupLayout sortingPanelLayout = new GroupLayout(this.sortingPanel);
        this.sortingPanel.setLayout(sortingPanelLayout);
        sortingPanelLayout.setHorizontalGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingPanelLayout.createSequentialGroup().addContainerGap().addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sortingLabel).addGroup(sortingPanelLayout.createSequentialGroup().addGap(9, 9, 9).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repeatKeysCheckBox).addGroup(sortingPanelLayout.createSequentialGroup().addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingPanelLayout.createSequentialGroup().addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.location2Label).addComponent(this.location3Label).addComponent(this.location1Label)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.location1ComboBox1, -2, -1, -2).addComponent(this.location2ComboBox1, -2, -1, -2).addComponent(this.location3ComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.location1ComboBox2, -2, -1, -2).addComponent(this.location2ComboBox2, -2, -1, -2).addComponent(this.location3ComboBox2, -2, -1, -2))).addComponent(this.sortingHeaderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterHeaderLabel, -1, 263, Short.MAX_VALUE).addComponent(this.filterKey1TextField).addComponent(this.filterKey2TextField).addComponent(this.filterKey3TextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.downButton, -1, -1, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE)))))).addGap(228, 228, 228)));
        sortingPanelLayout.setVerticalGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingPanelLayout.createSequentialGroup().addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sortingPanelLayout.createSequentialGroup().addGap(65, 65, 65).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addGroup(sortingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sortingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sortingHeaderLabel).addComponent(this.filterHeaderLabel)).addGap(4, 4, 4).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.location1ComboBox1, -2, -1, -2).addComponent(this.location1ComboBox2, -2, -1, -2).addComponent(this.filterKey1TextField, -2, -1, -2).addComponent(this.location1Label)).addGap(4, 4, 4).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.location2ComboBox1, -2, -1, -2).addComponent(this.location2ComboBox2, -2, -1, -2).addComponent(this.filterKey2TextField, -2, -1, -2).addComponent(this.location2Label)).addGap(4, 4, 4).addGroup(sortingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterKey3TextField, -2, -1, -2).addComponent(this.location3Label).addComponent(this.location3ComboBox1, -2, -1, -2).addComponent(this.location3ComboBox2, -2, -1, -2)))).addGap(18, 18, 18).addComponent(this.repeatKeysCheckBox).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.sortingPanel.TabConstraints.tabTitle"), this.sortingPanel);
        this.formattingPanel.setPreferredSize(new Dimension(600, 250));
        this.structureLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.structureLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.structureLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addTOCCheckBox, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.addTOCCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.repeatHeaderCheckBox, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.repeatHeaderCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.displayLegendLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.displayLegendLabel.text"));
        this.boldLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.boldLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.boldLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.yearSpanLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.yearSpanLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.nbEventsLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.nbEventsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.minSosaLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.minSosaLabel.text"));
        this.zerosLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.zerosLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.zerosLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.displayZerosCheckBox, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.displayZerosCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.selectLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.selectLabel.text"));
        this.selectIndiPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.fontNameLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.fontNameLabel.text"));
        this.fontNameComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.fontSizeLabel, (String)NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.fontSizeLabel.text"));
        this.fontSizeSpinner.setModel(new SpinnerNumberModel(10, 5, 20, 1));
        GroupLayout formattingPanelLayout = new GroupLayout(this.formattingPanel);
        this.formattingPanel.setLayout(formattingPanelLayout);
        formattingPanelLayout.setHorizontalGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(formattingPanelLayout.createSequentialGroup().addContainerGap().addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayZerosCheckBox, GroupLayout.Alignment.TRAILING, -1, 325, Short.MAX_VALUE).addGroup(formattingPanelLayout.createSequentialGroup().addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.structureLabel).addGroup(formattingPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repeatHeaderCheckBox).addComponent(this.addTOCCheckBox).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, formattingPanelLayout.createSequentialGroup().addComponent(this.fontNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontNameComboBox, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, formattingPanelLayout.createSequentialGroup().addComponent(this.displayLegendLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayLegendComboBox, -2, 116, -2))).addGroup(formattingPanelLayout.createSequentialGroup().addComponent(this.fontSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontSizeSpinner, -2, 56, -2)))).addComponent(this.zerosLabel)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectIndiPanel, -1, -1, Short.MAX_VALUE).addGroup(formattingPanelLayout.createSequentialGroup().addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.boldLabel).addGroup(formattingPanelLayout.createSequentialGroup().addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nbEventsLabel).addComponent(this.minSosaLabel, -2, 199, -2).addComponent(this.yearSpanLabel, -2, 199, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.nbEventsFormattedTextField, GroupLayout.Alignment.LEADING, -2, 83, -2).addComponent(this.yearSpanFormattedTextField, GroupLayout.Alignment.LEADING, -2, 83, -2).addComponent(this.minSosaFormattedTextField, -2, 83, -2))).addComponent(this.selectLabel)).addGap(0, 78, Short.MAX_VALUE))).addGap(16, 16, 16)));
        formattingPanelLayout.setVerticalGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(formattingPanelLayout.createSequentialGroup().addContainerGap().addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.boldLabel).addComponent(this.structureLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yearSpanLabel).addComponent(this.yearSpanFormattedTextField, -2, -1, -2).addComponent(this.addTOCCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repeatHeaderCheckBox).addComponent(this.nbEventsLabel).addComponent(this.nbEventsFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayLegendLabel).addComponent(this.displayLegendComboBox, -2, -1, -2).addComponent(this.minSosaLabel).addComponent(this.minSosaFormattedTextField, -2, -1, -2)).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(formattingPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectIndiPanel, -1, -1, Short.MAX_VALUE)).addGroup(formattingPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontNameLabel).addComponent(this.fontNameComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(formattingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontSizeLabel).addComponent(this.fontSizeSpinner, -2, 30, -2)).addGap(18, 18, 18).addComponent(this.zerosLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayZerosCheckBox).addGap(0, 17, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FlashListPanel.class, (String)"FlashListPanel.formattingPanel.TabConstraints.tabTitle"), this.formattingPanel);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 725, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 316, Short.MAX_VALUE));
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.swapRows(this.selectedRow, this.selectedRow - 1);
        --this.selectedRow;
        this.setRows();
        this.selectRow(this.selectedRow);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.swapRows(this.selectedRow, this.selectedRow + 1);
        ++this.selectedRow;
        this.setRows();
        this.selectRow(this.selectedRow);
    }

    private void filterKey1TextFieldFocusGained(FocusEvent evt) {
        this.selectRow(0);
    }

    private void filterKey2TextFieldFocusGained(FocusEvent evt) {
        this.selectRow(1);
    }

    private void filterKey3TextFieldFocusGained(FocusEvent evt) {
        this.selectRow(2);
    }

    private void location1ComboBox1FocusGained(FocusEvent evt) {
        this.selectRow(0);
    }

    private void location1ComboBox2FocusGained(FocusEvent evt) {
        this.selectRow(0);
    }

    private void location2ComboBox1FocusGained(FocusEvent evt) {
        this.selectRow(1);
    }

    private void location2ComboBox2FocusGained(FocusEvent evt) {
        this.selectRow(1);
    }

    private void location3ComboBox1FocusGained(FocusEvent evt) {
        this.selectRow(2);
    }

    private void location3ComboBox2FocusGained(FocusEvent evt) {
        this.selectRow(2);
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void load() {
        this.repeatKeysCheckBox.setSelected(this.getRepeatKeys());
        this.initRows();
        for (int r = 0; r < 3; ++r) {
            this.rows[r].isLocVisible = this.registry.get("row-isLocVisible" + r, this.rows[r].isLocVisible);
            this.rows[r].loc1 = this.registry.get("row-loc1" + r, this.rows[r].loc1);
            this.rows[r].loc2 = this.registry.get("row-loc2" + r, this.rows[r].loc2);
            this.rows[r].filter = this.registry.get("row-filter" + r, this.rows[r].filter);
        }
        this.addTOCCheckBox.setSelected(this.getTOC());
        this.displayLegendComboBox.setSelectedIndex(this.getDisplayLegend());
        this.repeatHeaderCheckBox.setSelected(this.getRepeatHeader());
        this.displayZerosCheckBox.setSelected(this.getDisplayZeros());
        this.filterKey1TextField.setText(this.getFilter1());
        this.filterKey2TextField.setText(this.getFilter2());
        this.filterKey3TextField.setText(this.getFilter3());
        this.nbEventsFormattedTextField.setValue("" + this.getNbEvents());
        this.yearSpanFormattedTextField.setValue("" + this.getYearSpan());
        this.minSosaFormattedTextField.setValue("" + this.getMinSosa());
        this.fontNameComboBox.setSelectedItem(this.getFontName());
        this.fontSizeSpinner.setValue(Integer.valueOf(this.getFontSize()));
    }

    public boolean getTOC() {
        return this.registry.get("flashlist.addTOCCheckBox", true);
    }

    public boolean getRepeatKeys() {
        return this.registry.get("flashlist.repeatKeysCheckBox", false);
    }

    public int getDisplayLegend() {
        return this.registry.get("flashlist.displayLegendComboBox", 2);
    }

    public boolean getRepeatHeader() {
        return this.registry.get("flashlist.repeatHeaderCheckBox", true);
    }

    public boolean getDisplayZeros() {
        return this.registry.get("flashlist.displayZerosCheckBox", false);
    }

    public int getNbEvents() {
        return this.registry.get("flashlist.nbEventsFormattedTextField", 3);
    }

    public int getYearSpan() {
        return this.registry.get("flashlist.yearSpanFormattedTextField", 50);
    }

    public int getMinSosa() {
        return this.registry.get("flashlist.minSosaFormattedTextField", 1);
    }

    public String getFilter1() {
        return this.registry.get("flashlist.filterKey1TextField", "");
    }

    public String getFilter2() {
        return this.registry.get("flashlist.filterKey2TextField", "");
    }

    public String getFilter3() {
        return this.registry.get("flashlist.filterKey3TextField", "");
    }

    public String getFontName() {
        return this.registry.get("flashlist.fontname", this.fonts[0]);
    }

    public String getFontSize() {
        return this.registry.get("flashlist.fontsize", "10");
    }

    public boolean existPlaceTag() {
        return this.existPlaceTag;
    }

    public Indi getRootIndi() {
        return (Indi)this.selectEntityWidget.getSelection();
    }

    public int getRecordKey() {
        int surn = 0;
        for (int r = 0; r < 3; ++r) {
            if (this.rows[r].isLocVisible) continue;
            surn = r;
            break;
        }
        if (surn == 0) {
            return 2;
        }
        if (surn == 1) {
            return 0;
        }
        if (surn == 2) {
            return 1;
        }
        return 0;
    }

    public int getPosLoc(int i) {
        int ret = -1;
        int rk = this.getRecordKey();
        switch (i) {
            case 1: {
                if (rk != 2) {
                    ret = this.location1ComboBox1.getSelectedIndex();
                    break;
                }
                ret = this.location2ComboBox1.getSelectedIndex();
                break;
            }
            case 2: {
                if (rk != 2) {
                    ret = this.location1ComboBox2.getSelectedIndex() - 1;
                    break;
                }
                ret = this.location2ComboBox2.getSelectedIndex() - 1;
                break;
            }
            case 3: {
                if (rk != 1) {
                    ret = this.location3ComboBox1.getSelectedIndex();
                    break;
                }
                ret = this.location2ComboBox1.getSelectedIndex();
                break;
            }
            case 4: {
                ret = rk != 1 ? this.location3ComboBox2.getSelectedIndex() - 1 : this.location2ComboBox2.getSelectedIndex() - 1;
            }
        }
        return ret;
    }

    public void store() {
        this.registry.put("flashlist.repeatKeysCheckBox", Boolean.valueOf(this.repeatKeysCheckBox.isSelected()));
        this.getRows();
        for (int r = 0; r < 3; ++r) {
            this.registry.put("flashlist.row-isLocVisible" + r, Boolean.valueOf(this.rows[r].isLocVisible));
            this.registry.put("flashlist.row-loc1" + r, this.rows[r].loc1);
            this.registry.put("flashlist.row-loc2" + r, this.rows[r].loc2);
            this.registry.put("flashlist.row-filter" + r, this.rows[r].filter);
        }
        this.registry.put("flashlist.displayLegendComboBox", this.displayLegendComboBox.getSelectedIndex());
        this.registry.put("flashlist.filterKey1TextField", this.filterKey1TextField.getText());
        this.registry.put("flashlist.filterKey2TextField", this.filterKey2TextField.getText());
        this.registry.put("flashlist.filterKey3TextField", this.filterKey3TextField.getText());
        this.registry.put("flashlist.yearSpanFormattedTextField", this.yearSpanFormattedTextField.getText());
        this.registry.put("flashlist.nbEventsFormattedTextField", this.nbEventsFormattedTextField.getText());
        this.registry.put("flashlist.minSosaFormattedTextField", this.minSosaFormattedTextField.getText());
        this.registry.put("flashlist.repeatHeaderCheckBox", Boolean.valueOf(this.repeatHeaderCheckBox.isSelected()));
        this.registry.put("flashlist.displayZerosCheckBox", Boolean.valueOf(this.displayZerosCheckBox.isSelected()));
        this.registry.put("flashlist.addTOCCheckBox", Boolean.valueOf(this.addTOCCheckBox.isSelected()));
        this.registry.put("flashlist.fontname", this.fontNameComboBox.getSelectedItem().toString());
        this.registry.put("flashlist.fontsize", String.valueOf(this.fontSizeSpinner.getValue()));
    }

    private String[] initDisplayLegendComboBox() {
        ArrayList<String> comboBoxText = new ArrayList<String>(this.legends.length);
        for (String value : this.legends) {
            comboBoxText.add(NbBundle.getMessage(ReportFlashList.class, (String)value));
        }
        return (String[])comboBoxText.toArray(String[]::new);
    }

    private void initRows() {
        this.selectedRow = 0;
        this.rows = new SortRow[3];
        this.rows[0] = new SortRow();
        this.rows[0].isLocVisible = true;
        this.rows[0].loc1 = this.country;
        this.rows[0].loc2 = "";
        this.rows[0].filter = "";
        this.rows[1] = new SortRow();
        this.rows[1].isLocVisible = true;
        this.rows[1].loc1 = this.city;
        this.rows[1].loc2 = "";
        this.rows[1].filter = "";
        this.rows[2] = new SortRow();
        this.rows[2].isLocVisible = false;
        this.rows[2].loc1 = this.city;
        this.rows[2].loc2 = "";
        this.rows[2].filter = "";
    }

    private void selectRow(int i) {
        this.selectedRow = i;
        this.location1Label.setForeground(UNSELECTED_COLOR);
        this.location2Label.setForeground(UNSELECTED_COLOR);
        this.location3Label.setForeground(UNSELECTED_COLOR);
        switch (i) {
            case 0: {
                this.location1Label.setForeground(SELECTED_COLOR);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(true);
                break;
            }
            case 1: {
                this.location2Label.setForeground(SELECTED_COLOR);
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
                break;
            }
            default: {
                this.location3Label.setForeground(SELECTED_COLOR);
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(false);
            }
        }
    }

    private void swapRows(int fromRow, int toRow) {
        this.getRows();
        SortRow tmpRow = new SortRow();
        tmpRow.set(this.rows[toRow]);
        this.rows[toRow].set(this.rows[fromRow]);
        this.rows[fromRow].set(tmpRow);
    }

    private void setRows() {
        this.location1Label.setIcon(this.getIcon(this.rows[0].isLocVisible));
        this.location1Label.setText(this.getLabel(this.rows[0].isLocVisible));
        this.location1ComboBox1.setVisible(this.rows[0].isLocVisible && this.existPlaceTag);
        this.location1ComboBox1.setSelectedItem(this.rows[0].loc1);
        this.location1ComboBox2.setVisible(this.rows[0].isLocVisible && this.existPlaceTag);
        this.location1ComboBox2.setSelectedItem(this.rows[0].loc2);
        this.filterKey1TextField.setText(this.rows[0].filter);
        this.location2Label.setIcon(this.getIcon(this.rows[1].isLocVisible));
        this.location2Label.setText(this.getLabel(this.rows[1].isLocVisible));
        this.location2ComboBox1.setVisible(this.rows[1].isLocVisible && this.existPlaceTag);
        this.location2ComboBox1.setSelectedItem(this.rows[1].loc1);
        this.location2ComboBox2.setVisible(this.rows[1].isLocVisible && this.existPlaceTag);
        this.location2ComboBox2.setSelectedItem(this.rows[1].loc2);
        this.filterKey2TextField.setText(this.rows[1].filter);
        this.location3Label.setIcon(this.getIcon(this.rows[2].isLocVisible));
        this.location3Label.setText(this.getLabel(this.rows[2].isLocVisible));
        this.location3ComboBox1.setVisible(this.rows[2].isLocVisible && this.existPlaceTag);
        this.location3ComboBox1.setSelectedItem(this.rows[2].loc1);
        this.location3ComboBox2.setVisible(this.rows[2].isLocVisible && this.existPlaceTag);
        this.location3ComboBox2.setSelectedItem(this.rows[2].loc2);
        this.filterKey3TextField.setText(this.rows[2].filter);
    }

    private void getRows() {
        this.rows[0].loc1 = this.location1ComboBox1.getSelectedItem().toString();
        this.rows[0].loc2 = this.location1ComboBox2.getSelectedItem().toString();
        this.rows[0].filter = this.filterKey1TextField.getText();
        this.rows[1].loc1 = this.location2ComboBox1.getSelectedItem().toString();
        this.rows[1].loc2 = this.location2ComboBox2.getSelectedItem().toString();
        this.rows[1].filter = this.filterKey2TextField.getText();
        this.rows[2].loc1 = this.location3ComboBox1.getSelectedItem().toString();
        this.rows[2].loc2 = this.location3ComboBox2.getSelectedItem().toString();
        this.rows[2].filter = this.filterKey3TextField.getText();
    }

    private Icon getIcon(boolean flag) {
        return flag ? GEO_ICON : NAME_ICON;
    }

    private String getLabel(boolean flag) {
        return flag ? GEO_LABEL : NAME_LABEL;
    }

    private void initContextIndi(Gedcom gedcom) {
        Entity entity;
        this.selectEntityWidget = new SelectEntityWidget(gedcom, "INDI", null, gedcom.getIndis().size() < 5000);
        this.selectIndiPanel.add((Component)this.selectEntityWidget);
        Indi selectedIndividual = null;
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        Entity entity2 = entity = context != null ? context.getEntity() : null;
        if (entity != null) {
            if (entity instanceof Indi) {
                Indi indi;
                selectedIndividual = indi = (Indi)entity;
            } else if (entity instanceof Fam) {
                Fam fam = (Fam)entity;
                Indi husb = fam.getHusband();
                Indi wife = fam.getWife();
                if (husb != null) {
                    selectedIndividual = husb;
                } else if (wife != null) {
                    selectedIndividual = wife;
                }
            }
        } else {
            selectedIndividual = (Indi)gedcom.getIndis().iterator().next();
        }
        this.selectEntityWidget.setSelection((Entity)selectedIndividual);
    }

    private class SortRow {
        public boolean isLocVisible = true;
        public String loc1 = "";
        public String loc2 = "";
        public String filter = "";

        private SortRow() {
        }

        private void set(SortRow setRow) {
            this.isLocVisible = setRow.isLocVisible;
            this.loc1 = setRow.loc1;
            this.loc2 = setRow.loc2;
            this.filter = setRow.filter;
        }
    }
}

