/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportGeneanet
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgeneanet_name();
    }

    protected String getImportComment() {
        return Bundle.importgeneanet_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        ret |= this.fixMediaName(gedcom);
        this.incrementProgress();
        this.incrementProgress();
        return ret |= this.removeDoubleAssociations(gedcom);
    }

    private boolean removeDoubleAssociations(Gedcom gedcom) {
        boolean fixed = false;
        ArrayList list = new ArrayList();
        gedcom.getIndis().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        HashMap<CallSite, PropertyAssociation> mapL = new HashMap<CallSite, PropertyAssociation>();
        for (Property prop : list) {
            if (prop instanceof PropertyAssociation) {
                String destination;
                PropertyAssociation pa = (PropertyAssociation)prop;
                String origine = pa.getEntity().getId();
                String key = origine + " -;- " + (destination = pa.getTargetEntity().isPresent() ? "" : ((Entity)pa.getTargetEntity().get()).getId());
                if (mapL.containsKey(key)) {
                    PropertyAssociation po = (PropertyAssociation)mapL.get(key);
                    Property relaO = po.getProperty("RELA", false);
                    if (!relaO.getValue().contains("@")) {
                        Entity ent = po.getEntity();
                        this.fixes.add(new ImportFix(ent.getId(), "duplicateAssociations.1", po.getPath(true).getShortName(), "", po.getValue(), ""));
                        fixed = true;
                        ent.delProperty((Property)po);
                        mapL.remove(key);
                        mapL.put((CallSite)((Object)key), pa);
                        continue;
                    }
                    Property relaA = pa.getProperty("RELA", false);
                    if (relaA.getValue().contains("@")) continue;
                    Entity ent = pa.getEntity();
                    this.fixes.add(new ImportFix(ent.getId(), "duplicateAssociations.1", pa.getPath(true).getShortName(), "", pa.getValue(), ""));
                    fixed = true;
                    ent.delProperty((Property)pa);
                    continue;
                }
                mapL.put((CallSite)((Object)key), pa);
                continue;
            }
            LOG.log(Level.WARNING, "The following association property is not of type PropertyAssociation: {0}", prop);
        }
        return fixed;
    }

    private boolean fixMediaName(Gedcom gedcom) {
        boolean hasErrors = false;
        List fileList = gedcom.getPropertiesByClass(PropertyFile.class);
        for (PropertyFile file : fileList) {
            String valeur;
            String oldValue = valeur = file.getValue();
            if (!valeur.startsWith("http://gw.geneanet.org")) continue;
            if ((valeur = valeur.replace("http://", "https://")).indexOf("medium") > 0) {
                valeur = valeur.replace("medium", "normal");
            }
            file.setValue(valeur);
            this.fixes.add(new ImportFix(file.getEntity().getId(), "textformatting.3", file.getPath().getShortName(), "", oldValue, valeur));
        }
        return hasErrors;
    }

    public boolean fixPlaces(Gedcom gedcom) {
        boolean hasErrors = false;
        Pattern pattern = Pattern.compile("^\\[(?<lieudit>.*)\\] -");
        List placeList = gedcom.getPropertiesByClass(PropertyPlace.class);
        for (PropertyPlace place : placeList) {
            String valeur;
            String oldValue = valeur = place.getValue();
            Matcher matcher = pattern.matcher(valeur);
            if (!matcher.find()) continue;
            String lieuDit = matcher.group("lieudit");
            String newValue = matcher.replaceFirst(lieuDit + ",");
            place.setValue(newValue);
            this.fixes.add(new ImportFix(place.getEntity().getId(), "invalidPlace.3", place.getPath().getShortName(), "", oldValue, newValue));
        }
        return hasErrors |= super.fixPlaces(gedcom);
    }
}

