/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;

public class WebDays
extends WebSection {
    public WebDays(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Dayslist"), "days", "days", "", 1, 0);
    }

    @Override
    public void create() {
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        File file = this.wh.getFileForName(dir, this.sectionPrefix + this.sectionSuffix);
        try (PrintWriter out = this.wh.getWriter(file, this.UTF8);){
            this.printOpenHTML(out, "TXT_Dayslist", this);
            this.printHomeLink(out, this);
            this.exportData(dir, out);
            this.printCloseHTML(out);
        }
        this.wh.log.write(this.sectionPrefix + this.sectionSuffix + this.trs("EXEC_DONE"));
    }

    private void exportData(File dir, PrintWriter out) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMdd");
        Calendar calStart = Calendar.getInstance();
        calStart.set(2008, 0, 1);
        Calendar calEnd = Calendar.getInstance();
        calEnd.set(2009, 0, 1);
        Iterator<String> it = this.wh.getDays(this.wh.gedcom).iterator();
        String lastMonth = "";
        int cpt = 1;
        int iDays = 1;
        int cptm = 0;
        out.println("<div class=\"daycal\">");
        String dateIt = "";
        if (it.hasNext()) {
            dateIt = it.next();
        }
        while (calStart.compareTo(calEnd) < 0) {
            String date = sdf.format(calStart.getTime());
            String month = this.trs(this.Months[Integer.valueOf(date.substring(0, 2)) - 1]);
            String day = date.substring(2, 4);
            if (month.compareTo(lastMonth) != 0) {
                if (cptm > 0) {
                    out.println("</tr></table>");
                    out.println("</div>");
                }
                if (cptm > 0 && cptm / 3 * 3 == cptm) {
                    out.println("<div class=\"spacer\">&nbsp;</div>");
                    out.println("</div><div class=\"daycal\">");
                }
                out.println("<div class=\"daycal1\">");
                out.println("<table class=\"daytbl\">");
                out.println("<tr><td colspan=\"7\"><span class=\"daychar\"><a id=\"" + this.Months[Integer.valueOf(date.substring(0, 2)) - 1] + "\"></a>" + month + "</span></td></tr><tr>");
                lastMonth = month;
                ++cptm;
                cpt = 1;
            }
            String anchor = this.htmlAnchorText(month) + day;
            String listfile = this.buildLink(this, this.wb.sectionDaysDetails, iDays);
            out.print("<td>");
            if (date.compareTo(dateIt) == 0) {
                out.print("<a href=\"" + listfile + "#" + anchor + "\">" + day + "</a>&nbsp;");
                out.print("<span class=\"dayo\">(" + this.wh.getDaysCount(date) + ")</span>");
                ++iDays;
                if (it.hasNext()) {
                    dateIt = it.next();
                }
            } else {
                out.print(day + "&nbsp;");
            }
            out.print("</td>");
            if (++cpt > 7) {
                out.print("</tr><tr>");
                cpt = 1;
            }
            calStart.add(5, 1);
        }
        out.println("</tr></table>");
        out.println("</div></div>");
    }
}

