/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.removetag;

import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

public class RemoveTagPanel
extends JPanel {
    private Gedcom gedcom = null;
    private Registry registry = null;
    private final Settings settings = new Settings();
    private JComponent[] entityTypeLabels = null;
    private JComponent[] entityTypeCheckBoxes = null;
    private String[] entTags = null;
    private Map<String, Integer> propertiesMap;
    private boolean isBusy = false;
    private boolean pathUpdated = false;
    private ButtonGroup bgValue;
    private JLabel introLabel;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBoxAllCat;
    private JCheckBox jCheckBoxAsserted;
    private JCheckBox jCheckBoxEmpty;
    private JCheckBox jCheckBoxExact;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelEmpty;
    private JRadioButton jRadioButtonDeleteAll;
    private JRadioButton jRadioButtonValues;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextFieldValue;
    private JLabel selectedEntityLabel;
    private JLabel specifiValueLabel;
    private JLabel tagLabel;
    private JLabel tagListLabel;
    private JTextField tagTextField;
    private JLabel tagValuesLabel;
    private JList<Property> tagValuesList;
    private JList<String> tagsList;

    public RemoveTagPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.registry = gedcom.getRegistry();
        this.entTags = gedcom.isGrammar7() ? GedcomConstants.ENTITIES_7 : GedcomConstants.ENTITIES_5;
        this.initComponents();
        this.entityTypeLabels = new JComponent[]{this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel6, this.jLabel7};
        this.entityTypeCheckBoxes = new JComponent[]{this.jCheckBox1, this.jCheckBox2, this.jCheckBox3, this.jCheckBox4, this.jCheckBox5, this.jCheckBox6, this.jCheckBox7, this.jCheckBoxAllCat};
        for (int i = 0; i < this.entTags.length; ++i) {
            ((JLabel)this.entityTypeLabels[i]).setIcon((Icon)GedcomConstants.getEntityImage((String)this.entTags[i]));
            ((JLabel)this.entityTypeLabels[i]).setText(Gedcom.getName((String)this.entTags[i]));
        }
        if (this.tagsList.getModel().getSize() > 0) {
            this.tagsList.setSelectedIndex(0);
        }
        ValueFieldListener listener = new ValueFieldListener();
        this.tagTextField.getDocument().addDocumentListener(listener);
        this.jTextFieldValue.getDocument().addDocumentListener(listener);
        this.loadPreferences();
        this.manageValuesFields();
    }

    private void initComponents() {
        this.bgValue = new ButtonGroup();
        this.introLabel = new JLabel();
        this.tagListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tagsList = new JList<String>(this.getTagsList());
        this.selectedEntityLabel = new JLabel();
        this.jCheckBoxAllCat = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jCheckBox3 = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jCheckBox4 = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jCheckBox5 = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jCheckBox6 = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jCheckBox7 = new JCheckBox();
        this.jLabelEmpty = new JLabel();
        this.tagValuesLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tagValuesList = new JList();
        this.tagLabel = new JLabel();
        this.tagTextField = new JTextField();
        this.jLabel10 = new JLabel();
        this.jRadioButtonDeleteAll = new JRadioButton();
        this.jRadioButtonValues = new JRadioButton();
        this.jCheckBoxEmpty = new JCheckBox();
        this.jCheckBoxAsserted = new JCheckBox();
        this.specifiValueLabel = new JLabel();
        this.jTextFieldValue = new JTextField();
        this.jCheckBoxExact = new JCheckBox();
        this.setMinimumSize(new Dimension(481, 368));
        this.setName("");
        this.introLabel.setFont(this.introLabel.getFont().deriveFont(this.introLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.introLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.introLabel.text"));
        this.tagListLabel.setFont(this.tagListLabel.getFont().deriveFont(this.tagListLabel.getFont().getStyle() | 1));
        this.tagListLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagListLabel.text"));
        this.tagsList.setSelectionMode(0);
        this.tagsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RemoveTagPanel.this.tagsListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tagsList);
        this.selectedEntityLabel.setFont(this.selectedEntityLabel.getFont().deriveFont(this.selectedEntityLabel.getFont().getStyle() | 1));
        this.selectedEntityLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.selectedEntityLabel.text"));
        this.jCheckBoxAllCat.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxAllCat.text"));
        this.jCheckBoxAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxAllCatActionPerformed(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel1.text"));
        this.jCheckBox1.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBox1.text"));
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel2.text"));
        this.jCheckBox2.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBox2.text"));
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jLabel3.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel3.text"));
        this.jCheckBox3.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBox3.text"));
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.jLabel4.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel4.text"));
        this.jCheckBox4.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBox4.text"));
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.jLabel5.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel5.text"));
        this.jCheckBox5.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBox5.text"));
        this.jCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBox5ActionPerformed(evt);
            }
        });
        this.jLabel6.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel6.text"));
        this.jCheckBox6.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBox6.text"));
        this.jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBox6ActionPerformed(evt);
            }
        });
        this.jLabel7.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel7.text"));
        this.jCheckBox7.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBox7.text"));
        this.jCheckBox7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBox7ActionPerformed(evt);
            }
        });
        this.jLabelEmpty.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabelEmpty.text"));
        this.tagValuesLabel.setFont(this.tagValuesLabel.getFont().deriveFont(this.tagValuesLabel.getFont().getStyle() | 1));
        this.tagValuesLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagValuesLabel.text"));
        this.tagValuesList.setSelectionMode(0);
        this.tagValuesList.setToolTipText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagValuesList.toolTipText"));
        this.tagValuesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RemoveTagPanel.this.tagValuesListMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tagValuesList);
        this.tagLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagLabel.text"));
        this.tagTextField.setToolTipText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagTextField.toolTipText"));
        this.jLabel10.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jLabel10.text"));
        this.bgValue.add(this.jRadioButtonDeleteAll);
        this.jRadioButtonDeleteAll.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jRadioButtonDeleteAll.text"));
        this.jRadioButtonDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jRadioButtonDeleteAllActionPerformed(evt);
            }
        });
        this.bgValue.add(this.jRadioButtonValues);
        this.jRadioButtonValues.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jRadioButtonValues.text"));
        this.jRadioButtonValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jRadioButtonValuesActionPerformed(evt);
            }
        });
        this.jCheckBoxEmpty.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxEmpty.text"));
        this.jCheckBoxEmpty.setHorizontalTextPosition(2);
        this.jCheckBoxEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxEmptyActionPerformed(evt);
            }
        });
        this.jCheckBoxAsserted.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxAsserted.text"));
        this.jCheckBoxAsserted.setHorizontalTextPosition(2);
        this.jCheckBoxAsserted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxAssertedActionPerformed(evt);
            }
        });
        this.specifiValueLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.specifiValueLabel.text"));
        this.jTextFieldValue.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RemoveTagPanel.this.jTextFieldValuePropertyChange(evt);
            }
        });
        this.jCheckBoxExact.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxExact.text"));
        this.jCheckBoxExact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxExactActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tagListLabel).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 236, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedEntityLabel).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAllCat).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox4).addComponent(this.jCheckBox3).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2).addComponent(this.jCheckBox7).addComponent(this.jCheckBox6).addComponent(this.jCheckBox5))).addComponent(this.jLabelEmpty)))))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tagValuesLabel).addGap(0, 129, Short.MAX_VALUE)).addComponent(this.jScrollPane2))).addGroup(layout.createSequentialGroup().addComponent(this.tagLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tagTextField)).addComponent(this.introLabel).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonDeleteAll).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxEmpty).addComponent(this.jCheckBoxAsserted).addGroup(layout.createSequentialGroup().addComponent(this.specifiValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxExact)))).addComponent(this.jRadioButtonValues)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.introLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jScrollPane2)).addGroup(layout.createSequentialGroup().addComponent(this.tagListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectedEntityLabel).addComponent(this.tagValuesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAllCat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jCheckBox2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jCheckBox3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jCheckBox4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jCheckBox5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jCheckBox6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jCheckBox7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelEmpty).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagLabel).addComponent(this.tagTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jRadioButtonDeleteAll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonValues).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxEmpty).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAsserted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.specifiValueLabel).addComponent(this.jTextFieldValue, -2, -1, -2).addComponent(this.jCheckBoxExact)).addGap(25, 25, 25)));
    }

    private void jCheckBoxAllCatActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.entTags.length; ++i) {
            ((JCheckBox)this.entityTypeCheckBoxes[i]).setSelected(this.jCheckBoxAllCat.isSelected());
        }
        this.updateValuesList();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBox7ActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBox6ActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBox5ActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void tagsListValueChanged(ListSelectionEvent evt) {
        if (!this.pathUpdated && this.tagsList.getSelectedValue() != null) {
            this.tagTextField.setText(this.tagsList.getSelectedValue().split(" ")[0]);
        }
        this.updateValuesList();
    }

    private void tagValuesListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selectProperty();
        }
    }

    private void jCheckBoxEmptyActionPerformed(ActionEvent evt) {
        this.updateValuesList();
    }

    private void jRadioButtonValuesActionPerformed(ActionEvent evt) {
        this.manageValuesFields();
    }

    private void jRadioButtonDeleteAllActionPerformed(ActionEvent evt) {
        this.manageValuesFields();
    }

    private void jCheckBoxAssertedActionPerformed(ActionEvent evt) {
        this.updateValuesList();
    }

    private void jTextFieldValuePropertyChange(PropertyChangeEvent evt) {
        this.updateValuesList();
    }

    private void jCheckBoxExactActionPerformed(ActionEvent evt) {
        this.updateValuesList();
    }

    private void checkAllCat() {
        boolean all = true;
        for (int i = 0; i < this.entTags.length; ++i) {
            all &= ((JCheckBox)this.entityTypeCheckBoxes[i]).isSelected();
        }
        this.jCheckBoxAllCat.setSelected(all);
        this.updateValuesList();
    }

    private void manageValuesFields() {
        if (this.jRadioButtonDeleteAll.isSelected()) {
            this.specifiValueLabel.setEnabled(false);
            this.jCheckBoxEmpty.setEnabled(false);
            this.jCheckBoxAsserted.setEnabled(false);
            this.jTextFieldValue.setEnabled(false);
            this.jCheckBoxExact.setEnabled(false);
        }
        if (this.jRadioButtonValues.isSelected()) {
            this.specifiValueLabel.setEnabled(true);
            this.jCheckBoxEmpty.setEnabled(true);
            this.jCheckBoxAsserted.setEnabled(true);
            this.jTextFieldValue.setEnabled(true);
            this.jCheckBoxExact.setEnabled(true);
        }
        this.updateValuesList();
    }

    private void loadPreferences() {
        this.tagTextField.setText(this.registry.get("DeleteTagName", "_XXXX"));
        for (int i = 0; i < this.entTags.length + 1; ++i) {
            ((JCheckBox)this.entityTypeCheckBoxes[i]).setSelected(this.registry.get("DeleteTagCategory" + i, i == 0));
        }
        this.jCheckBoxEmpty.setSelected(this.registry.get("DeleteTagEmptyOnly", false));
        this.jCheckBoxAsserted.setSelected(this.registry.get("DeleteAsserted", false));
        this.jRadioButtonDeleteAll.setSelected(this.registry.get("DeleteAll", true));
        if (!this.jRadioButtonDeleteAll.isSelected()) {
            this.jRadioButtonValues.setSelected(true);
        }
        this.jTextFieldValue.setText(this.registry.get("DeleteValue", ""));
        this.jCheckBoxExact.setSelected(this.registry.get("ExactValue", true));
    }

    public void savePreferences() {
        this.settings.tag = this.tagTextField.getText().trim().toUpperCase();
        this.registry.put("DeleteTagName", this.settings.tag);
        for (int i = 0; i < this.entTags.length + 1; ++i) {
            this.registry.put("DeleteTagCategory" + i, Boolean.valueOf(((JCheckBox)this.entityTypeCheckBoxes[i]).isSelected()));
            if (i >= this.entTags.length) continue;
            this.settings.entsTags[i] = ((JCheckBox)this.entityTypeCheckBoxes[i]).isSelected() ? this.entTags[i] : "";
        }
        this.settings.empty = this.jCheckBoxEmpty.isSelected();
        this.registry.put("DeleteTagEmptyOnly", Boolean.valueOf(this.settings.empty));
        this.settings.all = this.jRadioButtonDeleteAll.isSelected();
        this.registry.put("DeleteAll", Boolean.valueOf(this.settings.all));
        this.settings.asserted = this.jCheckBoxAsserted.isSelected();
        this.registry.put("DeleteAsserted", Boolean.valueOf(this.settings.asserted));
        this.settings.value = this.jTextFieldValue.getText();
        this.registry.put("DeleteValue", this.settings.value);
        this.settings.exact = this.jCheckBoxExact.isSelected();
        this.registry.put("ExactValue", Boolean.valueOf(this.settings.exact));
    }

    private String[] getTagsList() {
        ArrayList ret = new ArrayList();
        this.propertiesMap = new HashMap<String, Integer>();
        ArrayList properties = new ArrayList();
        for (Entity entity : this.gedcom.getEntities()) {
            properties.addAll(entity.getAllProperties(null));
        }
        for (Property prop : properties) {
            String tag = prop.getTag();
            Integer nb = this.propertiesMap.get(tag);
            if (nb == null) {
                nb = 0;
            }
            Integer n = nb;
            nb = nb + 1;
            this.propertiesMap.put(tag, nb);
        }
        this.propertiesMap.keySet().forEach(key -> ret.add(key + " (" + this.propertiesMap.get(key) + ")"));
        Collections.sort(ret);
        return (String[])ret.toArray(String[]::new);
    }

    private Property[] getTagValues() {
        String selectedTag;
        ArrayList ret = new ArrayList();
        String tagpathvalue = this.tagTextField.getText();
        if (this.pathUpdated && !tagpathvalue.isBlank()) {
            TagPath tagPath = new TagPath(tagpathvalue);
            for (int index = 0; index < this.tagsList.getModel().getSize(); ++index) {
                String tag = this.tagsList.getModel().getElementAt(index).split(" ")[0];
                if (!tag.equals(tagPath.getLast())) continue;
                this.tagsList.setSelectedIndex(index);
                this.tagsList.ensureIndexIsVisible(index);
                break;
            }
        }
        if ((selectedTag = this.tagsList.getSelectedValue()) != null && !selectedTag.isEmpty()) {
            selectedTag = selectedTag.split(" ")[0];
            int fullTotal = this.propertiesMap.get(selectedTag);
            int total = 0;
            for (int i = 0; i < this.entTags.length; ++i) {
                int subTotal = 0;
                for (Entity ent : this.gedcom.getEntities(this.entTags[i])) {
                    List c = ent.getAllProperties(selectedTag);
                    subTotal += c.size();
                    if (!((JCheckBox)this.entityTypeCheckBoxes[i]).isSelected()) continue;
                    ret.addAll(c);
                }
                ((JLabel)this.entityTypeLabels[i]).setText(Gedcom.getName((String)this.entTags[i]) + " (" + subTotal + ")");
                total += subTotal;
                fullTotal -= subTotal;
            }
            if (fullTotal > 0) {
                HashSet<String> hSet = new HashSet<String>(Arrays.asList(this.entTags));
                for (Entity ent : this.gedcom.getEntities()) {
                    if (hSet.contains(ent.getTag())) continue;
                    ret.addAll(ent.getAllProperties(selectedTag));
                    ++total;
                }
            }
            ((JCheckBox)this.entityTypeCheckBoxes[this.entTags.length]).setText(NbBundle.getMessage(this.getClass(), (String)"RemoveTagPanel.jCheckBoxAllCat.text") + " (" + total + ")");
        }
        if (!tagpathvalue.isBlank()) {
            Iterator i = ret.iterator();
            while (i.hasNext()) {
                Property p = (Property)i.next();
                if (p.getTag().equals(tagpathvalue) || p.getPath().toString().contains(tagpathvalue)) continue;
                i.remove();
            }
        }
        if (this.jRadioButtonValues.isSelected()) {
            Iterator i = ret.iterator();
            boolean removed = false;
            while (i.hasNext()) {
                Property p = (Property)i.next();
                if (this.jCheckBoxEmpty.isSelected() && (!p.getValue().isEmpty() || p.getNoOfProperties() > 0)) {
                    i.remove();
                    removed = true;
                }
                if (!removed && this.jCheckBoxAsserted.isSelected() && (p.getValue().isEmpty() || !p.getValue().equals("Y") || p.getNoOfProperties() > 0)) {
                    i.remove();
                    removed = true;
                }
                String value = this.jTextFieldValue.getText();
                if (!removed && !value.isBlank()) {
                    if (this.jCheckBoxExact.isSelected() && !p.toString().equals(value)) {
                        i.remove();
                    } else if (!this.jCheckBoxExact.isSelected() && !p.toString().contains(value)) {
                        i.remove();
                    }
                }
                removed = false;
            }
        }
        Collections.sort(ret, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        return (Property[])ret.toArray(Property[]::new);
    }

    private void updateValuesList() {
        if (this.isBusy) {
            return;
        }
        this.isBusy = true;
        DefaultListModel<Property> lm = new DefaultListModel<Property>();
        for (Property value : this.getTagValues()) {
            lm.addElement(value);
        }
        this.tagValuesList.setModel(lm);
        this.tagValuesLabel.setText(NbBundle.getMessage(this.getClass(), (String)"RemoveTagPanel.tagValuesLabel.text", (Object)lm.size()));
        this.isBusy = false;
        this.pathUpdated = false;
    }

    private void selectProperty() {
        Property selectedProperty;
        int index = this.tagValuesList.getSelectedIndex();
        if (index > -1 && (selectedProperty = this.tagValuesList.getModel().getElementAt(index)) != null) {
            this.jTextFieldValue.setText(selectedProperty.toString());
            SelectionDispatcher.fireSelection(null, (Context)new Context(selectedProperty));
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public static class Settings {
        public String tag = "";
        public String[] entsTags = new String[7];
        public boolean all = true;
        public boolean empty = false;
        public boolean asserted = false;
        public String value = "";
        public boolean exact = false;
    }

    private class ValueFieldListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent de) {
            RemoveTagPanel.this.pathUpdated = true;
            RemoveTagPanel.this.updateValuesList();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            RemoveTagPanel.this.pathUpdated = true;
            RemoveTagPanel.this.updateValuesList();
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            RemoveTagPanel.this.pathUpdated = true;
            RemoveTagPanel.this.updateValuesList();
        }
    }
}

