/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import ancestris.util.ProgressListener;
import genj.util.Trackable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Timer;
import org.netbeans.api.progress.ProgressHandle;

public class ProgressBar
implements ProgressListener {
    Map<Trackable, ProcessData> map = new HashMap<Trackable, ProcessData>();

    @Override
    public void processStarted(Trackable process) {
        Trackable track = process;
        ProcessData data = this.map.get(process);
        if (data == null) {
            data = new ProcessData();
            data.handle = ProgressHandle.createHandle((String)process.getTaskName(), () -> {
                track.cancelTrackable();
                return true;
            });
            this.map.put(process, data);
        }
        data.timer = new Timer(200, e -> {
            ProcessData data1 = this.map.get(track);
            if (data1 == null) {
                ((Timer)e.getSource()).stop();
                return;
            }
            try {
                data1.handle.setDisplayName(track.getTaskName());
                data1.handle.progress(track.getState(), track.getProgress());
            }
            catch (IllegalArgumentException ex) {
                data1.handle.progress(track.getState());
            }
        });
        data.handle.start(100);
        data.timer.start();
    }

    @Override
    public void processStopped(Trackable process) {
        ProcessData data = this.map.get(process);
        if (data == null) {
            return;
        }
        data.timer.stop();
        data.handle.finish();
        this.map.remove(process);
    }

    @Override
    public void processStopAll() {
        for (Trackable p : this.map.keySet()) {
            p.cancelTrackable();
            this.processStopped(p);
        }
    }

    private class ProcessData {
        public ProgressHandle handle;
        public Timer timer;

        private ProcessData() {
        }
    }
}

