/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.ImageIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Stack;

public class UnitGraphics {
    private Stack<AffineTransform> stackTransformations = new Stack();
    private Stack<Shape> clipStack = new Stack();
    private double unitx = 1.0;
    private double unity = 1.0;
    private Graphics2D graphics;
    private Line2D.Double line = new Line2D.Double();

    public UnitGraphics(Graphics g, double unitX, double unitY) {
        this.graphics = (Graphics2D)g;
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.pushTransformation();
        this.unitx = unitX;
        this.unity = unitY;
    }

    public Point2D getUnit() {
        return new Point2D.Double(this.unitx, this.unity);
    }

    public void setAntialiasing(boolean set) {
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, set ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void translate(double dx, double dy) {
        this.graphics.translate((int)(dx * this.unitx), (int)(dy * this.unity));
    }

    public void scale(double sx, double sy) {
        this.graphics.scale(sx * this.unitx, sy * this.unity);
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public Rectangle2D getClip() {
        Rectangle r = this.graphics.getClipBounds();
        return new Rectangle2D.Double(r.getMinX() / this.unitx, r.getMinY() / this.unity, r.getWidth() / this.unitx, r.getHeight() / this.unity);
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.graphics.setColor(color);
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.graphics.setFont(font);
        }
    }

    public void draw(double x1, double y1, double x2, double y2) {
        this.line.setLine(x1 * this.unitx, y1 * this.unity, x2 * this.unitx, y2 * this.unity);
        this.graphics.draw(this.line);
    }

    public void draw(double x1, double y1, double x2, double y2, Stroke stroke) {
        Stroke defaultStroke = this.graphics.getStroke();
        this.graphics.setStroke(stroke);
        this.draw(x1, y1, x2, y2);
        this.graphics.setStroke(defaultStroke);
    }

    public void draw(String str, double x, double y, double xalign, double yalign) {
        this.draw(str, x, y, xalign, yalign, 0, 0);
    }

    public void draw(String str, double x, double y, double xalign, double yalign, int dx, int dy) {
        this.draw(str, x, y, xalign, yalign, dx, dy, null, null);
    }

    public void draw(String str, double x, double y, double xalign, double yalign, int dx, int dy, Color fgColor, Color bgColor) {
        FontMetrics fm = this.graphics.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(str, this.graphics);
        LineMetrics lm = fm.getLineMetrics(str, this.graphics);
        float w = (float)r.getWidth();
        float h = (float)r.getHeight();
        x = x * this.unitx - (double)w * xalign + (double)dx;
        y = y * this.unity - (double)h * yalign + (double)h - (double)lm.getDescent() + (double)dy;
        if (bgColor != null) {
            this.graphics.setColor(bgColor);
            this.graphics.fillRect((int)x, (int)y - fm.getAscent(), (int)r.getWidth(), (int)r.getHeight());
        }
        if (fgColor != null) {
            this.graphics.setColor(fgColor);
        }
        this.graphics.drawString(str, (float)x, (float)y);
    }

    public void draw(Shape shape, double x, double y) {
        this.draw(shape, x, y, false);
    }

    public void draw(Shape shape, double x, double y, int thickness) {
        Stroke oldStroke = this.graphics.getStroke();
        this.graphics.setStroke(new BasicStroke(thickness));
        this.draw(shape, x, y, false);
        this.graphics.setStroke(oldStroke);
    }

    public void draw(Shape shape, double x, double y, boolean fill) {
        AffineTransform at = new AffineTransform();
        at.scale(this.unitx, this.unity);
        at.translate(x, y);
        GeneralPath gp = new GeneralPath(shape);
        gp.transform(at);
        shape = gp;
        if (fill) {
            this.graphics.fill(shape);
        } else {
            this.graphics.draw(shape);
        }
    }

    public void draw(ImageIcon img, double x, double y, double xalign, double yalign) {
        this.draw(img, x, y, xalign, yalign, 0, 0);
    }

    public void draw(ImageIcon img, double x, double y, double xalign, double yalign, int dx, int dy) {
        int ix = (int)(x * this.unitx - xalign * (double)img.getIconWidth() + (double)dx);
        int iy = (int)(y * this.unity - yalign * (double)img.getIconHeight() + (double)dy);
        img.paintIcon(this.graphics, ix, iy);
    }

    public void popTransformation() {
        this.graphics.setTransform(this.stackTransformations.pop());
    }

    public void pushTransformation() {
        this.stackTransformations.push(this.graphics.getTransform());
    }

    public void pushClip(double x, double y, Rectangle2D r) {
        this.pushClip(x + r.getMinX(), y + r.getMinY(), x + r.getMaxX(), y + r.getMaxY());
    }

    public void pushClip(Rectangle2D r) {
        this.pushClip(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY());
    }

    public void pushClip(double x1, double y1, double x2, double y2) {
        this.clipStack.push(this.graphics.getClip());
        double x = x1 * this.unitx;
        double y = y1 * this.unity;
        double w = x2 * this.unitx - x;
        double h = y2 * this.unity - y;
        this.graphics.clip(new Rectangle2D.Double(x, y, w, h));
    }

    public void popClip() {
        this.graphics.setClip(this.clipStack.pop());
    }

    public Rectangle getRectangle(Rectangle2D bounds) {
        int x1 = (int)Math.ceil(bounds.getMinX() * this.unitx);
        int y1 = (int)Math.ceil(bounds.getMinY() * this.unity);
        int x2 = (int)Math.floor(bounds.getMaxX() * this.unitx);
        int y2 = (int)Math.floor(bounds.getMaxY() * this.unity);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }
}

