/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class PostgreRolePrivilege
extends PostgrePrivilege {
    private static final Log log = Log.getLog(PostgreRolePrivilege.class);
    private PostgrePrivilegeGrant.Kind kind;
    private String schemaName;
    private String objectName;

    public PostgreRolePrivilege(PostgrePrivilegeOwner owner, PostgrePrivilegeGrant.Kind kind, String schemaName, String objectName, List<PostgrePrivilegeGrant> privileges) {
        super(owner, privileges);
        this.kind = kind;
        this.schemaName = schemaName;
        this.objectName = objectName;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.getFullObjectName();
    }

    @Override
    public PostgreObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        PostgreSchema schema = this.owner.getDatabase().getSchema(monitor, this.schemaName);
        if (schema != null) {
            JDBCTable childTable = schema.getChild(monitor, this.objectName);
            return childTable instanceof PostgreObject ? (PostgreObject)childTable : null;
        }
        return null;
    }

    public PostgrePrivilegeGrant.Kind getKind() {
        return this.kind;
    }

    public void setKind(PostgrePrivilegeGrant.Kind kind) {
        this.kind = kind;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getFullObjectName() {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.schemaName)) + (this.kind == PostgrePrivilegeGrant.Kind.SCHEMA ? "" : "." + (this.kind == PostgrePrivilegeGrant.Kind.FUNCTION || this.kind == PostgrePrivilegeGrant.Kind.PROCEDURE ? this.objectName : DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.objectName)));
    }

    public String toString() {
        return this.getFullObjectName();
    }

    @Override
    public int compareTo(@NotNull PostgrePrivilege o) {
        if (o instanceof PostgreRolePrivilege) {
            int res = this.schemaName.compareTo(((PostgreRolePrivilege)o).schemaName);
            return res != 0 ? res : CommonUtils.compare((Object)this.objectName, (Object)((PostgreRolePrivilege)o).objectName);
        }
        return 0;
    }
}

